/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.chrome;

import com.google.common.collect.ImmutableMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.chrome.ChromeBinary;
import org.openqa.selenium.chrome.ChromeNotRunningException;
import org.openqa.selenium.chrome.FatalChromeException;
import org.openqa.selenium.remote.BeanToJsonConverter;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.DriverCommand;
import org.openqa.selenium.remote.JsonToBeanConverter;
import org.openqa.selenium.remote.Response;

public class ChromeCommandExecutor
implements CommandExecutor {
    private static final Logger LOG = Logger.getLogger(ChromeCommandExecutor.class.getName());
    private static final int MAX_START_RETRIES = 5;
    private static final String[] ELEMENT_ID_ARG = new String[]{"id"};
    private static final String[] NO_ARGS = new String[0];
    private final ChromeBinary binary;
    private volatile boolean listen = false;
    ListeningThread listeningThread;
    private Map<DriverCommand, String[]> commands;

    public ChromeCommandExecutor(ChromeBinary binary) {
        this.binary = binary;
        this.commands = ImmutableMap.builder().put((Object)DriverCommand.CLOSE, (Object)NO_ARGS).put((Object)DriverCommand.QUIT, (Object)NO_ARGS).put((Object)DriverCommand.GET, (Object)new String[]{"url"}).put((Object)DriverCommand.GO_BACK, (Object)NO_ARGS).put((Object)DriverCommand.GO_FORWARD, (Object)NO_ARGS).put((Object)DriverCommand.REFRESH, (Object)NO_ARGS).put((Object)DriverCommand.ADD_COOKIE, (Object)new String[]{"cookie"}).put((Object)DriverCommand.GET_ALL_COOKIES, (Object)NO_ARGS).put((Object)DriverCommand.GET_COOKIE, (Object)new String[]{"name"}).put((Object)DriverCommand.DELETE_ALL_COOKIES, (Object)NO_ARGS).put((Object)DriverCommand.DELETE_COOKIE, (Object)new String[]{"name"}).put((Object)DriverCommand.FIND_ELEMENT, (Object)new String[]{"using", "value"}).put((Object)DriverCommand.FIND_ELEMENTS, (Object)new String[]{"using", "value"}).put((Object)DriverCommand.FIND_CHILD_ELEMENT, (Object)new String[]{"id", "using", "value"}).put((Object)DriverCommand.FIND_CHILD_ELEMENTS, (Object)new String[]{"id", "using", "value"}).put((Object)DriverCommand.CLEAR_ELEMENT, (Object)ELEMENT_ID_ARG).put((Object)DriverCommand.CLICK_ELEMENT, (Object)ELEMENT_ID_ARG).put((Object)DriverCommand.HOVER_OVER_ELEMENT, (Object)ELEMENT_ID_ARG).put((Object)DriverCommand.SEND_KEYS_TO_ELEMENT, (Object)new String[]{"id", "value"}).put((Object)DriverCommand.SUBMIT_ELEMENT, (Object)ELEMENT_ID_ARG).put((Object)DriverCommand.TOGGLE_ELEMENT, (Object)ELEMENT_ID_ARG).put((Object)DriverCommand.GET_ELEMENT_ATTRIBUTE, (Object)new String[]{"id", "name"}).put((Object)DriverCommand.GET_ELEMENT_LOCATION_ONCE_SCROLLED_INTO_VIEW, (Object)ELEMENT_ID_ARG).put((Object)DriverCommand.GET_ELEMENT_LOCATION, (Object)ELEMENT_ID_ARG).put((Object)DriverCommand.GET_ELEMENT_SIZE, (Object)ELEMENT_ID_ARG).put((Object)DriverCommand.GET_ELEMENT_TAG_NAME, (Object)ELEMENT_ID_ARG).put((Object)DriverCommand.GET_ELEMENT_TEXT, (Object)ELEMENT_ID_ARG).put((Object)DriverCommand.GET_ELEMENT_VALUE, (Object)ELEMENT_ID_ARG).put((Object)DriverCommand.GET_ELEMENT_VALUE_OF_CSS_PROPERTY, (Object)new String[]{"id", "propertyName"}).put((Object)DriverCommand.IS_ELEMENT_DISPLAYED, (Object)ELEMENT_ID_ARG).put((Object)DriverCommand.IS_ELEMENT_ENABLED, (Object)ELEMENT_ID_ARG).put((Object)DriverCommand.IS_ELEMENT_SELECTED, (Object)ELEMENT_ID_ARG).put((Object)DriverCommand.SET_ELEMENT_SELECTED, (Object)ELEMENT_ID_ARG).put((Object)DriverCommand.GET_ACTIVE_ELEMENT, (Object)NO_ARGS).put((Object)DriverCommand.SWITCH_TO_FRAME, (Object)new String[]{"id"}).put((Object)DriverCommand.GET_CURRENT_WINDOW_HANDLE, (Object)NO_ARGS).put((Object)DriverCommand.GET_WINDOW_HANDLES, (Object)NO_ARGS).put((Object)DriverCommand.SWITCH_TO_WINDOW, (Object)new String[]{"name"}).put((Object)DriverCommand.GET_CURRENT_URL, (Object)NO_ARGS).put((Object)DriverCommand.GET_PAGE_SOURCE, (Object)NO_ARGS).put((Object)DriverCommand.GET_TITLE, (Object)NO_ARGS).put((Object)DriverCommand.EXECUTE_SCRIPT, (Object)new String[]{"script", "args"}).put((Object)DriverCommand.SCREENSHOT, (Object)NO_ARGS).put((Object)DriverCommand.IMPLICITLY_WAIT, (Object)new String[]{"ms"}).build();
    }

    public ChromeBinary getBinary() {
        return this.binary;
    }

    boolean hasClient() {
        return this.listeningThread != null && this.listeningThread.hasClient;
    }

    public int getPort() {
        return this.listeningThread == null ? -1 : this.listeningThread.serverSocket.getLocalPort();
    }

    public Response execute(Command command) throws IOException {
        if (DriverCommand.NEW_SESSION.equals((Object)command.getName())) {
            return this.createCannedNewSessionResponse();
        }
        this.sendCommand(command);
        return this.handleResponse();
    }

    private Response createCannedNewSessionResponse() {
        Map capabilitiesMap;
        Response response = new Response();
        response.setSessionId("[no session]");
        DesiredCapabilities capabilities = DesiredCapabilities.chrome();
        capabilities.setJavascriptEnabled(true);
        try {
            capabilitiesMap = (Map)new JsonToBeanConverter().convert(Map.class, (Object)new BeanToJsonConverter().convert((Object)capabilities));
        }
        catch (WebDriverException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WebDriverException((Throwable)e);
        }
        response.setValue((Object)capabilitiesMap);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCommand(Command command) throws IOException {
        if (!this.hasClient()) {
            throw new IllegalStateException("Cannot execute command without a client");
        }
        String commandStringToSend = this.fillArgs(command);
        byte[] data = this.fillTwoHundredWithJson(commandStringToSend);
        Socket socket = this.getOldestSocket();
        try {
            socket.getOutputStream().write(data);
            socket.getOutputStream().flush();
        }
        finally {
            socket.close();
            this.listeningThread.sockets.remove(socket);
        }
    }

    String fillArgs(Command command) {
        JSONObject json;
        String[] parameterNames = this.commands.get(command.getName());
        if (parameterNames.length != command.getParameters().size()) {
            throw new WebDriverException((Throwable)new IllegalArgumentException("Did not supply the expected number of parameters"));
        }
        try {
            String rawJson = new BeanToJsonConverter().convert((Object)command.getParameters());
            json = new JSONObject(rawJson);
            json.put("request", (Object)command.getName());
            for (String parameterName : parameterNames) {
                if (command.getParameters().containsKey(parameterName)) continue;
                throw new WebDriverException("Missing required parameter \"" + parameterName + "\"");
            }
        }
        catch (JSONException e) {
            throw new WebDriverException((Throwable)e);
        }
        return json.toString();
    }

    private byte[] fillTwoHundredWithJson(String message) {
        return this.fillTwoHundred(message, "application/json; charset=UTF-8");
    }

    private byte[] fillTwoHundred(String message, String contentType) {
        try {
            String httpMessage = "HTTP/1.1 200 OK\r\nContent-Length: " + message.getBytes("UTF-8").length + "\r\nContent-Type: " + contentType + "\r\n\r\n" + message;
            return httpMessage.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new WebDriverException("Your environment doesn't support UTF-8");
        }
    }

    private Response handleResponse() throws IOException {
        String line;
        Socket socket = this.getOldestSocket();
        StringBuilder resultBuilder = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        boolean hasSeenDoubleCRLF = false;
        while ((line = reader.readLine()) != null && !line.equals("EOResponse")) {
            if (hasSeenDoubleCRLF) {
                if (resultBuilder.length() > 0) {
                    resultBuilder.append("\n");
                }
                resultBuilder.append(line);
            }
            if (!line.equals("")) continue;
            hasSeenDoubleCRLF = true;
        }
        try {
            return (Response)new JsonToBeanConverter().convert(Response.class, (Object)resultBuilder.toString());
        }
        catch (WebDriverException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    private Socket getOldestSocket() {
        Socket socket;
        while ((socket = (Socket)this.listeningThread.sockets.peek()) == null) {
            if (!this.binary.isRunning()) {
                throw new ChromeNotRunningException("Chrome is no longer running!");
            }
            Thread.yield();
        }
        return socket;
    }

    public void start() {
        for (int retries = 5; !this.hasClient() && retries > 0; --retries) {
            this.stop();
            this.startListening();
            this.binary.start();
            this.binary.incrementBackoffBy(1);
        }
        this.binary.incrementBackoffBy(-1);
        if (!this.hasClient()) {
            this.stop();
            throw new FatalChromeException("Cannot create chrome driver");
        }
    }

    private void startListening() {
        ServerSocket serverSocket;
        try {
            serverSocket = new ServerSocket(this.binary.getPort());
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
        this.listen = true;
        this.listeningThread = new ListeningThread(serverSocket);
        this.listeningThread.start();
    }

    public void stop() {
        this.binary.kill();
        this.listen = false;
        if (this.listeningThread != null) {
            this.listeningThread.stopListening();
            this.listeningThread = null;
        }
    }

    private class ListeningThread
    extends Thread {
        private boolean isListening = false;
        private Queue<Socket> sockets = new ConcurrentLinkedQueue<Socket>();
        private ServerSocket serverSocket;
        private volatile boolean hasClient = false;

        ListeningThread(ServerSocket serverSocket) {
            this.serverSocket = serverSocket;
        }

        public void run() {
            if (!this.isListening) {
                this.listen();
            }
        }

        public void listen() {
            this.isListening = true;
            try {
                while (ChromeCommandExecutor.this.listen && !this.serverSocket.isClosed()) {
                    Socket acceptedSocket = this.serverSocket.accept();
                    int r = acceptedSocket.getInputStream().read();
                    if (r != 71) {
                        this.sockets.add(acceptedSocket);
                        this.hasClient = true;
                        continue;
                    }
                    this.respondWithHoldingPage(acceptedSocket);
                }
            }
            catch (SocketException e) {
            }
            catch (IOException e) {
                this.isListening = false;
                throw new WebDriverException((Throwable)e);
            }
        }

        private void respondWithHoldingPage(Socket acceptedSocket) throws IOException {
            acceptedSocket.getOutputStream().write(ChromeCommandExecutor.this.fillTwoHundred("<html><head><script type='text/javascript'>if (window.location.search == '') { setTimeout(\"window.location = window.location.href + '?reloaded'\", 5000); }</script></head><body><p>ChromeDriver server started and connected.  Please leave this tab open.</p></body></html>", "Content-Type: text/html"));
            acceptedSocket.getOutputStream().flush();
            acceptedSocket.close();
        }

        public void stopListening() {
            try {
                this.closeCurrentSockets();
            }
            catch (Exception e) {
                throw new WebDriverException((Throwable)e);
            }
            finally {
                try {
                    if (!this.serverSocket.isClosed()) {
                        this.serverSocket.close();
                        while (!this.serverSocket.isClosed()) {
                            Thread.yield();
                        }
                    }
                }
                catch (IOException e) {
                    LOG.log(Level.FINE, "I/O error while closing the server socket", e);
                }
            }
        }

        private void closeCurrentSockets() {
            for (Socket socket : this.sockets) {
                try {
                    socket.close();
                    this.sockets.remove(socket);
                }
                catch (IOException iOException) {}
            }
        }
    }
}

