/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.chrome;

import java.io.File;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.internal.TemporaryFilesystem;

public class ChromeProfile {
    public static final ChromeProfile DEFAULT_PROFILE = new ChromeProfile(new File("WEBDRIVER_DEFAULT_PROFILE"));
    private static final String REAP_PROFILE_PROPERTY = "webdriver.reap_profile";
    private final File directory;
    private Proxy proxy;

    public ChromeProfile(File directory) {
        this.directory = directory;
    }

    public ChromeProfile() {
        this(ChromeProfile.createProfileDir());
    }

    public File getDirectory() {
        return this.directory;
    }

    private static File createProfileDir() {
        File tempProfileDir = TemporaryFilesystem.createTempDir((String)"profile", (String)"");
        System.setProperty(REAP_PROFILE_PROPERTY, "false");
        return tempProfileDir;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ChromeProfile)) {
            return false;
        }
        ChromeProfile other = (ChromeProfile)obj;
        if (this.directory == null && other.directory != null || this.directory != null && !this.directory.equals(other.directory)) {
            return false;
        }
        return (this.proxy != null || other.proxy == null) && (this.proxy == null || this.proxy.equals(other.proxy));
    }
}

