/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.chrome;

import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openqa.selenium.Beta;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.chrome.AddHasCasting;
import org.openqa.selenium.chrome.AddHasCdp;
import org.openqa.selenium.chrome.ChromeDriverService;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.chromium.ChromiumDriver;
import org.openqa.selenium.chromium.ChromiumDriverCommandExecutor;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.manager.SeleniumManagerOutput;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.RemoteWebDriverBuilder;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.service.DriverFinder;
import org.openqa.selenium.remote.service.DriverService;

public class ChromeDriver
extends ChromiumDriver {
    public ChromeDriver() {
        this(ChromeDriverService.createDefaultService(), new ChromeOptions());
    }

    public ChromeDriver(ChromeDriverService service) {
        this(service, new ChromeOptions());
    }

    public ChromeDriver(ChromeOptions options) {
        this(ChromeDriverService.createDefaultService(), options);
    }

    public ChromeDriver(ChromeDriverService service, ChromeOptions options) {
        this(service, options, ClientConfig.defaultConfig());
    }

    public ChromeDriver(ChromeDriverService service, ChromeOptions options, ClientConfig clientConfig) {
        super((CommandExecutor)ChromeDriver.generateExecutor(service, options, clientConfig), (Capabilities)options, "goog:chromeOptions");
        this.casting = new AddHasCasting().getImplementation(this.getCapabilities(), this.getExecuteMethod());
        this.cdp = new AddHasCdp().getImplementation(this.getCapabilities(), this.getExecuteMethod());
    }

    private static ChromeDriverCommandExecutor generateExecutor(ChromeDriverService service, ChromeOptions options, ClientConfig clientConfig) {
        Require.nonNull((String)"Driver service", (Object)((Object)service));
        Require.nonNull((String)"Driver options", (Object)((Object)options));
        Require.nonNull((String)"Driver clientConfig", (Object)clientConfig);
        if (service.getExecutable() == null) {
            SeleniumManagerOutput.Result result = DriverFinder.getPath((DriverService)service, (Capabilities)options);
            service.setExecutable(result.getDriverPath());
            if (result.getBrowserPath() != null && !result.getBrowserPath().isEmpty()) {
                options.setBinary(result.getBrowserPath());
            }
        }
        return new ChromeDriverCommandExecutor(service, clientConfig);
    }

    @Beta
    public static RemoteWebDriverBuilder builder() {
        return RemoteWebDriver.builder().oneOf((Capabilities)new ChromeOptions(), new Capabilities[0]);
    }

    private static class ChromeDriverCommandExecutor
    extends ChromiumDriverCommandExecutor {
        public ChromeDriverCommandExecutor(DriverService service, ClientConfig clientConfig) {
            super(service, ChromeDriverCommandExecutor.getExtraCommands(), clientConfig);
        }

        private static Map<String, CommandInfo> getExtraCommands() {
            return Stream.of(new AddHasCasting().getAdditionalCommands(), new AddHasCdp().getAdditionalCommands()).flatMap(m -> m.entrySet().stream()).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
        }
    }
}

