/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.chromium;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.BuildInfo;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Credentials;
import org.openqa.selenium.HasAuthentication;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.PersistentCapabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.bidi.BiDi;
import org.openqa.selenium.bidi.BiDiException;
import org.openqa.selenium.bidi.Connection;
import org.openqa.selenium.bidi.HasBiDi;
import org.openqa.selenium.chromium.AddHasLaunchApp;
import org.openqa.selenium.chromium.AddHasNetworkConditions;
import org.openqa.selenium.chromium.AddHasPermissions;
import org.openqa.selenium.chromium.ChromiumNetworkConditions;
import org.openqa.selenium.chromium.HasCasting;
import org.openqa.selenium.chromium.HasCdp;
import org.openqa.selenium.chromium.HasLaunchApp;
import org.openqa.selenium.chromium.HasNetworkConditions;
import org.openqa.selenium.chromium.HasPermissions;
import org.openqa.selenium.devtools.CdpEndpointFinder;
import org.openqa.selenium.devtools.CdpInfo;
import org.openqa.selenium.devtools.CdpVersionFinder;
import org.openqa.selenium.devtools.DevTools;
import org.openqa.selenium.devtools.HasDevTools;
import org.openqa.selenium.devtools.noop.NoOpCdpInfo;
import org.openqa.selenium.html5.LocalStorage;
import org.openqa.selenium.html5.Location;
import org.openqa.selenium.html5.LocationContext;
import org.openqa.selenium.html5.SessionStorage;
import org.openqa.selenium.html5.WebStorage;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.logging.EventType;
import org.openqa.selenium.logging.HasLogEvents;
import org.openqa.selenium.mobile.NetworkConnection;
import org.openqa.selenium.remote.Browser;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.html5.RemoteLocationContext;
import org.openqa.selenium.remote.html5.RemoteWebStorage;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.ConnectionFailedException;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.mobile.RemoteNetworkConnection;

public class ChromiumDriver
extends RemoteWebDriver
implements HasAuthentication,
HasBiDi,
HasCasting,
HasCdp,
HasDevTools,
HasLaunchApp,
HasLogEvents,
HasNetworkConditions,
HasPermissions,
LocationContext,
NetworkConnection,
WebStorage {
    public static final Predicate<String> IS_CHROMIUM_BROWSER = name -> Browser.CHROME.is(name) || Browser.EDGE.is(name) || Browser.OPERA.is(name);
    private static final Logger LOG = Logger.getLogger(ChromiumDriver.class.getName());
    private final Capabilities capabilities;
    private final RemoteLocationContext locationContext = new RemoteLocationContext(this.getExecuteMethod());
    private final RemoteWebStorage webStorage = new RemoteWebStorage(this.getExecuteMethod());
    private final RemoteNetworkConnection networkConnection;
    private final HasNetworkConditions networkConditions;
    private final HasPermissions permissions = new AddHasPermissions().getImplementation(this.getCapabilities(), this.getExecuteMethod());
    private final HasLaunchApp launch;
    private Optional<org.openqa.selenium.devtools.Connection> connection;
    private final Optional<DevTools> devTools;
    private final Optional<URI> biDiUri;
    private final Optional<BiDi> biDi;
    protected HasCasting casting;
    protected HasCdp cdp;

    protected ChromiumDriver(CommandExecutor commandExecutor, Capabilities capabilities, String capabilityKey) {
        super(commandExecutor, capabilities);
        Optional<Object> cdpUri;
        this.networkConnection = new RemoteNetworkConnection(this.getExecuteMethod());
        this.networkConditions = new AddHasNetworkConditions().getImplementation(this.getCapabilities(), this.getExecuteMethod());
        this.launch = new AddHasLaunchApp().getImplementation(this.getCapabilities(), this.getExecuteMethod());
        HttpClient.Factory factory = HttpClient.Factory.createDefault();
        Capabilities originalCapabilities = super.getCapabilities();
        Optional<String> webSocketUrl = Optional.ofNullable((String)originalCapabilities.getCapability("webSocketUrl"));
        this.biDiUri = webSocketUrl.map(uri -> {
            try {
                return new URI((String)uri);
            }
            catch (URISyntaxException e) {
                LOG.warning(e.getMessage());
                return null;
            }
        });
        this.biDi = this.createBiDi(this.biDiUri);
        Optional reportedUri = CdpEndpointFinder.getReportedUri((String)capabilityKey, (Capabilities)originalCapabilities);
        Optional<HttpClient> client = reportedUri.map(uri -> CdpEndpointFinder.getHttpClient((HttpClient.Factory)factory, (URI)uri));
        try {
            try {
                cdpUri = client.flatMap(httpClient -> CdpEndpointFinder.getCdpEndPoint((HttpClient)httpClient));
            }
            catch (Exception e) {
                try {
                    client.ifPresent(HttpClient::close);
                }
                catch (Exception ex) {
                    e.addSuppressed(ex);
                }
                throw e;
            }
            this.connection = cdpUri.map(uri -> new org.openqa.selenium.devtools.Connection((HttpClient)client.get(), uri.toString()));
        }
        catch (ConnectionFailedException e) {
            cdpUri = Optional.empty();
            LOG.log(Level.WARNING, "Unable to establish websocket connection to " + reportedUri.get(), e);
            this.connection = Optional.empty();
        }
        CdpInfo cdpInfo = new CdpVersionFinder().match(originalCapabilities.getBrowserVersion()).orElseGet(() -> {
            LOG.warning(String.format("Unable to find version of CDP to use for %s. You may need to include a dependency on a specific version of the CDP using something similar to `org.seleniumhq.selenium:selenium-devtools-v86:%s` where the version (\"v86\") matches the version of the chromium-based browser you're using and the version number of the artifact is the same as Selenium's.", originalCapabilities.getBrowserVersion(), new BuildInfo().getReleaseLabel()));
            return new NoOpCdpInfo();
        });
        this.devTools = this.connection.map(conn -> new DevTools(arg_0 -> ((CdpInfo)cdpInfo).getDomains(arg_0), conn));
        this.capabilities = (Capabilities)cdpUri.map(uri -> new ImmutableCapabilities((Capabilities)new PersistentCapabilities(originalCapabilities).setCapability("se:cdp", (Object)uri.toString()).setCapability("se:cdpVersion", (Object)originalCapabilities.getBrowserVersion()))).orElse(new ImmutableCapabilities(originalCapabilities));
    }

    public Capabilities getCapabilities() {
        return this.capabilities;
    }

    public void setFileDetector(FileDetector detector) {
        throw new WebDriverException("Setting the file detector only works on remote webdriver instances obtained via RemoteWebDriver");
    }

    public <X> void onLogEvent(EventType<X> kind) {
        Require.nonNull((String)"Event type", kind);
        kind.initializeListener((WebDriver)this);
    }

    public void register(Predicate<URI> whenThisMatches, Supplier<Credentials> useTheseCredentials) {
        Require.nonNull((String)"Check to use to see how we should authenticate", whenThisMatches);
        Require.nonNull((String)"Credentials to use when authenticating", useTheseCredentials);
        this.getDevTools().createSessionIfThereIsNotOne(this.getWindowHandle());
        this.getDevTools().getDomains().network().addAuthHandler(whenThisMatches, useTheseCredentials);
    }

    public LocalStorage getLocalStorage() {
        return this.webStorage.getLocalStorage();
    }

    public SessionStorage getSessionStorage() {
        return this.webStorage.getSessionStorage();
    }

    public Location location() {
        return this.locationContext.location();
    }

    public void setLocation(Location location) {
        Require.nonNull((String)"Location", (Object)location);
        this.locationContext.setLocation(location);
    }

    public NetworkConnection.ConnectionType getNetworkConnection() {
        return this.networkConnection.getNetworkConnection();
    }

    public NetworkConnection.ConnectionType setNetworkConnection(NetworkConnection.ConnectionType type) {
        Require.nonNull((String)"Network Connection Type", (Object)type);
        return this.networkConnection.setNetworkConnection(type);
    }

    @Override
    public void launchApp(String id) {
        Require.nonNull((String)"Launch App ID", (Object)id);
        this.launch.launchApp(id);
    }

    @Override
    public Map<String, Object> executeCdpCommand(String commandName, Map<String, Object> parameters) {
        Require.nonNull((String)"Command Name", (Object)commandName);
        return this.cdp.executeCdpCommand(commandName, parameters);
    }

    public Optional<DevTools> maybeGetDevTools() {
        return this.devTools;
    }

    private Optional<BiDi> createBiDi(Optional<URI> biDiUri) {
        if (!biDiUri.isPresent()) {
            return Optional.empty();
        }
        URI wsUri = biDiUri.orElseThrow(() -> new BiDiException("This version of Chromium driver does not support BiDi"));
        HttpClient.Factory clientFactory = HttpClient.Factory.createDefault();
        ClientConfig wsConfig = ClientConfig.defaultConfig().baseUri(wsUri);
        HttpClient wsClient = clientFactory.createClient(wsConfig);
        Connection biDiConnection = new Connection(wsClient, wsUri.toString());
        return Optional.of(new BiDi(biDiConnection));
    }

    public Optional<BiDi> maybeGetBiDi() {
        return this.biDi;
    }

    @Override
    public List<Map<String, String>> getCastSinks() {
        return this.casting.getCastSinks();
    }

    @Override
    public String getCastIssueMessage() {
        return this.casting.getCastIssueMessage();
    }

    @Override
    public void selectCastSink(String deviceName) {
        Require.nonNull((String)"Device Name", (Object)deviceName);
        this.casting.selectCastSink(deviceName);
    }

    @Override
    public void startDesktopMirroring(String deviceName) {
        Require.nonNull((String)"Device Name", (Object)deviceName);
        this.casting.startDesktopMirroring(deviceName);
    }

    @Override
    public void startTabMirroring(String deviceName) {
        Require.nonNull((String)"Device Name", (Object)deviceName);
        this.casting.startTabMirroring(deviceName);
    }

    @Override
    public void stopCasting(String deviceName) {
        Require.nonNull((String)"Device Name", (Object)deviceName);
        this.casting.stopCasting(deviceName);
    }

    @Override
    public void setPermission(String name, String value) {
        Require.nonNull((String)"Permission Name", (Object)name);
        Require.nonNull((String)"Permission Value", (Object)value);
        this.permissions.setPermission(name, value);
    }

    @Override
    public ChromiumNetworkConditions getNetworkConditions() {
        return this.networkConditions.getNetworkConditions();
    }

    @Override
    public void setNetworkConditions(ChromiumNetworkConditions networkConditions) {
        Require.nonNull((String)"Network Conditions", (Object)networkConditions);
        this.networkConditions.setNetworkConditions(networkConditions);
    }

    @Override
    public void deleteNetworkConditions() {
        this.networkConditions.deleteNetworkConditions();
    }

    public void quit() {
        super.quit();
    }
}

