/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import junit.framework.TestCase;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsNot;
import org.openqa.selenium.NeedsDriver;
import org.openqa.selenium.Pages;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.environment.GlobalTestEnvironment;
import org.openqa.selenium.environment.TestEnvironment;
import org.openqa.selenium.environment.webserver.AppServer;

public class AbstractDriverTestCase
extends TestCase
implements NeedsDriver {
    protected TestEnvironment environment;
    protected AppServer appServer;
    protected WebDriver driver;
    protected Pages pages;

    public void setDriver(WebDriver driver) {
        this.driver = driver;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.environment = GlobalTestEnvironment.get();
        this.appServer = this.environment.getAppServer();
        this.pages = new Pages(this.appServer);
        String hostName = this.environment.getAppServer().getHostName();
        String alternateHostName = this.environment.getAppServer().getAlternateHostName();
        MatcherAssert.assertThat((Object)hostName, (Matcher)Matchers.is((Matcher)IsNot.not((Matcher)Matchers.equalTo((Object)alternateHostName))));
    }

    protected boolean isIeDriverTimedOutException(IllegalStateException e) {
        return e.getClass().getName().contains("TimedOutException");
    }

    protected boolean browserNeedsFocusOnThisOs(WebDriver driver) {
        if (Platform.getCurrent().is(Platform.WINDOWS)) {
            return false;
        }
        if (Boolean.getBoolean("webdriver.focus.override")) {
            return false;
        }
        String browserName = this.getBrowserName(driver);
        return browserName.toLowerCase().contains("firefox");
    }

    private String getBrowserName(WebDriver driver) {
        try {
            Method getCapabilities = driver.getClass().getMethod("getCapabilities", new Class[0]);
            Object capabilities = getCapabilities.invoke((Object)driver, new Object[0]);
            return (String)capabilities.getClass().getMethod("getBrowserName", new Class[0]).invoke(capabilities, new Object[0]);
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return driver.getClass().getName();
    }
}

