/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.lang.reflect.Method;
import org.openqa.selenium.AbstractDriverTestCase;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.Ignore;
import org.openqa.selenium.JavascriptEnabled;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.UnhandledAlertException;
import org.openqa.selenium.WebDriver;

public class AlertsTest
extends AbstractDriverTestCase {
    private String alertPage;

    protected void setUp() throws Exception {
        super.setUp();
        this.alertPage = this.environment.getAppServer().whereIs("alerts.html");
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.ANDROID, Ignore.Driver.CHROME, Ignore.Driver.HTMLUNIT, Ignore.Driver.IE, Ignore.Driver.IPHONE, Ignore.Driver.REMOTE, Ignore.Driver.SELENESE})
    public void testShouldBeAbleToOverrideTheWindowAlertMethod() {
        this.driver.get(this.alertPage);
        ((JavascriptExecutor)this.driver).executeScript("window.alert = function(msg) { document.getElementById('text').innerHTML = msg; }", new Object[0]);
        this.driver.findElement(By.id((String)"alert")).click();
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.ANDROID, Ignore.Driver.CHROME, Ignore.Driver.HTMLUNIT, Ignore.Driver.IE, Ignore.Driver.IPHONE, Ignore.Driver.REMOTE, Ignore.Driver.SELENESE})
    public void testShouldAllowUsersToAcceptAnAlertManually() throws InterruptedException {
        this.driver.get(this.alertPage);
        this.driver.findElement(By.id((String)"alert")).click();
        Alert alert = this.switchToAlert(this.driver);
        alert.accept();
        AlertsTest.assertEquals((String)"Testing Alerts", (String)this.driver.getTitle());
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.ANDROID, Ignore.Driver.CHROME, Ignore.Driver.HTMLUNIT, Ignore.Driver.IE, Ignore.Driver.IPHONE, Ignore.Driver.REMOTE, Ignore.Driver.SELENESE})
    public void testShouldAllowUsersToDismissAnAlertManually() {
        this.driver.get(this.alertPage);
        this.driver.findElement(By.id((String)"alert")).click();
        Alert alert = this.switchToAlert(this.driver);
        alert.dismiss();
        AlertsTest.assertEquals((String)"Testing Alerts", (String)this.driver.getTitle());
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.ANDROID, Ignore.Driver.CHROME, Ignore.Driver.HTMLUNIT, Ignore.Driver.IE, Ignore.Driver.IPHONE, Ignore.Driver.REMOTE, Ignore.Driver.SELENESE})
    public void testShouldAllowAUserToAcceptAPrompt() {
        this.driver.get(this.alertPage);
        this.driver.findElement(By.id((String)"prompt")).click();
        Alert alert = this.switchToAlert(this.driver);
        alert.accept();
        AlertsTest.assertEquals((String)"Testing Alerts", (String)this.driver.getTitle());
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.ANDROID, Ignore.Driver.CHROME, Ignore.Driver.HTMLUNIT, Ignore.Driver.IE, Ignore.Driver.IPHONE, Ignore.Driver.REMOTE, Ignore.Driver.SELENESE})
    public void testShouldAllowAUserToDismissAPrompt() {
        this.driver.get(this.alertPage);
        this.driver.findElement(By.id((String)"prompt")).click();
        Alert alert = this.switchToAlert(this.driver);
        alert.dismiss();
        AlertsTest.assertEquals((String)"Testing Alerts", (String)this.driver.getTitle());
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.ANDROID, Ignore.Driver.CHROME, Ignore.Driver.HTMLUNIT, Ignore.Driver.IE, Ignore.Driver.IPHONE, Ignore.Driver.REMOTE, Ignore.Driver.SELENESE})
    public void testShouldAllowAUserToSetTheValueOfAPrompt() {
        this.driver.get(this.alertPage);
        this.driver.findElement(By.id((String)"prompt")).click();
        Alert alert = this.switchToAlert(this.driver);
        alert.sendKeys("cheese");
        alert.accept();
        String result = this.driver.findElement(By.id((String)"text")).getText();
        AlertsTest.assertEquals((String)"cheese", (String)result);
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.ANDROID, Ignore.Driver.CHROME, Ignore.Driver.HTMLUNIT, Ignore.Driver.IE, Ignore.Driver.IPHONE, Ignore.Driver.REMOTE, Ignore.Driver.SELENESE})
    public void testShouldAllowTheUserToGetTheTextOfAnAlert() {
        this.driver.get(this.alertPage);
        this.driver.findElement(By.id((String)"alert")).click();
        Alert alert = this.switchToAlert(this.driver);
        String value = alert.getText();
        alert.accept();
        AlertsTest.assertEquals((String)"cheese", (String)value);
    }

    @Ignore
    public void testShouldThrowAnExceptionIfAnAlertHasNotBeenDealtWith() {
        this.driver.get(this.alertPage);
        this.driver.findElement(By.id((String)"alert")).click();
        try {
            this.driver.getTitle();
        }
        catch (UnhandledAlertException unhandledAlertException) {
            // empty catch block
        }
        AlertsTest.assertEquals((String)"Testing Alerts", (String)this.driver.getTitle());
    }

    private Alert switchToAlert(WebDriver driver) {
        WebDriver.TargetLocator locator = driver.switchTo();
        try {
            Method alertMethod = locator.getClass().getMethod("alert", new Class[0]);
            alertMethod.setAccessible(true);
            return (Alert)alertMethod.invoke((Object)locator, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

