/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.openqa.selenium.Platform;
import org.openqa.selenium.internal.InProject;

public class Build {
    private List<String> targets = new ArrayList<String>();

    public Build() {
        String command = Platform.getCurrent().is(Platform.WINDOWS) ? "go.bat" : "./go";
        this.targets.add(command);
    }

    public Build of(String ... targets) {
        this.targets.addAll(Arrays.asList(targets));
        return this;
    }

    public void go() {
        System.out.println("Running " + this.targets);
        ProcessBuilder builder = new ProcessBuilder(this.targets);
        builder.directory(InProject.locate("Rakefile").getParentFile());
        try {
            this.executeBuild(builder);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Cannot build");
        }
    }

    private void executeBuild(ProcessBuilder builder) throws Exception {
        Process process = builder.start();
        int exitValue = process.waitFor();
        if (exitValue != 0) {
            Assert.fail((String)"Unable to build artifacts");
        }
    }
}

