/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.net.URI;
import java.util.Date;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import org.openqa.selenium.AbstractDriverTestCase;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.Ignore;
import org.openqa.selenium.JavascriptEnabled;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.environment.GlobalTestEnvironment;
import org.openqa.selenium.environment.webserver.AppServer;

@Ignore(value={Ignore.Driver.IE}, reason="Nukes the JVM")
public class CookieImplementationTest
extends AbstractDriverTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        this.driver.get(this.pages.simpleTestPage);
        this.driver.manage().deleteAllCookies();
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.SELENESE})
    public void testShouldGetCookieByName() {
        String key = String.format("key_%d", new Random().nextInt());
        ((JavascriptExecutor)this.driver).executeScript("document.cookie = arguments[0] + '=set';", new Object[]{key});
        Cookie cookie = this.driver.manage().getCookieNamed(key);
        CookieImplementationTest.assertEquals((String)"set", (String)cookie.getValue());
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.SELENESE})
    public void testShouldBeAbleToAddCookie() {
        String key = String.format("key_%d", new Random().nextInt());
        Cookie cookie = new Cookie(key, "foo");
        ((JavascriptExecutor)this.driver).executeScript("return document.cookie", new Object[0]);
        this.driver.manage().addCookie(cookie);
        String current = (String)((JavascriptExecutor)this.driver).executeScript("return document.cookie", new Object[0]);
        CookieImplementationTest.assertTrue((boolean)current.contains(key));
    }

    @Ignore(value={Ignore.Driver.SELENESE})
    public void testGetAllCookies() {
        Random random = new Random();
        String key1 = String.format("key_%d", random.nextInt());
        String key2 = String.format("key_%d", random.nextInt());
        Set cookies = this.driver.manage().getCookies();
        int count = cookies.size();
        Cookie one = new Cookie(key1, "value");
        Cookie two = new Cookie(key2, "value");
        this.driver.manage().addCookie(one);
        this.driver.manage().addCookie(two);
        this.driver.get(this.pages.simpleTestPage);
        cookies = this.driver.manage().getCookies();
        CookieImplementationTest.assertEquals((int)(count + 2), (int)cookies.size());
        CookieImplementationTest.assertTrue((boolean)cookies.contains(one));
        CookieImplementationTest.assertTrue((boolean)cookies.contains(two));
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.SELENESE})
    public void testDeleteAllCookies() {
        ((JavascriptExecutor)this.driver).executeScript("document.cookie = 'foo=set';", new Object[0]);
        int count = this.driver.manage().getCookies().size();
        CookieImplementationTest.assertTrue((count > 0 ? 1 : 0) != 0);
        this.driver.manage().deleteAllCookies();
        Set cookies = this.driver.manage().getCookies();
        count = cookies.size();
        CookieImplementationTest.assertTrue((String)cookies.toString(), (count == 0 ? 1 : 0) != 0);
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.SELENESE})
    public void testDeleteCookieWithName() {
        Random random = new Random();
        String key1 = String.format("key_%d", random.nextInt());
        String key2 = String.format("key_%d", random.nextInt());
        ((JavascriptExecutor)this.driver).executeScript("document.cookie = arguments[0] + '=set';", new Object[]{key1});
        ((JavascriptExecutor)this.driver).executeScript("document.cookie = arguments[0] + '=set';", new Object[]{key2});
        CookieImplementationTest.assertNotNull((Object)this.driver.manage().getCookieNamed(key1));
        CookieImplementationTest.assertNotNull((Object)this.driver.manage().getCookieNamed(key2));
        this.driver.manage().deleteCookieNamed(key1);
        Set cookies = this.driver.manage().getCookies();
        CookieImplementationTest.assertNull((String)cookies.toString(), (Object)this.driver.manage().getCookieNamed(key1));
        CookieImplementationTest.assertNotNull((String)cookies.toString(), (Object)this.driver.manage().getCookieNamed(key2));
    }

    @Ignore(value={Ignore.Driver.SELENESE})
    public void testShouldNotDeleteCookiesWithASimilarName() {
        String cookieOneName = "fish";
        Cookie cookie1 = new Cookie(cookieOneName, "cod");
        Cookie cookie2 = new Cookie(cookieOneName + "x", "earth");
        WebDriver.Options options = this.driver.manage();
        options.addCookie(cookie1);
        options.addCookie(cookie2);
        options.deleteCookieNamed(cookieOneName);
        Set cookies = options.getCookies();
        CookieImplementationTest.assertFalse((String)cookies.toString(), (boolean)cookies.contains(cookie1));
        CookieImplementationTest.assertTrue((String)cookies.toString(), (boolean)cookies.contains(cookie2));
    }

    @Ignore(value={Ignore.Driver.SELENESE})
    public void testAddCookiesWithDifferentPathsThatAreRelatedToOurs() {
        this.driver.get(this.pages.simpleTestPage);
        this.driver.manage().deleteAllCookies();
        Cookie cookie1 = new Cookie("fish", "cod", "/common/animals");
        Cookie cookie2 = new Cookie("planet", "earth", "/common/");
        WebDriver.Options options = this.driver.manage();
        options.addCookie(cookie1);
        options.addCookie(cookie2);
        AppServer appServer = GlobalTestEnvironment.get().getAppServer();
        this.driver.get(appServer.whereIs("animals"));
        Set cookies = options.getCookies();
        CookieImplementationTest.assertTrue((String)("Supposed to contain cookie1 (" + cookie1 + ") but has: " + cookies.toString()), (boolean)cookies.contains(cookie1));
        CookieImplementationTest.assertTrue((boolean)cookies.contains(cookie2));
        this.driver.get(appServer.whereIs(""));
        cookies = options.getCookies();
        CookieImplementationTest.assertFalse((String)cookies.toString(), (boolean)cookies.contains(cookie1));
        CookieImplementationTest.assertTrue((String)cookies.toString(), (boolean)cookies.contains(cookie2));
    }

    @Ignore(value={Ignore.Driver.SELENESE})
    public void testCanSetCookiesOnADifferentPathOfTheSameHost() {
        Cookie cookie1 = new Cookie("fish", "cod", "/common/animals");
        Cookie cookie2 = new Cookie("planet", "earth", "/common/galaxy");
        WebDriver.Options options = this.driver.manage();
        options.addCookie(cookie1);
        options.addCookie(cookie2);
        AppServer appServer = GlobalTestEnvironment.get().getAppServer();
        this.driver.get(appServer.whereIs("animals"));
        Set cookies = options.getCookies();
        CookieImplementationTest.assertTrue((String)cookies.toString(), (boolean)cookies.contains(cookie1));
        CookieImplementationTest.assertFalse((String)cookies.toString(), (boolean)cookies.contains(cookie2));
        this.driver.get(appServer.whereIs("galaxy"));
        cookies = options.getCookies();
        CookieImplementationTest.assertFalse((boolean)cookies.contains(cookie1));
        CookieImplementationTest.assertTrue((boolean)cookies.contains(cookie2));
    }

    @Ignore(value={Ignore.Driver.SELENESE})
    public void testShouldNotBeAbleToSetDomainToSomethingThatIsUnrelatedToTheCurrentDomain() {
        Cookie cookie1 = new Cookie("fish", "cod");
        WebDriver.Options options = this.driver.manage();
        options.addCookie(cookie1);
        String url = GlobalTestEnvironment.get().getAppServer().whereElseIs("simpleTest.html");
        this.driver.get(url);
        Cookie cookie = options.getCookieNamed("fish");
        CookieImplementationTest.assertNull((String)String.valueOf(cookie), (Object)cookie);
    }

    @Ignore(value={Ignore.Driver.SELENESE, Ignore.Driver.IE})
    public void testShouldBeAbleToAddToADomainWhichIsRelatedToTheCurrentDomain() {
        String name = this.gotoValidDomainAndClearCookies();
        if (name == null || name.matches("\\d{1,3}(?:\\.\\d{1,3}){3}")) {
            System.out.println("Skipping test: unable to find domain name to use");
            return;
        }
        CookieImplementationTest.assertNull((Object)this.driver.manage().getCookieNamed("name"));
        String shorter = name.replaceFirst(".*?\\.", "");
        Cookie cookie = new Cookie("name", "value", shorter, "/", new Date(System.currentTimeMillis() + 100000L));
        this.driver.manage().addCookie(cookie);
        CookieImplementationTest.assertNotNull((Object)this.driver.manage().getCookieNamed("name"));
    }

    @Ignore(value={Ignore.Driver.REMOTE, Ignore.Driver.SELENESE, Ignore.Driver.IE})
    public void testShouldBeAbleToIncludeLeadingPeriodInDomainName() throws Exception {
        String name = this.gotoValidDomainAndClearCookies();
        if (name == null || name.matches("\\d{1,3}(?:\\.\\d{1,3}){3}")) {
            System.out.println("Skipping test: unable to find domain name to use");
            return;
        }
        this.driver.manage().deleteAllCookies();
        CookieImplementationTest.assertNull((String)"Looks like delete all cookies doesn't", (Object)this.driver.manage().getCookieNamed("name"));
        String shorter = name.replaceFirst(".*?\\.", ".");
        Cookie cookie = new Cookie("name", "value", shorter, "/", new Date(System.currentTimeMillis() + 100000L));
        this.driver.manage().addCookie(cookie);
        CookieImplementationTest.assertNotNull((Object)this.driver.manage().getCookieNamed("name"));
    }

    @Ignore(value={Ignore.Driver.SELENESE})
    public void testGetCookieDoesNotRetriveBeyondCurrentDomain() {
        Cookie cookie1 = new Cookie("fish", "cod");
        WebDriver.Options options = this.driver.manage();
        options.addCookie(cookie1);
        String url = GlobalTestEnvironment.get().getAppServer().whereElseIs("");
        this.driver.get(url);
        Set cookies = options.getCookies();
        CookieImplementationTest.assertFalse((boolean)cookies.contains(cookie1));
    }

    @Ignore(value={Ignore.Driver.IE, Ignore.Driver.SELENESE})
    public void testShouldBeAbleToSetDomainToTheCurrentDomain() throws Exception {
        URI url = new URI(this.driver.getCurrentUrl());
        String host = url.getHost() + ":" + url.getPort();
        Cookie cookie1 = new Cookie.Builder("fish", "cod").domain(host).build();
        WebDriver.Options options = this.driver.manage();
        options.addCookie(cookie1);
        this.driver.get(this.pages.javascriptPage);
        Set cookies = options.getCookies();
        CookieImplementationTest.assertTrue((boolean)cookies.contains(cookie1));
    }

    @Ignore(value={Ignore.Driver.SELENESE})
    public void testShouldWalkThePathToDeleteACookie() {
        Cookie cookie1 = new Cookie("fish", "cod");
        this.driver.manage().addCookie(cookie1);
        this.driver.get(this.pages.childPage);
        Cookie cookie2 = new Cookie("rodent", "hamster", "/common/child");
        this.driver.manage().addCookie(cookie2);
        this.driver.get(this.pages.grandchildPage);
        Cookie cookie3 = new Cookie("dog", "dalmation", "/common/child/grandchild/");
        this.driver.manage().addCookie(cookie3);
        this.driver.get(GlobalTestEnvironment.get().getAppServer().whereIs("child/grandchild"));
        this.driver.manage().deleteCookieNamed("rodent");
        CookieImplementationTest.assertNull((String)this.driver.manage().getCookies().toString(), (Object)this.driver.manage().getCookieNamed("rodent"));
        Set cookies = this.driver.manage().getCookies();
        CookieImplementationTest.assertEquals((int)2, (int)cookies.size());
        CookieImplementationTest.assertTrue((boolean)cookies.contains(cookie1));
        CookieImplementationTest.assertTrue((boolean)cookies.contains(cookie3));
        this.driver.manage().deleteAllCookies();
        this.driver.get(this.pages.grandchildPage);
        cookies = this.driver.manage().getCookies();
        CookieImplementationTest.assertEquals((int)0, (int)cookies.size());
    }

    @Ignore(value={Ignore.Driver.IE, Ignore.Driver.SELENESE})
    public void testShouldIgnoreThePortNumberOfTheHostWhenSettingTheCookie() throws Exception {
        URI uri = new URI(this.driver.getCurrentUrl());
        String host = String.format("%s:%d", uri.getHost(), uri.getPort());
        CookieImplementationTest.assertNull((Object)this.driver.manage().getCookieNamed("name"));
        Cookie cookie = new Cookie.Builder("name", "value").domain(host).build();
        this.driver.manage().addCookie(cookie);
        CookieImplementationTest.assertNotNull((Object)this.driver.manage().getCookieNamed("name"));
    }

    @Ignore(value={Ignore.Driver.SELENESE, Ignore.Driver.IE})
    public void testCookieIntegrity() {
        String url = GlobalTestEnvironment.get().getAppServer().whereElseIs("animals");
        this.driver.get(url);
        this.driver.manage().deleteAllCookies();
        long time = System.currentTimeMillis() + 86400L;
        Cookie cookie1 = new Cookie("fish", "cod", "/common/animals", new Date(time));
        WebDriver.Options options = this.driver.manage();
        options.addCookie(cookie1);
        Set cookies = options.getCookies();
        Iterator iter = cookies.iterator();
        Cookie retrievedCookie = null;
        while (iter.hasNext()) {
            Cookie temp = (Cookie)iter.next();
            if (!cookie1.equals((Object)temp)) continue;
            retrievedCookie = temp;
            break;
        }
        CookieImplementationTest.assertNotNull(retrievedCookie);
        CookieImplementationTest.assertEquals((Object)cookie1, retrievedCookie);
    }

    @Ignore(value={Ignore.Driver.ANDROID, Ignore.Driver.IE, Ignore.Driver.SELENESE}, reason="Chrome and Selenium, which use JavaScript to retrieve cookies, cannot return expiry info; Other suppressed browsers have not been tested.")
    public void testRetainsCookieExpiry() {
        String url = GlobalTestEnvironment.get().getAppServer().whereElseIs("animals");
        this.driver.get(url);
        this.driver.manage().deleteAllCookies();
        long time = System.currentTimeMillis() + 86400L;
        Cookie cookie1 = new Cookie("fish", "cod", "/common/animals", new Date(time));
        WebDriver.Options options = this.driver.manage();
        options.addCookie(cookie1);
        Cookie retrieved = options.getCookieNamed("fish");
        CookieImplementationTest.assertNotNull((Object)retrieved);
        CookieImplementationTest.assertEquals((Object)cookie1.getExpiry(), (Object)retrieved.getExpiry());
    }

    @Ignore(value={Ignore.Driver.ANDROID, Ignore.Driver.IE, Ignore.Driver.SELENESE}, reason="Untested")
    public void testSettingACookieThatExpiredInThePast() {
        String url = GlobalTestEnvironment.get().getAppServer().whereElseIs("animals");
        this.driver.get(url);
        this.driver.manage().deleteAllCookies();
        long expires = System.currentTimeMillis() - 1000L;
        Cookie cookie = new Cookie("expired", "yes", "/common/animals", new Date(expires));
        WebDriver.Options options = this.driver.manage();
        options.addCookie(cookie);
        cookie = options.getCookieNamed("fish");
        CookieImplementationTest.assertNull((String)("Cookie expired before it was set, so nothing should be returned: " + cookie), (Object)cookie);
    }

    @Ignore(value={Ignore.Driver.SELENESE})
    private String gotoValidDomainAndClearCookies() {
        AppServer appServer = GlobalTestEnvironment.get().getAppServer();
        String name = null;
        String hostname = appServer.getHostName();
        if (hostname.matches("\\w+\\.\\w+.*")) {
            name = hostname;
            this.driver.get(appServer.whereIs("simpleTest.html"));
        }
        hostname = appServer.getAlternateHostName();
        if (name == null && hostname.matches("\\w+\\.\\w+.*")) {
            name = hostname;
            this.driver.get(appServer.whereElseIs("simpleTest.html"));
        }
        this.driver.manage().deleteAllCookies();
        return name;
    }
}

