/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.openqa.selenium.AbstractDriverTestCase;
import org.openqa.selenium.By;
import org.openqa.selenium.Ignore;
import org.openqa.selenium.JavascriptEnabled;
import org.openqa.selenium.TestWaiter;
import org.openqa.selenium.WaitingConditions;
import org.openqa.selenium.WebElement;

public class CorrectEventFiringTest
extends AbstractDriverTestCase {
    @Ignore(value={Ignore.Driver.CHROME, Ignore.Driver.FIREFOX, Ignore.Driver.ANDROID}, reason="Webkit bug 22261. Firefox 3.6 wants focus")
    @JavascriptEnabled
    public void testShouldFireFocusEventWhenClicking() {
        this.driver.get(this.pages.javascriptPage);
        this.clickOnElementWhichRecordsEvents();
        this.assertEventFired("focus");
    }

    @Ignore(value={Ignore.Driver.ANDROID})
    @JavascriptEnabled
    public void testShouldFireClickEventWhenClicking() {
        this.driver.get(this.pages.javascriptPage);
        this.clickOnElementWhichRecordsEvents();
        this.assertEventFired("click");
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.SELENESE, Ignore.Driver.ANDROID})
    public void testShouldFireMouseDownEventWhenClicking() {
        this.driver.get(this.pages.javascriptPage);
        this.clickOnElementWhichRecordsEvents();
        this.assertEventFired("mousedown");
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.SELENESE, Ignore.Driver.ANDROID})
    public void testShouldFireMouseUpEventWhenClicking() {
        this.driver.get(this.pages.javascriptPage);
        this.clickOnElementWhichRecordsEvents();
        this.assertEventFired("mouseup");
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.SELENESE, Ignore.Driver.CHROME})
    public void testShouldFireMouseOverEventWhenClicking() {
        this.driver.get(this.pages.javascriptPage);
        this.clickOnElementWhichRecordsEvents();
        this.assertEventFired("mouseover");
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.SELENESE, Ignore.Driver.CHROME, Ignore.Driver.FIREFOX})
    public void testShouldFireMouseMoveEventWhenClicking() {
        this.driver.get(this.pages.javascriptPage);
        this.clickOnElementWhichRecordsEvents();
        this.assertEventFired("mousemove");
    }

    @Ignore(value={Ignore.Driver.CHROME, Ignore.Driver.SELENESE, Ignore.Driver.FIREFOX, Ignore.Driver.ANDROID}, reason="Webkit bug 22261. Firefox 3.6 wants focus")
    @JavascriptEnabled
    public void testShouldFireEventsInTheRightOrder() {
        this.driver.get(this.pages.javascriptPage);
        this.clickOnElementWhichRecordsEvents();
        String text = this.driver.findElement(By.id((String)"result")).getText();
        int lastIndex = -1;
        for (String event : new String[]{"mousedown", "focus", "mouseup", "click"}) {
            int index = text.indexOf(event);
            CorrectEventFiringTest.assertTrue((String)(event + " did not fire at all"), (index != -1 ? 1 : 0) != 0);
            CorrectEventFiringTest.assertTrue((String)(event + " did not fire in the correct order"), (index > lastIndex ? 1 : 0) != 0);
        }
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.SELENESE, Ignore.Driver.ANDROID})
    public void testsShouldIssueMouseDownEvents() {
        this.driver.get(this.pages.javascriptPage);
        this.driver.findElement(By.id((String)"mousedown")).click();
        this.assertEventFired("mouse down");
        String result = this.driver.findElement(By.id((String)"result")).getText();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)"mouse down"));
    }

    @JavascriptEnabled
    public void testShouldIssueClickEvents() {
        this.driver.get(this.pages.javascriptPage);
        this.driver.findElement(By.id((String)"mouseclick")).click();
        WebElement result = this.driver.findElement(By.id((String)"result"));
        TestWaiter.waitFor(WaitingConditions.elementTextToEqual(result, "mouse click"));
        MatcherAssert.assertThat((Object)result.getText(), (Matcher)Matchers.equalTo((Object)"mouse click"));
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.SELENESE})
    public void testShouldIssueMouseUpEvents() {
        this.driver.get(this.pages.javascriptPage);
        this.driver.findElement(By.id((String)"mouseup")).click();
        WebElement result = this.driver.findElement(By.id((String)"result"));
        TestWaiter.waitFor(WaitingConditions.elementTextToEqual(result, "mouse up"));
        MatcherAssert.assertThat((Object)result.getText(), (Matcher)Matchers.equalTo((Object)"mouse up"));
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.IPHONE, Ignore.Driver.SELENESE})
    public void testMouseEventsShouldBubbleUpToContainingElements() {
        this.driver.get(this.pages.javascriptPage);
        this.driver.findElement(By.id((String)"child")).click();
        WebElement result = this.driver.findElement(By.id((String)"result"));
        TestWaiter.waitFor(WaitingConditions.elementTextToEqual(result, "mouse down"));
        MatcherAssert.assertThat((Object)result.getText(), (Matcher)Matchers.equalTo((Object)"mouse down"));
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.IPHONE, Ignore.Driver.SELENESE})
    public void testShouldEmitOnChangeEventsWhenSelectingElements() {
        this.driver.get(this.pages.javascriptPage);
        List allOptions = this.driver.findElements(By.xpath((String)"//select[@id='selector']//option"));
        String initialTextValue = this.driver.findElement(By.id((String)"result")).getText();
        WebElement foo = (WebElement)allOptions.get(0);
        WebElement bar = (WebElement)allOptions.get(1);
        foo.setSelected();
        MatcherAssert.assertThat((Object)this.driver.findElement(By.id((String)"result")).getText(), (Matcher)Matchers.equalTo((Object)initialTextValue));
        bar.setSelected();
        MatcherAssert.assertThat((Object)this.driver.findElement(By.id((String)"result")).getText(), (Matcher)Matchers.equalTo((Object)"bar"));
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.SELENESE})
    public void testShouldEmitOnChangeEventsWhenChangingTheStateOfACheckbox() {
        this.driver.get(this.pages.javascriptPage);
        WebElement checkbox = this.driver.findElement(By.id((String)"checkbox"));
        checkbox.setSelected();
        MatcherAssert.assertThat((Object)this.driver.findElement(By.id((String)"result")).getText(), (Matcher)Matchers.equalTo((Object)"checkbox thing"));
    }

    @JavascriptEnabled
    public void testShouldEmitClickEventWhenClickingOnATextInputElement() {
        this.driver.get(this.pages.javascriptPage);
        WebElement clicker = this.driver.findElement(By.id((String)"clickField"));
        clicker.click();
        TestWaiter.waitFor(WaitingConditions.elementValueToEqual(clicker, "Clicked"));
        MatcherAssert.assertThat((Object)clicker.getValue(), (Matcher)Matchers.equalTo((Object)"Clicked"));
    }

    @Ignore(value={Ignore.Driver.ANDROID})
    @JavascriptEnabled
    public void testClearingAnElementShouldCauseTheOnChangeHandlerToFire() {
        this.driver.get(this.pages.javascriptPage);
        WebElement element = this.driver.findElement(By.id((String)"clearMe"));
        element.clear();
        WebElement result = this.driver.findElement(By.id((String)"result"));
        MatcherAssert.assertThat((Object)result.getText(), (Matcher)Matchers.equalTo((Object)"Cleared"));
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.SELENESE, Ignore.Driver.IPHONE}, reason="Chrome: Non-native event firing is broken in .\n  Selenese: Fails when running in firefox.\n  iPhone: sendKeys implementation is incorrect")
    public void testSendingKeysToAnotherElementShouldCauseTheBlurEventToFire() {
        if (this.browserNeedsFocusOnThisOs(this.driver)) {
            System.out.println("Skipping this test because browser demands focus");
            return;
        }
        this.driver.get(this.pages.javascriptPage);
        WebElement element = this.driver.findElement(By.id((String)"theworks"));
        element.sendKeys(new CharSequence[]{"foo"});
        WebElement element2 = this.driver.findElement(By.id((String)"changeable"));
        element2.sendKeys(new CharSequence[]{"bar"});
        this.assertEventFired("blur");
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.SELENESE, Ignore.Driver.CHROME, Ignore.Driver.IPHONE, Ignore.Driver.ANDROID}, reason=": Non-native event firing is broken in Chrome.\n  Selenese: Fails when running in firefox.\n  iPhone: sendKeys implementation is incorrect")
    public void testSendingKeysToAnElementShouldCauseTheFocusEventToFire() {
        if (this.browserNeedsFocusOnThisOs(this.driver)) {
            System.out.println("Skipping this test because browser demands focus");
            return;
        }
        this.driver.get(this.pages.javascriptPage);
        WebElement element = this.driver.findElement(By.id((String)"theworks"));
        element.sendKeys(new CharSequence[]{"foo"});
        this.assertEventFired("focus");
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.IPHONE, Ignore.Driver.SELENESE}, reason="iPhone: input elements are blurred when the keyboard is closed")
    public void testSendingKeysToAFocusedElementShouldNotBlurThatElement() {
        if (this.browserNeedsFocusOnThisOs(this.driver)) {
            System.out.println("Skipping this test because browser demands focus");
            return;
        }
        this.driver.get(this.pages.javascriptPage);
        WebElement element = this.driver.findElement(By.id((String)"theworks"));
        element.click();
        boolean focused = false;
        WebElement result = this.driver.findElement(By.id((String)"result"));
        for (int i = 0; i < 5; ++i) {
            String fired = result.getText();
            if (fired.contains("focus")) {
                focused = true;
                break;
            }
            try {
                Thread.sleep(200L);
                continue;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        if (!focused) {
            CorrectEventFiringTest.fail((String)"Clicking on element didn't focus it in time - can't proceed so failing");
        }
        element.sendKeys(new CharSequence[]{"a"});
        this.assertEventNotFired("blur");
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.IE, Ignore.Driver.SELENESE})
    public void testSubmittingFormFromFormElementShouldFireOnSubmitForThatForm() {
        this.driver.get(this.pages.javascriptPage);
        WebElement formElement = this.driver.findElement(By.id((String)"submitListeningForm"));
        formElement.submit();
        this.assertEventFired("form-onsubmit");
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.IE, Ignore.Driver.SELENESE})
    public void testSubmittingFormFromFormInputSubmitElementShouldFireOnSubmitForThatForm() {
        this.driver.get(this.pages.javascriptPage);
        WebElement submit = this.driver.findElement(By.id((String)"submitListeningForm-submit"));
        submit.submit();
        this.assertEventFired("form-onsubmit");
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.IE, Ignore.Driver.SELENESE})
    public void testSubmittingFormFromFormInputTextElementShouldFireOnSubmitForThatFormAndNotClickOnThatInput() {
        this.driver.get(this.pages.javascriptPage);
        WebElement submit = this.driver.findElement(By.id((String)"submitListeningForm-submit"));
        submit.submit();
        this.assertEventFired("form-onsubmit");
        this.assertEventNotFired("text-onclick");
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.CHROME, Ignore.Driver.SELENESE, Ignore.Driver.IPHONE, Ignore.Driver.ANDROID}, reason="Does not yet support file uploads")
    public void testUploadingFileShouldFireOnChangeEvent() throws IOException {
        this.driver.get(this.pages.formPage);
        WebElement uploadElement = this.driver.findElement(By.id((String)"upload"));
        WebElement result = this.driver.findElement(By.id((String)"fileResults"));
        MatcherAssert.assertThat((Object)result.getText(), (Matcher)Matchers.equalTo((Object)""));
        File file = File.createTempFile("test", "txt");
        file.deleteOnExit();
        uploadElement.sendKeys(new CharSequence[]{file.getAbsolutePath()});
        this.driver.findElement(By.tagName((String)"body")).click();
        MatcherAssert.assertThat((Object)result.getText(), (Matcher)Matchers.equalTo((Object)"changed"));
    }

    private String getTextFromElementOnceAvailable(String elementId) {
        return TestWaiter.waitFor(WaitingConditions.elementToExist(this.driver, elementId)).getText();
    }

    @Ignore(value={Ignore.Driver.CHROME, Ignore.Driver.HTMLUNIT, Ignore.Driver.SELENESE, Ignore.Driver.ANDROID})
    public void testShouldReportTheXAndYCoordinatesWhenClicking() {
        this.driver.get(this.pages.javascriptPage);
        WebElement element = this.driver.findElement(By.id((String)"eventish"));
        element.click();
        String clientX = this.getTextFromElementOnceAvailable("clientX");
        String clientY = this.getTextFromElementOnceAvailable("clientY");
        CorrectEventFiringTest.assertFalse((boolean)"0".equals(clientX));
        CorrectEventFiringTest.assertFalse((boolean)"0".equals(clientY));
    }

    private void clickOnElementWhichRecordsEvents() {
        this.driver.findElement(By.id((String)"plainButton")).click();
    }

    private void assertEventFired(String eventName) {
        WebElement result = this.driver.findElement(By.id((String)"result"));
        String text = TestWaiter.waitFor(WaitingConditions.elementTextToContain(result, eventName));
        boolean conditionMet = text.contains(eventName);
        CorrectEventFiringTest.assertTrue((String)("No " + eventName + " fired: " + text), (boolean)conditionMet);
    }

    private void assertEventNotFired(String eventName) {
        WebElement result = this.driver.findElement(By.id((String)"result"));
        String text = result.getText();
        CorrectEventFiringTest.assertFalse((String)(eventName + " fired: " + text), (boolean)text.contains(eventName));
    }
}

