/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import junit.extensions.TestSetup;
import junit.framework.Test;
import org.openqa.selenium.NeedsDriver;
import org.openqa.selenium.WebDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverTestDecorator
extends TestSetup {
    private final Class<? extends WebDriver> driverClass;
    private final boolean keepDriver;
    private final boolean freshDriver;
    private static WebDriver driver;
    private final boolean restartDriver;

    public DriverTestDecorator(Test test, Class<? extends WebDriver> driverClass, boolean keepDriver, boolean freshDriver, boolean restartDriver) {
        super(test);
        this.driverClass = driverClass;
        this.keepDriver = keepDriver;
        this.freshDriver = freshDriver;
        this.restartDriver = restartDriver;
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (driver != null && this.freshDriver) {
            driver.quit();
            driver = null;
        }
        if (this.getTest() instanceof NeedsDriver) {
            try {
                driver = this.instantiateDriver();
                ((NeedsDriver)this.getTest()).setDriver(driver);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                throw e;
            }
        }
    }

    protected void tearDown() throws Exception {
        if (!this.keepDriver || this.restartDriver) {
            try {
                driver.quit();
            }
            catch (Exception exception) {
                // empty catch block
            }
            driver = null;
        }
        super.tearDown();
    }

    public static WebDriver getDriver() {
        return driver;
    }

    private WebDriver instantiateDriver() {
        if (this.keepDriver && driver != null) {
            return driver;
        }
        try {
            return this.driverClass.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            DriverTestDecorator.fail((String)("Cannot instantiate driver: " + e.getMessage()));
            throw new RuntimeException(e);
        }
    }
}

