/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsNull;
import org.openqa.selenium.AbstractDriverTestCase;
import org.openqa.selenium.By;
import org.openqa.selenium.Ignore;
import org.openqa.selenium.WebElement;

public class ElementAttributeTest
extends AbstractDriverTestCase {
    public void testShouldReturnNullWhenGettingTheValueOfAnAttributeThatIsNotListed() {
        this.driver.get(this.pages.simpleTestPage);
        WebElement head = this.driver.findElement(By.xpath((String)"/html"));
        String attribute = head.getAttribute("cheese");
        MatcherAssert.assertThat((Object)attribute, (Matcher)Matchers.is((Matcher)IsNull.nullValue()));
    }

    @Ignore(value={Ignore.Driver.FIREFOX, Ignore.Driver.SELENESE, Ignore.Driver.IE}, reason="Issue 758")
    public void testShouldReturnNullWhenGettingSrcAttributeOfInvalidImgTag() {
        this.driver.get(this.pages.simpleTestPage);
        WebElement img = this.driver.findElement(By.id((String)"invalidImgTag"));
        String attribute = img.getAttribute("src");
        MatcherAssert.assertThat((Object)attribute, (Matcher)Matchers.is((Matcher)IsNull.nullValue()));
    }

    public void testShouldReturnEmptyAttributeValuesWhenPresentAndTheValueIsActuallyEmpty() {
        this.driver.get(this.pages.simpleTestPage);
        WebElement body = this.driver.findElement(By.xpath((String)"//body"));
        MatcherAssert.assertThat((Object)body.getAttribute("style"), (Matcher)Matchers.equalTo((Object)""));
    }

    public void testShouldReturnTheValueOfTheDisabledAttributeAsFalseIfNotSet() {
        this.driver.get(this.pages.formPage);
        WebElement inputElement = this.driver.findElement(By.xpath((String)"//input[@id='working']"));
        MatcherAssert.assertThat((Object)inputElement.getAttribute("disabled"), (Matcher)Matchers.equalTo((Object)"false"));
        MatcherAssert.assertThat((Object)inputElement.isEnabled(), (Matcher)Matchers.equalTo((Object)true));
        WebElement pElement = this.driver.findElement(By.id((String)"peas"));
        MatcherAssert.assertThat((Object)pElement.getAttribute("disabled"), (Matcher)Matchers.equalTo((Object)"false"));
        MatcherAssert.assertThat((Object)pElement.isEnabled(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Ignore(value={Ignore.Driver.SELENESE}, reason="child element finding not implemented")
    public void testShouldReturnTheValueOfTheIndexAttrbuteEvenIfItIsMissing() {
        this.driver.get(this.pages.formPage);
        WebElement multiSelect = this.driver.findElement(By.id((String)"multi"));
        List options = multiSelect.findElements(By.tagName((String)"option"));
        MatcherAssert.assertThat((Object)((WebElement)options.get(1)).getAttribute("index"), (Matcher)Matchers.equalTo((Object)"1"));
    }

    public void testShouldIndicateTheElementsThatAreDisabledAreNotEnabled() {
        this.driver.get(this.pages.formPage);
        WebElement inputElement = this.driver.findElement(By.xpath((String)"//input[@id='notWorking']"));
        MatcherAssert.assertThat((Object)inputElement.isEnabled(), (Matcher)Matchers.is((Object)false));
        inputElement = this.driver.findElement(By.xpath((String)"//input[@id='working']"));
        MatcherAssert.assertThat((Object)inputElement.isEnabled(), (Matcher)Matchers.is((Object)true));
    }

    public void testElementsShouldBeDisabledIfTheyAreDisabledUsingRandomDisabledStrings() {
        this.driver.get(this.pages.formPage);
        WebElement disabledTextElement1 = this.driver.findElement(By.id((String)"disabledTextElement1"));
        MatcherAssert.assertThat((Object)disabledTextElement1.isEnabled(), (Matcher)Matchers.is((Object)false));
        WebElement disabledTextElement2 = this.driver.findElement(By.id((String)"disabledTextElement2"));
        MatcherAssert.assertThat((Object)disabledTextElement2.isEnabled(), (Matcher)Matchers.is((Object)false));
        WebElement disabledSubmitElement = this.driver.findElement(By.id((String)"disabledSubmitElement"));
        MatcherAssert.assertThat((Object)disabledSubmitElement.isEnabled(), (Matcher)Matchers.is((Object)false));
    }

    @Ignore(value={Ignore.Driver.SELENESE}, reason="sendKeys does not determine whether the element is disabled")
    public void testShouldThrowExceptionIfSendingKeysToElementDisabledUsingRandomDisabledStrings() {
        this.driver.get(this.pages.formPage);
        WebElement disabledTextElement1 = this.driver.findElement(By.id((String)"disabledTextElement1"));
        try {
            disabledTextElement1.sendKeys(new CharSequence[]{"foo"});
            ElementAttributeTest.fail((String)"Should have thrown exception");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        MatcherAssert.assertThat((Object)disabledTextElement1.getText(), (Matcher)Matchers.is((Object)""));
        WebElement disabledTextElement2 = this.driver.findElement(By.id((String)"disabledTextElement2"));
        try {
            disabledTextElement2.sendKeys(new CharSequence[]{"bar"});
            ElementAttributeTest.fail((String)"Should have thrown exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        MatcherAssert.assertThat((Object)disabledTextElement2.getText(), (Matcher)Matchers.is((Object)""));
    }

    public void testShouldIndicateWhenATextAreaIsDisabled() {
        this.driver.get(this.pages.formPage);
        WebElement textArea = this.driver.findElement(By.xpath((String)"//textarea[@id='notWorkingArea']"));
        MatcherAssert.assertThat((Object)textArea.isEnabled(), (Matcher)Matchers.is((Object)false));
    }

    public void testShouldIndicateWhenASelectIsDisabled() {
        this.driver.get(this.pages.formPage);
        WebElement enabled = this.driver.findElement(By.name((String)"selectomatic"));
        WebElement disabled = this.driver.findElement(By.name((String)"no-select"));
        ElementAttributeTest.assertTrue((boolean)enabled.isEnabled());
        ElementAttributeTest.assertFalse((boolean)disabled.isEnabled());
    }

    public void testShouldReturnTheValueOfCheckedForACheckboxOnlyIfItIsChecked() {
        this.driver.get(this.pages.formPage);
        WebElement checkbox = this.driver.findElement(By.xpath((String)"//input[@id='checky']"));
        MatcherAssert.assertThat((Object)checkbox.getAttribute("checked"), (Matcher)Matchers.equalTo(null));
        checkbox.setSelected();
        MatcherAssert.assertThat((Object)checkbox.getAttribute("checked"), (Matcher)Matchers.equalTo((Object)"true"));
    }

    public void testShouldOnlyReturnTheValueOfSelectedForRadioButtonsIfItIsSet() {
        this.driver.get(this.pages.formPage);
        WebElement neverSelected = this.driver.findElement(By.id((String)"cheese"));
        WebElement initiallyNotSelected = this.driver.findElement(By.id((String)"peas"));
        WebElement initiallySelected = this.driver.findElement(By.id((String)"cheese_and_peas"));
        MatcherAssert.assertThat((Object)neverSelected.getAttribute("selected"), (Matcher)Matchers.equalTo(null));
        MatcherAssert.assertThat((Object)initiallyNotSelected.getAttribute("selected"), (Matcher)Matchers.equalTo(null));
        MatcherAssert.assertThat((Object)initiallySelected.getAttribute("selected"), (Matcher)Matchers.equalTo((Object)"true"));
        initiallyNotSelected.setSelected();
        MatcherAssert.assertThat((Object)neverSelected.getAttribute("selected"), (Matcher)Matchers.equalTo(null));
        MatcherAssert.assertThat((Object)initiallyNotSelected.getAttribute("selected"), (Matcher)Matchers.equalTo((Object)"true"));
        MatcherAssert.assertThat((Object)initiallySelected.getAttribute("selected"), (Matcher)Matchers.equalTo(null));
    }

    @Ignore(value={Ignore.Driver.SELENESE}, reason="find child elements not implemented")
    public void testShouldReturnTheValueOfSelectedForOptionsOnlyIfTheyAreSelected() {
        this.driver.get(this.pages.formPage);
        WebElement selectBox = this.driver.findElement(By.xpath((String)"//select[@name='selectomatic']"));
        List options = selectBox.findElements(By.tagName((String)"option"));
        WebElement one = (WebElement)options.get(0);
        WebElement two = (WebElement)options.get(1);
        MatcherAssert.assertThat((Object)one.isSelected(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)two.isSelected(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)one.getAttribute("selected"), (Matcher)Matchers.equalTo((Object)"true"));
        MatcherAssert.assertThat((Object)two.getAttribute("selected"), (Matcher)Matchers.equalTo(null));
    }

    public void testShouldReturnValueOfClassAttributeOfAnElement() {
        this.driver.get(this.pages.xhtmlTestPage);
        WebElement heading = this.driver.findElement(By.xpath((String)"//h1"));
        String className = heading.getAttribute("class");
        MatcherAssert.assertThat((Object)className, (Matcher)Matchers.equalTo((Object)"header"));
    }

    public void testShouldReturnTheContentsOfATextAreaAsItsValue() {
        this.driver.get(this.pages.formPage);
        String value = this.driver.findElement(By.id((String)"withText")).getValue();
        MatcherAssert.assertThat((Object)value, (Matcher)Matchers.equalTo((Object)"Example text"));
    }

    public void testShouldTreatReadonlyAsAValue() {
        this.driver.get(this.pages.formPage);
        WebElement element = this.driver.findElement(By.name((String)"readonly"));
        String readonly = element.getAttribute("readonly");
        WebElement textInput = this.driver.findElement(By.name((String)"x"));
        String notReadonly = textInput.getAttribute("readonly");
        ElementAttributeTest.assertFalse((boolean)readonly.equals(notReadonly));
    }

    public void testShouldGetNumericAtribute() {
        this.driver.get(this.pages.formPage);
        WebElement element = this.driver.findElement(By.id((String)"withText"));
        MatcherAssert.assertThat((Object)element.getAttribute("rows"), (Matcher)Matchers.is((Object)"5"));
    }

    @Ignore(value={Ignore.Driver.CHROME, Ignore.Driver.FIREFOX, Ignore.Driver.HTMLUNIT})
    public void testCanReturnATextApproximationOfTheStyleAttribute() {
        this.driver.get(this.pages.javascriptPage);
        String style = this.driver.findElement(By.id((String)"red-item")).getAttribute("style");
        System.out.println("style = " + style);
        ElementAttributeTest.assertTrue((boolean)style.toLowerCase().contains("background-color"));
    }

    public void testShouldCorrectlyReportValueOfColspan() {
        this.driver.get(this.pages.tables);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        WebElement th1 = this.driver.findElement(By.id((String)"th1"));
        WebElement td2 = this.driver.findElement(By.id((String)"td2"));
        ElementAttributeTest.assertEquals((String)"th1 id", (String)"th1", (String)th1.getAttribute("id"));
        ElementAttributeTest.assertEquals((String)"th1 colspan should be 3", (String)"3", (String)th1.getAttribute("colspan"));
        ElementAttributeTest.assertEquals((String)"td2 id", (String)"td2", (String)td2.getAttribute("id"));
        ElementAttributeTest.assertEquals((String)"td2 colspan should be 2", (String)"2", (String)td2.getAttribute("colspan"));
    }

    @Ignore(value={Ignore.Driver.SELENESE})
    public void testShouldReturnValueOfOnClickAttribute() {
        this.driver.get(this.pages.javascriptPage);
        WebElement mouseclickDiv = this.driver.findElement(By.id((String)"mouseclick"));
        String onClickValue = mouseclickDiv.getAttribute("onclick");
        String expectedOnClickValue = "displayMessage('mouse click');";
        MatcherAssert.assertThat((String)"Javascript code expected", (Object)onClickValue, (Matcher)Matchers.anyOf((Matcher[])new Matcher[]{Matchers.equalTo((Object)("javascript:" + expectedOnClickValue)), Matchers.equalTo((Object)("function anonymous()\n{\n" + expectedOnClickValue + "\n}")), Matchers.equalTo((Object)("function onclick()\n{\n" + expectedOnClickValue + "\n}"))}));
        WebElement mousedownDiv = this.driver.findElement(By.id((String)"mousedown"));
        ElementAttributeTest.assertEquals(null, (String)mousedownDiv.getAttribute("onclick"));
    }

    @Ignore(value={Ignore.Driver.IE, Ignore.Driver.IPHONE}, reason="IE7 Does not support SVG; SVG elements crash the iWebDriver app (issue 1134)")
    public void testGetAttributeDoesNotReturnAnObjectForSvgProperties() {
        this.driver.get(this.pages.svgPage);
        WebElement svgElement = this.driver.findElement(By.id((String)"rotate"));
        ElementAttributeTest.assertEquals((String)"rotate(30)", (String)svgElement.getAttribute("transform"));
    }
}

