/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.util.List;
import java.util.concurrent.Callable;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.openqa.selenium.AbstractDriverTestCase;
import org.openqa.selenium.By;
import org.openqa.selenium.Ignore;
import org.openqa.selenium.IllegalLocatorException;
import org.openqa.selenium.JavascriptEnabled;
import org.openqa.selenium.NeedsFreshDriver;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.RenderedWebElement;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.TestWaiter;
import org.openqa.selenium.WaitingConditions;
import org.openqa.selenium.WebElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementFindingTest
extends AbstractDriverTestCase {
    public void testShouldReturnTitleOfPageIfSet() {
        this.driver.get(this.pages.xhtmlTestPage);
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)"XHTML Test Page"));
        this.driver.get(this.pages.simpleTestPage);
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)"Hello WebDriver"));
    }

    public void testShouldNotBeAbleToLocateASingleElementThatDoesNotExist() {
        this.driver.get(this.pages.formPage);
        try {
            this.driver.findElement(By.id((String)"nonExistantButton"));
            ElementFindingTest.fail((String)"Should not have succeeded");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testShouldBeAbleToClickOnLinkIdentifiedByText() {
        this.driver.get(this.pages.xhtmlTestPage);
        this.driver.findElement(By.linkText((String)"click me")).click();
        TestWaiter.waitFor(WaitingConditions.pageTitleToBe(this.driver, "We Arrive Here"));
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)"We Arrive Here"));
    }

    public void testDriverShouldBeAbleToFindElementsAfterLoadingMoreThanOnePageAtATime() {
        this.driver.get(this.pages.formPage);
        this.driver.get(this.pages.xhtmlTestPage);
        this.driver.findElement(By.linkText((String)"click me")).click();
        TestWaiter.waitFor(WaitingConditions.pageTitleToBe(this.driver, "We Arrive Here"));
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)"We Arrive Here"));
    }

    public void testshouldBeAbleToClickOnLinkIdentifiedById() {
        this.driver.get(this.pages.xhtmlTestPage);
        this.driver.findElement(By.id((String)"linkId")).click();
        TestWaiter.waitFor(WaitingConditions.pageTitleToBe(this.driver, "We Arrive Here"));
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)"We Arrive Here"));
    }

    public void testShouldThrowAnExceptionWhenThereIsNoLinkToClickAndItIsFoundWithLinkText() {
        this.driver.get(this.pages.xhtmlTestPage);
        try {
            this.driver.findElement(By.linkText((String)"Not here either"));
            ElementFindingTest.fail((String)"Should not have succeeded");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testShouldfindAnElementBasedOnId() {
        this.driver.get(this.pages.formPage);
        WebElement element = this.driver.findElement(By.id((String)"checky"));
        MatcherAssert.assertThat((Object)element.isSelected(), (Matcher)Matchers.is((Object)false));
    }

    public void testShouldNotBeAbleTofindElementsBasedOnIdIfTheElementIsNotThere() {
        this.driver.get(this.pages.formPage);
        try {
            this.driver.findElement(By.id((String)"notThere"));
            ElementFindingTest.fail((String)"Should not have succeeded");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Ignore(value={Ignore.Driver.SELENESE})
    public void testShouldBeAbleToFindChildrenOfANode() {
        this.driver.get(this.pages.xhtmlTestPage);
        List elements = this.driver.findElements(By.xpath((String)"/html/head"));
        WebElement head = (WebElement)elements.get(0);
        List importedScripts = head.findElements(By.tagName((String)"script"));
        MatcherAssert.assertThat((Object)importedScripts.size(), (Matcher)Matchers.equalTo((Object)2));
    }

    @Ignore(value={Ignore.Driver.SELENESE})
    public void testReturnAnEmptyListWhenThereAreNoChildrenOfANode() {
        this.driver.get(this.pages.xhtmlTestPage);
        WebElement table = this.driver.findElement(By.id((String)"table"));
        List rows = table.findElements(By.tagName((String)"tr"));
        MatcherAssert.assertThat((Object)rows.size(), (Matcher)Matchers.equalTo((Object)0));
    }

    @Ignore(value={Ignore.Driver.SELENESE})
    public void testShouldFindElementsByName() {
        this.driver.get(this.pages.formPage);
        WebElement element = this.driver.findElement(By.name((String)"checky"));
        MatcherAssert.assertThat((Object)element.getValue(), (Matcher)Matchers.is((Object)"furrfu"));
    }

    public void testShouldFindElementsByClass() {
        this.driver.get(this.pages.xhtmlTestPage);
        WebElement element = this.driver.findElement(By.className((String)"extraDiv"));
        ElementFindingTest.assertTrue((boolean)element.getText().startsWith("Another div starts here."));
    }

    public void testShouldFindElementsByClassWhenItIsTheFirstNameAmongMany() {
        this.driver.get(this.pages.xhtmlTestPage);
        WebElement element = this.driver.findElement(By.className((String)"nameA"));
        MatcherAssert.assertThat((Object)element.getText(), (Matcher)Matchers.equalTo((Object)"An H2 title"));
    }

    public void testShouldFindElementsByClassWhenItIsTheLastNameAmongMany() {
        this.driver.get(this.pages.xhtmlTestPage);
        WebElement element = this.driver.findElement(By.className((String)"nameC"));
        MatcherAssert.assertThat((Object)element.getText(), (Matcher)Matchers.equalTo((Object)"An H2 title"));
    }

    public void testShouldFindElementsByClassWhenItIsInTheMiddleAmongMany() {
        this.driver.get(this.pages.xhtmlTestPage);
        WebElement element = this.driver.findElement(By.className((String)"nameBnoise"));
        MatcherAssert.assertThat((Object)element.getText(), (Matcher)Matchers.equalTo((Object)"An H2 title"));
    }

    public void testShouldFindElementByClassWhenItsNameIsSurroundedByWhitespace() {
        this.driver.get(this.pages.xhtmlTestPage);
        WebElement element = this.driver.findElement(By.className((String)"spaceAround"));
        MatcherAssert.assertThat((Object)element.getText(), (Matcher)Matchers.equalTo((Object)"Spaced out"));
    }

    public void testShouldFindElementsByClassWhenItsNameIsSurroundedByWhitespace() {
        this.driver.get(this.pages.xhtmlTestPage);
        List elements = this.driver.findElements(By.className((String)"spaceAround"));
        MatcherAssert.assertThat((Object)elements.size(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)((WebElement)elements.get(0)).getText(), (Matcher)Matchers.equalTo((Object)"Spaced out"));
    }

    public void testShouldNotFindElementsByClassWhenTheNameQueriedIsShorterThanCandidateName() {
        this.driver.get(this.pages.xhtmlTestPage);
        try {
            this.driver.findElement(By.className((String)"nameB"));
            ElementFindingTest.fail((String)"Should not have succeeded");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testShouldBeAbleToFindMultipleElementsByXPath() {
        this.driver.get(this.pages.xhtmlTestPage);
        List elements = this.driver.findElements(By.xpath((String)"//div"));
        ElementFindingTest.assertTrue((elements.size() > 1 ? 1 : 0) != 0);
    }

    public void testShouldBeAbleToFindMultipleElementsByLinkText() {
        this.driver.get(this.pages.xhtmlTestPage);
        List elements = this.driver.findElements(By.linkText((String)"click me"));
        ElementFindingTest.assertTrue((String)("Expected 2 links, got " + elements.size()), (elements.size() == 2 ? 1 : 0) != 0);
    }

    public void testShouldBeAbleToFindMultipleElementsByPartialLinkText() {
        this.driver.get(this.pages.xhtmlTestPage);
        List elements = this.driver.findElements(By.partialLinkText((String)"ick me"));
        ElementFindingTest.assertTrue((elements.size() == 2 ? 1 : 0) != 0);
    }

    @Ignore(value={Ignore.Driver.SELENESE})
    public void testShouldBeAbleToFindElementByPartialLinkText() {
        this.driver.get(this.pages.xhtmlTestPage);
        try {
            this.driver.findElement(By.partialLinkText((String)"anon"));
        }
        catch (NoSuchElementException e) {
            ElementFindingTest.fail((String)"Expected element to be found");
        }
    }

    public void testShouldBeAbleToFindMultipleElementsByName() {
        this.driver.get(this.pages.nestedPage);
        List elements = this.driver.findElements(By.name((String)"checky"));
        ElementFindingTest.assertTrue((elements.size() > 1 ? 1 : 0) != 0);
    }

    public void testShouldBeAbleToFindMultipleElementsById() {
        this.driver.get(this.pages.nestedPage);
        List elements = this.driver.findElements(By.id((String)"2"));
        ElementFindingTest.assertEquals((int)8, (int)elements.size());
    }

    public void testShouldBeAbleToFindMultipleElementsByClassName() {
        this.driver.get(this.pages.xhtmlTestPage);
        List elements = this.driver.findElements(By.className((String)"nameC"));
        ElementFindingTest.assertTrue((elements.size() > 1 ? 1 : 0) != 0);
    }

    public void testWhenFindingByNameShouldNotReturnById() {
        this.driver.get(this.pages.formPage);
        WebElement element = this.driver.findElement(By.name((String)"id-name1"));
        MatcherAssert.assertThat((Object)element.getValue(), (Matcher)Matchers.is((Object)"name"));
        element = this.driver.findElement(By.id((String)"id-name1"));
        MatcherAssert.assertThat((Object)element.getValue(), (Matcher)Matchers.is((Object)"id"));
        element = this.driver.findElement(By.name((String)"id-name2"));
        MatcherAssert.assertThat((Object)element.getValue(), (Matcher)Matchers.is((Object)"name"));
        element = this.driver.findElement(By.id((String)"id-name2"));
        MatcherAssert.assertThat((Object)element.getValue(), (Matcher)Matchers.is((Object)"id"));
    }

    @Ignore(value={Ignore.Driver.SELENESE})
    public void testShouldFindGrandChildren() {
        this.driver.get(this.pages.formPage);
        WebElement form = this.driver.findElement(By.id((String)"nested_form"));
        form.findElement(By.name((String)"x"));
    }

    @Ignore(value={Ignore.Driver.SELENESE})
    public void testShouldNotFindElementOutSideTree() {
        this.driver.get(this.pages.formPage);
        WebElement element = this.driver.findElement(By.name((String)"login"));
        try {
            element.findElement(By.name((String)"x"));
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testShouldReturnElementsThatDoNotSupportTheNameProperty() {
        this.driver.get(this.pages.nestedPage);
        this.driver.findElement(By.name((String)"div1"));
    }

    public void testShouldFindHiddenElementsByName() {
        this.driver.get(this.pages.formPage);
        try {
            this.driver.findElement(By.name((String)"hidden"));
        }
        catch (NoSuchElementException e) {
            ElementFindingTest.fail((String)"Expected to be able to find hidden element");
        }
    }

    public void testShouldfindAnElementBasedOnTagName() {
        this.driver.get(this.pages.formPage);
        WebElement element = this.driver.findElement(By.tagName((String)"input"));
        ElementFindingTest.assertNotNull((Object)element);
    }

    public void testShouldfindElementsBasedOnTagName() {
        this.driver.get(this.pages.formPage);
        List elements = this.driver.findElements(By.tagName((String)"input"));
        ElementFindingTest.assertNotNull((Object)elements);
    }

    public void testFindingByCompoundClassNameIsAnError() {
        this.driver.get(this.pages.xhtmlTestPage);
        try {
            this.driver.findElement(By.className((String)"a b"));
            ElementFindingTest.fail((String)"Compound class names aren't allowed");
        }
        catch (IllegalLocatorException e) {
            // empty catch block
        }
        try {
            this.driver.findElements(By.className((String)"a b"));
            ElementFindingTest.fail((String)"Compound class names aren't allowed");
        }
        catch (IllegalLocatorException illegalLocatorException) {
            // empty catch block
        }
    }

    @JavascriptEnabled
    public void testShouldBeAbleToClickOnLinksWithNoHrefAttribute() {
        this.driver.get(this.pages.javascriptPage);
        WebElement element = this.driver.findElement(By.linkText((String)"No href"));
        element.click();
        TestWaiter.waitFor(WaitingConditions.pageTitleToBe(this.driver, "Changed"));
        ElementFindingTest.assertEquals((String)"Changed", (String)this.driver.getTitle());
    }

    @Ignore(value={Ignore.Driver.SELENESE})
    public void testShouldNotBeAbleToFindAnElementOnABlankPage() {
        this.driver.get("about:blank");
        try {
            this.driver.findElement(By.tagName((String)"a"));
            ElementFindingTest.fail((String)"Should not have been able to find a link");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Ignore(value={Ignore.Driver.IPHONE})
    @NeedsFreshDriver
    public void testShouldNotBeAbleToLocateASingleElementOnABlankPage() {
        try {
            this.driver.findElement(By.id((String)"nonExistantButton"));
            ElementFindingTest.fail((String)"Should not have succeeded");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @JavascriptEnabled
    public void testRemovingAnElementDynamicallyFromTheDomShouldCauseAStaleRefException() {
        this.driver.get(this.pages.javascriptPage);
        RenderedWebElement toBeDeleted = (RenderedWebElement)this.driver.findElement(By.id((String)"deleted"));
        ElementFindingTest.assertTrue((boolean)toBeDeleted.isDisplayed());
        this.driver.findElement(By.id((String)"delete")).click();
        boolean wasStale = TestWaiter.waitFor(this.elementToBeStale(toBeDeleted));
        ElementFindingTest.assertTrue((String)"Element should be stale at this point", (boolean)wasStale);
    }

    private Callable<Boolean> elementToBeStale(final RenderedWebElement element) {
        return new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    element.isDisplayed();
                    return false;
                }
                catch (StaleElementReferenceException e) {
                    return true;
                }
            }
        };
    }

    public void testFindingALinkByXpathUsingContainsKeywordShouldWork() {
        this.driver.get(this.pages.nestedPage);
        try {
            this.driver.findElement(By.xpath((String)"//a[contains(.,'hello world')]"));
        }
        catch (Exception e) {
            ElementFindingTest.fail((String)"Should not have thrown an exception");
        }
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.REMOTE})
    @NeedsFreshDriver
    public void testShouldBeAbleToFindAnElementByCssSelector() {
        this.driver.get(this.pages.xhtmlTestPage);
        this.driver.findElement(By.cssSelector((String)"div.content"));
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.REMOTE})
    @NeedsFreshDriver
    public void testShouldBeAbleToFindAnElementsByCssSelector() {
        this.driver.get(this.pages.xhtmlTestPage);
        this.driver.findElements(By.cssSelector((String)"p"));
    }

    @Ignore(value={Ignore.Driver.SELENESE})
    public void testFindingByXPathShouldNotIncludeParentElementIfSameTagType() {
        this.driver.get(this.pages.xhtmlTestPage);
        WebElement parent = this.driver.findElement(By.id((String)"my_span"));
        ElementFindingTest.assertEquals((int)2, (int)parent.findElements(By.tagName((String)"div")).size());
        ElementFindingTest.assertEquals((int)2, (int)parent.findElements(By.tagName((String)"span")).size());
    }
}

