/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.openqa.selenium.AbstractDriverTestCase;
import org.openqa.selenium.By;
import org.openqa.selenium.Ignore;
import org.openqa.selenium.JavascriptEnabled;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

@Ignore(value={Ignore.Driver.SELENESE, Ignore.Driver.IE}, reason="Every test appears to be failing.")
public class ExecutingAsyncJavascriptTest
extends AbstractDriverTestCase {
    private JavascriptExecutor executor;

    protected void setUp() throws Exception {
        super.setUp();
        if (this.driver instanceof JavascriptExecutor) {
            this.executor = (JavascriptExecutor)this.driver;
        }
        this.driver.manage().timeouts().setScriptTimeout(0L, TimeUnit.MILLISECONDS);
    }

    @JavascriptEnabled
    @Test
    public void shouldNotTimeoutIfCallbackInvokedImmediately() {
        this.driver.get(this.pages.ajaxyPage);
        Object result = this.executor.executeAsyncScript("arguments[arguments.length - 1](123);", new Object[0]);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.instanceOf(Number.class));
        ExecutingAsyncJavascriptTest.assertEquals((int)123, (int)((Number)result).intValue());
    }

    @JavascriptEnabled
    @Test
    public void shouldBeAbleToReturnJavascriptPrimitivesFromAsyncScripts_NeitherNullNorUndefined() {
        this.driver.get(this.pages.ajaxyPage);
        ExecutingAsyncJavascriptTest.assertEquals((long)123L, (long)((Number)this.executor.executeAsyncScript("arguments[arguments.length - 1](123);", new Object[0])).longValue());
        ExecutingAsyncJavascriptTest.assertEquals((Object)"abc", (Object)this.executor.executeAsyncScript("arguments[arguments.length - 1]('abc');", new Object[0]));
        ExecutingAsyncJavascriptTest.assertFalse((boolean)((Boolean)this.executor.executeAsyncScript("arguments[arguments.length - 1](false);", new Object[0])));
        ExecutingAsyncJavascriptTest.assertTrue((boolean)((Boolean)this.executor.executeAsyncScript("arguments[arguments.length - 1](true);", new Object[0])));
    }

    @JavascriptEnabled
    @Test
    @Ignore(value={Ignore.Driver.SELENESE}, reason="SeleniumRC cannot return null values.")
    public void shouldBeAbleToReturnJavascriptPrimitivesFromAsyncScripts_NullAndUndefined() {
        this.driver.get(this.pages.ajaxyPage);
        ExecutingAsyncJavascriptTest.assertNull((Object)this.executor.executeAsyncScript("arguments[arguments.length - 1](null)", new Object[0]));
        ExecutingAsyncJavascriptTest.assertNull((Object)this.executor.executeAsyncScript("arguments[arguments.length - 1]()", new Object[0]));
    }

    @JavascriptEnabled
    @Test
    @Ignore(value={Ignore.Driver.SELENESE}, reason="Selenium cannot return arrays")
    public void shouldBeAbleToReturnAnArrayLiteralFromAnAsyncScript() {
        this.driver.get(this.pages.ajaxyPage);
        Object result = this.executor.executeAsyncScript("arguments[arguments.length - 1]([]);", new Object[0]);
        ExecutingAsyncJavascriptTest.assertNotNull((String)"Expected not to be null!", (Object)result);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.instanceOf(List.class));
        ExecutingAsyncJavascriptTest.assertTrue((boolean)((List)result).isEmpty());
    }

    @JavascriptEnabled
    @Test
    @Ignore(value={Ignore.Driver.SELENESE}, reason="Selenium cannot return arrays")
    public void shouldBeAbleToReturnAnArrayObjectFromAnAsyncScript() {
        this.driver.get(this.pages.ajaxyPage);
        Object result = this.executor.executeAsyncScript("arguments[arguments.length - 1](new Array());", new Object[0]);
        ExecutingAsyncJavascriptTest.assertNotNull((String)"Expected not to be null!", (Object)result);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.instanceOf(List.class));
        ExecutingAsyncJavascriptTest.assertTrue((boolean)((List)result).isEmpty());
    }

    @JavascriptEnabled
    @Test
    @Ignore(value={Ignore.Driver.ANDROID, Ignore.Driver.SELENESE}, reason="Android does not properly handle arrays; Selenium cannot return arrays")
    public void shouldBeAbleToReturnArraysOfPrimitivesFromAsyncScripts() {
        this.driver.get(this.pages.ajaxyPage);
        Object result = this.executor.executeAsyncScript("arguments[arguments.length - 1]([null, 123, 'abc', true, false]);", new Object[0]);
        ExecutingAsyncJavascriptTest.assertNotNull((Object)result);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.instanceOf(List.class));
        Iterator results = ((List)result).iterator();
        ExecutingAsyncJavascriptTest.assertNull(results.next());
        ExecutingAsyncJavascriptTest.assertEquals((long)123L, (long)((Number)results.next()).longValue());
        ExecutingAsyncJavascriptTest.assertEquals((Object)"abc", results.next());
        ExecutingAsyncJavascriptTest.assertTrue((boolean)((Boolean)results.next()));
        ExecutingAsyncJavascriptTest.assertFalse((boolean)((Boolean)results.next()));
        ExecutingAsyncJavascriptTest.assertFalse((boolean)results.hasNext());
    }

    @JavascriptEnabled
    @Test
    @Ignore(value={Ignore.Driver.SELENESE}, reason="Selenium cannot return elements from scripts")
    public void shouldBeAbleToReturnWebElementsFromAsyncScripts() {
        this.driver.get(this.pages.ajaxyPage);
        Object result = this.executor.executeAsyncScript("arguments[arguments.length - 1](document.body);", new Object[0]);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.instanceOf(WebElement.class));
        ExecutingAsyncJavascriptTest.assertEquals((String)"body", (String)((WebElement)result).getTagName().toLowerCase());
    }

    @JavascriptEnabled
    @Test
    @Ignore(value={Ignore.Driver.ANDROID, Ignore.Driver.SELENESE}, reason="Android does not properly handle arrays; Selenium cannot return elements")
    public void shouldBeAbleToReturnArraysOfWebElementsFromAsyncScripts() {
        this.driver.get(this.pages.ajaxyPage);
        Object result = this.executor.executeAsyncScript("arguments[arguments.length - 1]([document.body, document.body]);", new Object[0]);
        ExecutingAsyncJavascriptTest.assertNotNull((Object)result);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.instanceOf(List.class));
        List list = (List)result;
        ExecutingAsyncJavascriptTest.assertEquals((int)2, (int)list.size());
        MatcherAssert.assertThat(list.get(0), (Matcher)Matchers.instanceOf(WebElement.class));
        MatcherAssert.assertThat(list.get(1), (Matcher)Matchers.instanceOf(WebElement.class));
        ExecutingAsyncJavascriptTest.assertEquals((String)"body", (String)((WebElement)list.get(0)).getTagName().toLowerCase());
        ExecutingAsyncJavascriptTest.assertEquals(list.get(0), list.get(1));
    }

    @JavascriptEnabled
    @Test
    public void shouldTimeoutIfScriptDoesNotInvokeCallback() {
        this.driver.get(this.pages.ajaxyPage);
        try {
            this.executor.executeAsyncScript("return 1 + 2;", new Object[0]);
            ExecutingAsyncJavascriptTest.fail((String)"Should have thrown a TimeOutException!");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    @JavascriptEnabled
    @Test
    public void shouldTimeoutIfScriptDoesNotInvokeCallbackWithAZeroTimeout() {
        this.driver.get(this.pages.ajaxyPage);
        try {
            this.executor.executeAsyncScript("window.setTimeout(function() {}, 0);", new Object[0]);
            ExecutingAsyncJavascriptTest.fail((String)"Should have thrown a TimeOutException!");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    @JavascriptEnabled
    @Test
    public void shouldNotTimeoutIfScriptCallsbackInsideAZeroTimeout() {
        this.driver.get(this.pages.ajaxyPage);
        this.executor.executeAsyncScript("var callback = arguments[arguments.length - 1];window.setTimeout(function() { callback(123); }, 0)", new Object[0]);
    }

    @JavascriptEnabled
    @Test
    public void shouldTimeoutIfScriptDoesNotInvokeCallbackWithLongTimeout() {
        this.driver.manage().timeouts().setScriptTimeout(500L, TimeUnit.MILLISECONDS);
        this.driver.get(this.pages.ajaxyPage);
        try {
            this.executor.executeAsyncScript("var callback = arguments[arguments.length - 1];window.setTimeout(callback, 1500);", new Object[0]);
            ExecutingAsyncJavascriptTest.fail((String)"Should have thrown a TimeOutException!");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    @JavascriptEnabled
    @Test
    public void shouldDetectPageLoadsWhileWaitingOnAnAsyncScriptAndReturnAnError() {
        this.driver.get(this.pages.ajaxyPage);
        this.driver.manage().timeouts().setScriptTimeout(100L, TimeUnit.MILLISECONDS);
        try {
            this.executor.executeAsyncScript("window.location = '" + this.pages.dynamicPage + "';", new Object[0]);
            ExecutingAsyncJavascriptTest.fail();
        }
        catch (WebDriverException webDriverException) {
            // empty catch block
        }
    }

    @JavascriptEnabled
    @Test
    public void shouldCatchErrorsWhenExecutingInitialScript() {
        this.driver.get(this.pages.ajaxyPage);
        try {
            this.executor.executeAsyncScript("throw Error('you should catch this!');", new Object[0]);
            ExecutingAsyncJavascriptTest.fail();
        }
        catch (WebDriverException webDriverException) {
            // empty catch block
        }
    }

    @Ignore(value={Ignore.Driver.ANDROID, Ignore.Driver.CHROME}, reason="Android: Emulator is too slow and latency causes test to fall out of sync with app;Chrome: Click is not working")
    @JavascriptEnabled
    @Test
    public void shouldBeAbleToExecuteAsynchronousScripts() {
        this.driver.get(this.pages.ajaxyPage);
        WebElement typer = this.driver.findElement(By.name((String)"typer"));
        typer.sendKeys(new CharSequence[]{"bob"});
        ExecutingAsyncJavascriptTest.assertEquals((String)"bob", (String)typer.getValue());
        this.driver.findElement(By.id((String)"red")).click();
        this.driver.findElement(By.name((String)"submit")).click();
        ExecutingAsyncJavascriptTest.assertEquals((String)"There should only be 1 DIV at this point, which is used for the butter message", (long)1L, (long)this.getNumDivElements());
        this.driver.manage().timeouts().setScriptTimeout(10L, TimeUnit.SECONDS);
        String text = (String)this.executor.executeAsyncScript("var callback = arguments[arguments.length - 1];window.registerListener(arguments[arguments.length - 1]);", new Object[0]);
        ExecutingAsyncJavascriptTest.assertEquals((String)"bob", (String)text);
        ExecutingAsyncJavascriptTest.assertEquals((String)"", (String)typer.getValue());
        ExecutingAsyncJavascriptTest.assertEquals((String)"There should be 1 DIV (for the butter message) + 1 DIV (for the new label)", (long)2L, (long)this.getNumDivElements());
    }

    @JavascriptEnabled
    @Test
    public void shouldBeAbleToPassMultipleArgumentsToAsyncScripts() {
        this.driver.get(this.pages.ajaxyPage);
        Number result = (Number)((JavascriptExecutor)this.driver).executeAsyncScript("arguments[arguments.length - 1](arguments[0] + arguments[1]);", new Object[]{1, 2});
        ExecutingAsyncJavascriptTest.assertEquals((int)3, (int)result.intValue());
    }

    @JavascriptEnabled
    @Test
    public void shouldBeAbleToMakeXMLHttpRequestsAndWaitForTheResponse() {
        String script = "var url = arguments[0];var callback = arguments[arguments.length - 1];var XMLHttpFactories = [  function () {return new XMLHttpRequest()},  function () {return new ActiveXObject('Msxml2.XMLHTTP')},  function () {return new ActiveXObject('Msxml3.XMLHTTP')},  function () {return new ActiveXObject('Microsoft.XMLHTTP')}];var xhr = false;while (!xhr && XMLHttpFactories.length) {  try {    xhr = XMLHttpFactories.shift().call();  } catch (e) {}}if (!xhr) throw Error('unable to create XHR object');xhr.open('GET', url, true);xhr.onreadystatechange = function() {  if (xhr.readyState == 4) callback(xhr.responseText);};xhr.send('');";
        this.driver.get(this.pages.ajaxyPage);
        this.driver.manage().timeouts().setScriptTimeout(3L, TimeUnit.SECONDS);
        String response = (String)((JavascriptExecutor)this.driver).executeAsyncScript(script, new Object[]{this.pages.sleepingPage + "?time=2"});
        MatcherAssert.assertThat((Object)response.trim(), (Matcher)Matchers.equalTo((Object)"<html><head><title>Done</title></head><body>Slept for 2s</body></html>"));
    }

    private long getNumDivElements() {
        return (Long)((JavascriptExecutor)this.driver).executeScript("return document.getElementsByTagName('div').length;", new Object[0]);
    }
}

