/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.io.File;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.openqa.selenium.AbstractDriverTestCase;
import org.openqa.selenium.By;
import org.openqa.selenium.Ignore;
import org.openqa.selenium.JavascriptEnabled;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NeedsFreshDriver;
import org.openqa.selenium.NoDriverAfterTest;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutingJavascriptTest
extends AbstractDriverTestCase {
    @JavascriptEnabled
    public void testShouldBeAbleToExecuteSimpleJavascriptAndReturnAString() {
        if (!(this.driver instanceof JavascriptExecutor)) {
            return;
        }
        this.driver.get(this.pages.xhtmlTestPage);
        Object result = this.executeScript("return document.title;", new Object[0]);
        ExecutingJavascriptTest.assertTrue((boolean)(result instanceof String));
        ExecutingJavascriptTest.assertEquals((Object)"XHTML Test Page", (Object)result);
    }

    @JavascriptEnabled
    public void testShouldBeAbleToExecuteSimpleJavascriptAndReturnALong() {
        if (!(this.driver instanceof JavascriptExecutor)) {
            return;
        }
        this.driver.get(this.pages.nestedPage);
        Object result = this.executeScript("return document.getElementsByName('checky').length;", new Object[0]);
        ExecutingJavascriptTest.assertTrue((String)result.getClass().getName(), (boolean)(result instanceof Long));
        ExecutingJavascriptTest.assertTrue(((Long)result > 1L ? 1 : 0) != 0);
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.SELENESE})
    public void testShouldBeAbleToExecuteSimpleJavascriptAndReturnAWebElement() {
        if (!(this.driver instanceof JavascriptExecutor)) {
            return;
        }
        this.driver.get(this.pages.xhtmlTestPage);
        Object result = this.executeScript("return document.getElementById('id1');", new Object[0]);
        ExecutingJavascriptTest.assertNotNull((Object)result);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.instanceOf(WebElement.class));
        ExecutingJavascriptTest.assertEquals((String)"a", (String)((WebElement)result).getTagName().toLowerCase());
    }

    @JavascriptEnabled
    public void testShouldBeAbleToExecuteSimpleJavascriptAndReturnABoolean() {
        if (!(this.driver instanceof JavascriptExecutor)) {
            return;
        }
        this.driver.get(this.pages.xhtmlTestPage);
        Object result = this.executeScript("return true;", new Object[0]);
        ExecutingJavascriptTest.assertNotNull((Object)result);
        ExecutingJavascriptTest.assertTrue((boolean)(result instanceof Boolean));
        ExecutingJavascriptTest.assertTrue((boolean)((Boolean)result));
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.SELENESE, Ignore.Driver.IPHONE})
    public void testShouldBeAbleToExecuteSimpleJavascriptAndAStringsArray() {
        if (!(this.driver instanceof JavascriptExecutor)) {
            return;
        }
        this.driver.get(this.pages.javascriptPage);
        ArrayList<String> expectedResult = new ArrayList<String>();
        expectedResult.add("zero");
        expectedResult.add("one");
        expectedResult.add("two");
        Object result = ((JavascriptExecutor)this.driver).executeScript("return ['zero', 'one', 'two'];", new Object[0]);
        ExecutingJavascriptTest.compareLists(expectedResult, (List)result);
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.SELENESE, Ignore.Driver.IPHONE})
    public void testShouldBeAbleToExecuteSimpleJavascriptAndReturnAnArray() {
        if (!(this.driver instanceof JavascriptExecutor)) {
            return;
        }
        this.driver.get(this.pages.javascriptPage);
        ArrayList<Object> expectedResult = new ArrayList<Object>();
        expectedResult.add("zero");
        ArrayList<Boolean> subList = new ArrayList<Boolean>();
        subList.add(true);
        subList.add(false);
        expectedResult.add(subList);
        Object result = this.executeScript("return ['zero', [true, false]];", new Object[0]);
        ExecutingJavascriptTest.assertNotNull((Object)result);
        ExecutingJavascriptTest.assertTrue((String)("result was: " + result + " (" + result.getClass() + ")"), (boolean)(result instanceof List));
        List list = (List)result;
        ExecutingJavascriptTest.assertTrue((boolean)ExecutingJavascriptTest.compareLists(expectedResult, list));
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.IE, Ignore.Driver.SELENESE, Ignore.Driver.IPHONE, Ignore.Driver.HTMLUNIT})
    public void testShouldBeAbleToExecuteJavascriptAndReturnABasicObjectLiteral() {
        if (!(this.driver instanceof JavascriptExecutor)) {
            return;
        }
        this.driver.get(this.pages.javascriptPage);
        Object result = this.executeScript("return {abc: '123', tired: false};", new Object[0]);
        ExecutingJavascriptTest.assertTrue((String)("result was: " + result + " (" + result.getClass() + ")"), (boolean)(result instanceof Map));
        Map map = (Map)result;
        HashMap<String, Object> expected = new HashMap<String, Object>();
        expected.put("abc", "123");
        expected.put("tired", false);
        ExecutingJavascriptTest.assertEquals((String)("Expected:<" + expected + ">, but was:<" + map + ">"), (int)expected.size(), (int)map.size());
        for (Map.Entry entry : expected.entrySet()) {
            ExecutingJavascriptTest.assertEquals((String)("Difference at key:<" + (String)entry.getKey() + ">"), entry.getValue(), map.get(entry.getKey()));
        }
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.IE, Ignore.Driver.SELENESE, Ignore.Driver.IPHONE, Ignore.Driver.HTMLUNIT})
    public void testShouldBeAbleToExecuteSimpleJavascriptAndReturnAnObjectLiteral() {
        if (!(this.driver instanceof JavascriptExecutor)) {
            return;
        }
        this.driver.get(this.pages.javascriptPage);
        HashMap<String, Object> expectedResult = new HashMap<String, Object>(){
            {
                this.put("foo", "bar");
                this.put("baz", Arrays.asList("a", "b", "c"));
                this.put("person", new HashMap<String, String>(){
                    {
                        this.put("first", "John");
                        this.put("last", "Doe");
                    }
                });
            }
        };
        Object result = this.executeScript("return {foo:'bar', baz: ['a', 'b', 'c'], person: {first: 'John',last: 'Doe'}};", new Object[0]);
        ExecutingJavascriptTest.assertTrue((String)("result was: " + result + " (" + result.getClass() + ")"), (boolean)(result instanceof Map));
        Map map = (Map)result;
        ExecutingJavascriptTest.assertEquals((String)("Expected:<" + expectedResult + ">, but was:<" + map + ">"), (int)3, (int)map.size());
        ExecutingJavascriptTest.assertEquals(expectedResult.keySet(), map.keySet());
        ExecutingJavascriptTest.assertEquals((Object)"bar", map.get("foo"));
        ExecutingJavascriptTest.assertTrue((boolean)ExecutingJavascriptTest.compareLists((List)expectedResult.get("baz"), (List)map.get("baz")));
        Map person = (Map)map.get("person");
        ExecutingJavascriptTest.assertEquals((int)2, (int)person.size());
        ExecutingJavascriptTest.assertEquals((String)"John", (String)((String)person.get("first")));
        ExecutingJavascriptTest.assertEquals((String)"Doe", (String)((String)person.get("last")));
    }

    private static boolean compareLists(List<?> first, List<?> second) {
        if (first.size() != second.size()) {
            return false;
        }
        for (int i = 0; i < first.size(); ++i) {
            if (first.get(i) instanceof List) {
                if (!(second instanceof List)) {
                    return false;
                }
                if (ExecutingJavascriptTest.compareLists((List)first.get(i), (List)second.get(i))) continue;
                return false;
            }
            if (first.get(i).equals(second.get(i))) continue;
            return false;
        }
        return true;
    }

    @JavascriptEnabled
    public void testPassingAndReturningALongShouldReturnAWholeNumber() {
        if (!(this.driver instanceof JavascriptExecutor)) {
            return;
        }
        this.driver.get(this.pages.javascriptPage);
        Long expectedResult = 1L;
        Object result = this.executeScript("return arguments[0];", expectedResult);
        ExecutingJavascriptTest.assertTrue((String)("Expected result to be an Integer or Long but was a " + result.getClass()), (result instanceof Integer || result instanceof Long ? 1 : 0) != 0);
        ExecutingJavascriptTest.assertEquals((Object)expectedResult, (Object)result);
    }

    @JavascriptEnabled
    public void testPassingAndReturningADoubleShouldReturnADecimal() {
        if (!(this.driver instanceof JavascriptExecutor)) {
            return;
        }
        this.driver.get(this.pages.javascriptPage);
        Double expectedResult = 1.2;
        Object result = this.executeScript("return arguments[0];", expectedResult);
        ExecutingJavascriptTest.assertTrue((String)("Expected result to be a Double or Float but was a " + result.getClass()), (result instanceof Float || result instanceof Double ? 1 : 0) != 0);
        ExecutingJavascriptTest.assertEquals((Object)expectedResult, (Object)result);
    }

    @JavascriptEnabled
    public void testShouldThrowAnExceptionWhenTheJavascriptIsBad() {
        if (!(this.driver instanceof JavascriptExecutor)) {
            return;
        }
        this.driver.get(this.pages.xhtmlTestPage);
        try {
            this.executeScript("return squiggle();", new Object[0]);
            ExecutingJavascriptTest.fail((String)"Expected an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.SELENESE})
    public void testShouldBeAbleToCallFunctionsDefinedOnThePage() {
        if (!(this.driver instanceof JavascriptExecutor)) {
            return;
        }
        this.driver.get(this.pages.javascriptPage);
        this.executeScript("displayMessage('I like cheese');", new Object[0]);
        String text = this.driver.findElement(By.id((String)"result")).getText();
        ExecutingJavascriptTest.assertEquals((String)"I like cheese", (String)text.trim());
    }

    private Object executeScript(String script, Object ... args) {
        return ((JavascriptExecutor)this.driver).executeScript(script, args);
    }

    @JavascriptEnabled
    public void testShouldBeAbleToPassAStringAnAsArgument() {
        if (!(this.driver instanceof JavascriptExecutor)) {
            return;
        }
        this.driver.get(this.pages.javascriptPage);
        String value = (String)this.executeScript("return arguments[0] == 'fish' ? 'fish' : 'not fish';", "fish");
        ExecutingJavascriptTest.assertEquals((String)"fish", (String)value);
    }

    @JavascriptEnabled
    public void testShouldBeAbleToPassABooleanAnAsArgument() {
        if (!(this.driver instanceof JavascriptExecutor)) {
            return;
        }
        this.driver.get(this.pages.javascriptPage);
        boolean value = (Boolean)this.executeScript("return arguments[0] == true;", true);
        ExecutingJavascriptTest.assertTrue((boolean)value);
    }

    @JavascriptEnabled
    public void testShouldBeAbleToPassANumberAnAsArgument() {
        if (!(this.driver instanceof JavascriptExecutor)) {
            return;
        }
        this.driver.get(this.pages.javascriptPage);
        boolean value = (Boolean)this.executeScript("return arguments[0] == 1 ? true : false;", 1);
        ExecutingJavascriptTest.assertTrue((boolean)value);
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.SELENESE})
    public void testShouldBeAbleToPassAWebElementAsArgument() {
        if (!(this.driver instanceof JavascriptExecutor)) {
            return;
        }
        this.driver.get(this.pages.javascriptPage);
        WebElement button = this.driver.findElement(By.id((String)"plainButton"));
        String value = (String)this.executeScript("arguments[0]['flibble'] = arguments[0].getAttribute('id'); return arguments[0]['flibble'];", button);
        ExecutingJavascriptTest.assertEquals((String)"plainButton", (String)value);
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.IE, Ignore.Driver.SELENESE})
    public void testShouldBeAbleToPassAnArrayAsArgument() {
        if (!(this.driver instanceof JavascriptExecutor)) {
            return;
        }
        this.driver.get(this.pages.javascriptPage);
        Object[] array = new Object[]{"zero", 1, true, 3.14159};
        long length = (Long)this.executeScript("return arguments[0].length", array);
        ExecutingJavascriptTest.assertEquals((long)array.length, (long)length);
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.IE, Ignore.Driver.SELENESE})
    public void testShouldBeAbleToPassACollectionAsArgument() {
        if (!(this.driver instanceof JavascriptExecutor)) {
            return;
        }
        this.driver.get(this.pages.javascriptPage);
        AbstractCollection collection = new ArrayList<Object>();
        collection.add("Cheddar");
        collection.add("Brie");
        collection.add(7);
        long length = (Long)this.executeScript("return arguments[0].length", collection);
        ExecutingJavascriptTest.assertEquals((long)collection.size(), (long)length);
        collection = new HashSet();
        collection.add("Gouda");
        collection.add("Stilton");
        collection.add("Stilton");
        collection.add(true);
        length = (Long)this.executeScript("return arguments[0].length", collection);
        ExecutingJavascriptTest.assertEquals((long)collection.size(), (long)length);
    }

    @JavascriptEnabled
    public void testShouldThrowAnExceptionIfAnArgumentIsNotValid() {
        if (!(this.driver instanceof JavascriptExecutor)) {
            return;
        }
        this.driver.get(this.pages.javascriptPage);
        try {
            this.executeScript("return arguments[0];", this.driver);
            ExecutingJavascriptTest.fail((String)"Exception should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @JavascriptEnabled
    public void testShouldBeAbleToPassInMoreThanOneArgument() {
        if (!(this.driver instanceof JavascriptExecutor)) {
            return;
        }
        this.driver.get(this.pages.javascriptPage);
        String result = (String)this.executeScript("return arguments[0] + arguments[1];", "one", "two");
        ExecutingJavascriptTest.assertEquals((String)"onetwo", (String)result);
    }

    @Ignore(value={Ignore.Driver.CHROME, Ignore.Driver.SELENESE, Ignore.Driver.IPHONE}, reason="Can't execute script in iframe, track crbug 20773\niPhone: Frame switching not yet implemented.")
    @JavascriptEnabled
    public void testShouldBeAbleToGrabTheBodyOfFrameOnceSwitchedTo() {
        this.driver.get(this.pages.richTextPage);
        this.driver.switchTo().frame("editFrame");
        WebElement body = (WebElement)((JavascriptExecutor)this.driver).executeScript("return document.body", new Object[0]);
        ExecutingJavascriptTest.assertEquals((String)"", (String)body.getText());
    }

    @Ignore
    public void testShouldBeAbleToReturnAnArrayOfWebElements() {
        this.driver.get(this.pages.formPage);
        List items = (List)((JavascriptExecutor)this.driver).executeScript("return document.getElementsByName('snack');", new Object[0]);
        ExecutingJavascriptTest.assertTrue((items.size() > 0 ? 1 : 0) != 0);
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.SELENESE})
    public void testJavascriptStringHandlingShouldWorkAsExpected() {
        this.driver.get(this.pages.javascriptPage);
        String value = (String)this.executeScript("return '';", new Object[0]);
        ExecutingJavascriptTest.assertEquals((String)"", (String)value);
        value = (String)this.executeScript("return undefined;", new Object[0]);
        ExecutingJavascriptTest.assertNull((Object)value);
        value = (String)this.executeScript("return ' '", new Object[0]);
        ExecutingJavascriptTest.assertEquals((String)" ", (String)value);
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.CHROME, Ignore.Driver.FIREFOX})
    public void testShouldBeAbleToExecuteABigChunkOfJavascriptCode() throws IOException {
        String jquery;
        this.driver.get(this.pages.javascriptPage);
        File jqueryFile = new File("common/src/web/jquery-1.3.2.js");
        if (!jqueryFile.isFile() && !(jqueryFile = new File("../common/src/web/jquery-1.3.2.js")).isFile()) {
            jqueryFile = new File("../../common/src/web/jquery-1.3.2.js");
        }
        ExecutingJavascriptTest.assertTrue((String)"The javascript code should be at least 50 KB.", ((jquery = FileUtils.readFileToString((File)jqueryFile, (String)"US-ASCII")).length() > 50000 ? 1 : 0) != 0);
        this.executeScript(jquery, new Object[0]);
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.SELENESE, Ignore.Driver.CHROME, Ignore.Driver.REMOTE, Ignore.Driver.IPHONE})
    public void testShouldBeAbleToExecuteScriptAndReturnElementsList() {
        this.driver.get(this.pages.formPage);
        String scriptToExec = "return document.getElementsByName('snack');";
        List resultsList = (List)((JavascriptExecutor)this.driver).executeScript(scriptToExec, new Object[0]);
        ExecutingJavascriptTest.assertTrue((resultsList.size() > 0 ? 1 : 0) != 0);
    }

    @JavascriptEnabled
    @NeedsFreshDriver
    @NoDriverAfterTest
    @Ignore
    public void testShouldThrowExceptionIfExecutingOnNoPage() {
        try {
            ((JavascriptExecutor)this.driver).executeScript("return 1;", new Object[0]);
        }
        catch (WebDriverException e) {
            return;
        }
        ExecutingJavascriptTest.fail((String)"Expected exception to be thrown");
    }

    @JavascriptEnabled
    public void testShouldBeAbleToCreateAPersistentValue() {
        this.driver.get(this.pages.formPage);
        this.executeScript("document.alerts = []", new Object[0]);
        this.executeScript("document.alerts.push('hello world');", new Object[0]);
        String text = (String)this.executeScript("return document.alerts.shift()", new Object[0]);
        ExecutingJavascriptTest.assertEquals((String)"hello world", (String)text);
    }
}

