/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.io.File;
import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.openqa.selenium.AbstractDriverTestCase;
import org.openqa.selenium.By;
import org.openqa.selenium.Ignore;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TestWaiter;
import org.openqa.selenium.WaitingConditions;
import org.openqa.selenium.WebElement;

public class FormHandlingTest
extends AbstractDriverTestCase {
    @Ignore(value={Ignore.Driver.SELENESE})
    public void testShouldClickOnSubmitInputElements() {
        this.driver.get(this.pages.formPage);
        this.driver.findElement(By.id((String)"submitButton")).click();
        TestWaiter.waitFor(WaitingConditions.pageTitleToBe(this.driver, "We Arrive Here"));
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)"We Arrive Here"));
    }

    public void testClickingOnUnclickableElementsDoesNothing() {
        this.driver.get(this.pages.formPage);
        try {
            this.driver.findElement(By.xpath((String)"//body")).click();
        }
        catch (Exception e) {
            e.printStackTrace();
            FormHandlingTest.fail((String)"Clicking on the unclickable should be a no-op");
        }
    }

    public void testShouldBeAbleToClickImageButtons() {
        this.driver.get(this.pages.formPage);
        this.driver.findElement(By.id((String)"imageButton")).click();
        TestWaiter.waitFor(WaitingConditions.pageTitleToBe(this.driver, "We Arrive Here"));
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)"We Arrive Here"));
    }

    public void testShouldBeAbleToSubmitForms() {
        this.driver.get(this.pages.formPage);
        this.driver.findElement(By.name((String)"login")).submit();
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)"We Arrive Here"));
    }

    public void testShouldSubmitAFormWhenAnyInputElementWithinThatFormIsSubmitted() {
        this.driver.get(this.pages.formPage);
        this.driver.findElement(By.id((String)"checky")).submit();
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)"We Arrive Here"));
    }

    public void testShouldSubmitAFormWhenAnyElementWihinThatFormIsSubmitted() {
        this.driver.get(this.pages.formPage);
        this.driver.findElement(By.xpath((String)"//form/p")).submit();
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)"We Arrive Here"));
    }

    public void testShouldNotBeAbleToSubmitAFormThatDoesNotExist() {
        this.driver.get(this.pages.formPage);
        try {
            this.driver.findElement(By.name((String)"there is no spoon")).submit();
            FormHandlingTest.fail((String)"Should not have succeeded");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testShouldBeAbleToEnterTextIntoATextAreaBySettingItsValue() {
        this.driver.get(this.pages.javascriptPage);
        WebElement textarea = this.driver.findElement(By.id((String)"keyUpArea"));
        String cheesey = "Brie and cheddar";
        textarea.sendKeys(new CharSequence[]{cheesey});
        MatcherAssert.assertThat((Object)textarea.getValue(), (Matcher)Matchers.equalTo((Object)cheesey));
    }

    @Ignore(value={Ignore.Driver.SELENESE, Ignore.Driver.CHROME_NON_WINDOWS, Ignore.Driver.IPHONE, Ignore.Driver.IE}, reason="New failure for IE")
    public void testShouldSubmitAFormUsingTheNewlineLiteral() {
        this.driver.get(this.pages.formPage);
        WebElement nestedForm = this.driver.findElement(By.id((String)"nested_form"));
        WebElement input = nestedForm.findElement(By.name((String)"x"));
        input.sendKeys(new CharSequence[]{"\n"});
        FormHandlingTest.assertEquals((String)"We Arrive Here", (String)this.driver.getTitle());
        FormHandlingTest.assertTrue((boolean)this.driver.getCurrentUrl().endsWith("?x=name"));
    }

    @Ignore(value={Ignore.Driver.SELENESE, Ignore.Driver.CHROME_NON_WINDOWS, Ignore.Driver.IPHONE, Ignore.Driver.IE})
    public void testShouldSubmitAFormUsingTheEnterKey() {
        this.driver.get(this.pages.formPage);
        WebElement nestedForm = this.driver.findElement(By.id((String)"nested_form"));
        WebElement input = nestedForm.findElement(By.name((String)"x"));
        input.sendKeys(new CharSequence[]{Keys.ENTER});
        FormHandlingTest.assertEquals((String)"We Arrive Here", (String)this.driver.getTitle());
        FormHandlingTest.assertTrue((boolean)this.driver.getCurrentUrl().endsWith("?x=name"));
    }

    public void testShouldEnterDataIntoFormFields() {
        this.driver.get(this.pages.xhtmlTestPage);
        WebElement element = this.driver.findElement(By.xpath((String)"//form[@name='someForm']/input[@id='username']"));
        String originalValue = element.getValue();
        MatcherAssert.assertThat((Object)originalValue, (Matcher)Matchers.equalTo((Object)"change"));
        element.clear();
        element.sendKeys(new CharSequence[]{"some text"});
        element = this.driver.findElement(By.xpath((String)"//form[@name='someForm']/input[@id='username']"));
        String newFormValue = element.getValue();
        MatcherAssert.assertThat((Object)newFormValue, (Matcher)Matchers.equalTo((Object)"some text"));
    }

    public void testShouldBeAbleToSelectACheckBox() {
        this.driver.get(this.pages.formPage);
        WebElement checkbox = this.driver.findElement(By.id((String)"checky"));
        MatcherAssert.assertThat((Object)checkbox.isSelected(), (Matcher)Matchers.is((Object)false));
        checkbox.setSelected();
        MatcherAssert.assertThat((Object)checkbox.isSelected(), (Matcher)Matchers.is((Object)true));
        checkbox.setSelected();
        MatcherAssert.assertThat((Object)checkbox.isSelected(), (Matcher)Matchers.is((Object)true));
    }

    @Ignore(value={Ignore.Driver.IPHONE})
    public void testShouldToggleTheCheckedStateOfACheckbox() {
        this.driver.get(this.pages.formPage);
        WebElement checkbox = this.driver.findElement(By.id((String)"checky"));
        MatcherAssert.assertThat((Object)checkbox.isSelected(), (Matcher)Matchers.is((Object)false));
        checkbox.toggle();
        MatcherAssert.assertThat((Object)checkbox.isSelected(), (Matcher)Matchers.is((Object)true));
        checkbox.toggle();
        MatcherAssert.assertThat((Object)checkbox.isSelected(), (Matcher)Matchers.is((Object)false));
    }

    @Ignore(value={Ignore.Driver.IPHONE})
    public void testTogglingACheckboxShouldReturnItsCurrentState() {
        this.driver.get(this.pages.formPage);
        WebElement checkbox = this.driver.findElement(By.id((String)"checky"));
        MatcherAssert.assertThat((Object)checkbox.isSelected(), (Matcher)Matchers.is((Object)false));
        boolean isChecked = checkbox.toggle();
        MatcherAssert.assertThat((Object)isChecked, (Matcher)Matchers.is((Object)true));
        isChecked = checkbox.toggle();
        MatcherAssert.assertThat((Object)isChecked, (Matcher)Matchers.is((Object)false));
    }

    public void testShouldNotBeAbleToSelectSomethingThatIsDisabled() {
        this.driver.get(this.pages.formPage);
        WebElement radioButton = this.driver.findElement(By.id((String)"nothing"));
        MatcherAssert.assertThat((Object)radioButton.isEnabled(), (Matcher)Matchers.is((Object)false));
        try {
            radioButton.setSelected();
            FormHandlingTest.fail((String)"Should not have succeeded");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testShouldBeAbleToSelectARadioButton() {
        this.driver.get(this.pages.formPage);
        WebElement radioButton = this.driver.findElement(By.id((String)"peas"));
        MatcherAssert.assertThat((Object)radioButton.isSelected(), (Matcher)Matchers.is((Object)false));
        radioButton.setSelected();
        MatcherAssert.assertThat((Object)radioButton.isSelected(), (Matcher)Matchers.is((Object)true));
    }

    public void testRadioShouldNotBeSelectedAfterSelectingSibling() {
        this.driver.get(this.pages.formPage);
        WebElement cheese = this.driver.findElement(By.id((String)"cheese"));
        WebElement peas = this.driver.findElement(By.id((String)"peas"));
        cheese.setSelected();
        MatcherAssert.assertThat((Object)cheese.isSelected(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)peas.isSelected(), (Matcher)Matchers.is((Object)false));
        peas.setSelected();
        MatcherAssert.assertThat((Object)peas.isSelected(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)cheese.isSelected(), (Matcher)Matchers.is((Object)false));
    }

    public void testShouldBeAbleToSelectARadioButtonByClickingOnIt() {
        this.driver.get(this.pages.formPage);
        WebElement radioButton = this.driver.findElement(By.id((String)"peas"));
        MatcherAssert.assertThat((Object)radioButton.isSelected(), (Matcher)Matchers.is((Object)false));
        radioButton.click();
        MatcherAssert.assertThat((Object)radioButton.isSelected(), (Matcher)Matchers.is((Object)true));
    }

    public void testShouldReturnStateOfRadioButtonsBeforeInteration() {
        this.driver.get(this.pages.formPage);
        WebElement radioButton = this.driver.findElement(By.id((String)"cheese_and_peas"));
        MatcherAssert.assertThat((Object)radioButton.isSelected(), (Matcher)Matchers.is((Object)true));
        radioButton = this.driver.findElement(By.id((String)"cheese"));
        MatcherAssert.assertThat((Object)radioButton.isSelected(), (Matcher)Matchers.is((Object)false));
    }

    @Ignore(value={Ignore.Driver.IPHONE})
    public void testShouldThrowAnExceptionWhenTogglingTheStateOfARadioButton() {
        this.driver.get(this.pages.formPage);
        WebElement radioButton = this.driver.findElement(By.id((String)"cheese"));
        try {
            radioButton.toggle();
            FormHandlingTest.fail((String)"You should not be able to toggle a radio button");
        }
        catch (UnsupportedOperationException e) {
            MatcherAssert.assertThat((Object)e.getMessage().contains("toggle"), (Matcher)Matchers.is((Object)true));
        }
    }

    @Ignore(value={Ignore.Driver.FIREFOX, Ignore.Driver.IE, Ignore.Driver.SELENESE, Ignore.Driver.IPHONE})
    public void testTogglingAnOptionShouldThrowAnExceptionIfTheOptionIsNotInAMultiSelect() {
        this.driver.get(this.pages.formPage);
        WebElement select = this.driver.findElement(By.name((String)"selectomatic"));
        WebElement option = (WebElement)select.findElements(By.tagName((String)"option")).get(0);
        try {
            option.toggle();
            FormHandlingTest.fail((String)"Should not be able to toggle an element");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Ignore(value={Ignore.Driver.FIREFOX, Ignore.Driver.IE, Ignore.Driver.SELENESE, Ignore.Driver.IPHONE, Ignore.Driver.ANDROID})
    public void testTogglingAnOptionShouldToggleOptionsInAMultiSelect() {
        this.driver.get(this.pages.formPage);
        WebElement select = this.driver.findElement(By.name((String)"multi"));
        WebElement option = (WebElement)select.findElements(By.tagName((String)"option")).get(0);
        boolean selected = option.isSelected();
        boolean current = option.toggle();
        FormHandlingTest.assertFalse((selected == current ? 1 : 0) != 0);
        current = option.toggle();
        FormHandlingTest.assertTrue((selected == current ? 1 : 0) != 0);
    }

    @Ignore(value={Ignore.Driver.CHROME, Ignore.Driver.SELENESE, Ignore.Driver.IPHONE, Ignore.Driver.ANDROID, Ignore.Driver.IE}, reason="Does not yet support file uploads")
    public void testShouldBeAbleToAlterTheContentsOfAFileUploadInputElement() throws IOException {
        this.driver.get(this.pages.formPage);
        WebElement uploadElement = this.driver.findElement(By.id((String)"upload"));
        MatcherAssert.assertThat((Object)uploadElement.getValue(), (Matcher)Matchers.equalTo((Object)""));
        File file = File.createTempFile("test", "txt");
        file.deleteOnExit();
        uploadElement.sendKeys(new CharSequence[]{file.getAbsolutePath()});
        File value = new File(uploadElement.getValue());
        MatcherAssert.assertThat((Object)value.getCanonicalPath(), (Matcher)Matchers.equalTo((Object)file.getCanonicalPath()));
    }

    @Ignore(value={Ignore.Driver.CHROME, Ignore.Driver.SELENESE, Ignore.Driver.IPHONE, Ignore.Driver.ANDROID}, reason="Does not yet support file uploads")
    public void testShouldBeAbleToUploadTheSameFileTwice() throws IOException {
        File file = File.createTempFile("test", "txt");
        file.deleteOnExit();
        this.driver.get(this.pages.formPage);
        WebElement uploadElement = this.driver.findElement(By.id((String)"upload"));
        MatcherAssert.assertThat((Object)uploadElement.getValue(), (Matcher)Matchers.equalTo((Object)""));
        uploadElement.sendKeys(new CharSequence[]{file.getAbsolutePath()});
        uploadElement.submit();
        this.driver.get(this.pages.formPage);
        uploadElement = this.driver.findElement(By.id((String)"upload"));
        MatcherAssert.assertThat((Object)uploadElement.getValue(), (Matcher)Matchers.equalTo((Object)""));
        uploadElement.sendKeys(new CharSequence[]{file.getAbsolutePath()});
        uploadElement.submit();
    }

    public void testShouldThrowAnExceptionWhenSelectingAnUnselectableElement() {
        this.driver.get(this.pages.formPage);
        WebElement element = this.driver.findElement(By.xpath((String)"//title"));
        try {
            element.setSelected();
            FormHandlingTest.fail((String)"Should not have succeeded");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Ignore(value={Ignore.Driver.IPHONE}, reason="iPhone: sendKeys implemented incorrectly")
    public void testSendingKeyboardEventsShouldAppendTextInInputs() {
        this.driver.get(this.pages.formPage);
        WebElement element = this.driver.findElement(By.id((String)"working"));
        element.sendKeys(new CharSequence[]{"Some"});
        String value = element.getValue();
        MatcherAssert.assertThat((Object)value, (Matcher)Matchers.is((Object)"Some"));
        element.sendKeys(new CharSequence[]{" text"});
        value = element.getValue();
        MatcherAssert.assertThat((Object)value, (Matcher)Matchers.is((Object)"Some text"));
    }

    @Ignore(value={Ignore.Driver.IE, Ignore.Driver.HTMLUNIT, Ignore.Driver.CHROME, Ignore.Driver.SELENESE, Ignore.Driver.IPHONE}, reason="Not implemented going to the end of the line first;\n  iPhone: sendKeys not implemented correctly")
    public void testSendingKeyboardEventsShouldAppendTextinTextAreas() {
        this.driver.get(this.pages.formPage);
        WebElement element = this.driver.findElement(By.id((String)"withText"));
        element.sendKeys(new CharSequence[]{". Some text"});
        String value = element.getValue();
        MatcherAssert.assertThat((Object)value, (Matcher)Matchers.is((Object)"Example text. Some text"));
    }

    public void testShouldBeAbleToClearTextFromInputElements() {
        this.driver.get(this.pages.formPage);
        WebElement element = this.driver.findElement(By.id((String)"working"));
        element.sendKeys(new CharSequence[]{"Some text"});
        String value = element.getValue();
        MatcherAssert.assertThat((Object)value.length(), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        element.clear();
        value = element.getValue();
        MatcherAssert.assertThat((Object)value.length(), (Matcher)Matchers.is((Object)0));
    }

    public void testEmptyTextBoxesShouldReturnAnEmptyStringNotNull() {
        this.driver.get(this.pages.formPage);
        WebElement emptyTextBox = this.driver.findElement(By.id((String)"working"));
        FormHandlingTest.assertEquals((String)emptyTextBox.getValue(), (String)"");
    }

    public void testShouldBeAbleToClearTextFromTextAreas() {
        this.driver.get(this.pages.formPage);
        WebElement element = this.driver.findElement(By.id((String)"withText"));
        element.sendKeys(new CharSequence[]{"Some text"});
        String value = element.getValue();
        MatcherAssert.assertThat((Object)value.length(), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        element.clear();
        value = element.getValue();
        MatcherAssert.assertThat((Object)value.length(), (Matcher)Matchers.is((Object)0));
    }
}

