/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.openqa.selenium.AbstractDriverTestCase;
import org.openqa.selenium.By;
import org.openqa.selenium.Ignore;
import org.openqa.selenium.JavascriptEnabled;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoDriverAfterTest;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.TestWaiter;
import org.openqa.selenium.WaitingConditions;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

@Ignore(value={Ignore.Driver.IPHONE}, reason="iPhone: Frame switching not supported;\nOthers: Implementation not updated to new frame-switching behavior")
public class FrameSwitchingTest
extends AbstractDriverTestCase {
    private static final int TIMEOUT = 4000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tearDown() throws Exception {
        try {
            this.driver.switchTo().defaultContent();
        }
        catch (Exception exception) {
        }
        finally {
            super.tearDown();
        }
    }

    public void testShouldAlwaysFocusOnTheTopMostFrameAfterANavigationEvent() {
        this.driver.get(this.pages.framesetPage);
        this.driver.findElement(By.tagName((String)"frameset"));
    }

    public void testShouldNotAutomaticallySwitchFocusToAnIFrameWhenAPageContainingThemIsLoaded() {
        this.driver.get(this.pages.iframePage);
        this.driver.findElement(By.id((String)"iframe_page_heading"));
    }

    public void testShouldBeAbleToSwitchToAFrameByItsIndex() {
        this.driver.get(this.pages.framesetPage);
        this.driver.switchTo().frame(1);
        MatcherAssert.assertThat((Object)this.driver.findElement(By.id((String)"pageNumber")).getText(), (Matcher)Matchers.equalTo((Object)"2"));
    }

    public void testShouldBeAbleToSwitchToAnIframeByItsIndex() {
        this.driver.get(this.pages.iframePage);
        this.driver.switchTo().frame(0);
        MatcherAssert.assertThat((Object)this.driver.findElement(By.name((String)"id-name1")).getValue(), (Matcher)Matchers.equalTo((Object)"name"));
    }

    public void testShouldBeAbleToSwitchToAFrameByItsName() {
        this.driver.get(this.pages.framesetPage);
        this.driver.switchTo().frame("fourth");
        MatcherAssert.assertThat((Object)this.driver.findElement(By.tagName((String)"frame")).getAttribute("name"), (Matcher)Matchers.equalTo((Object)"child1"));
    }

    public void testShouldBeAbleToSwitchToAnIframeByItsName() {
        this.driver.get(this.pages.iframePage);
        this.driver.switchTo().frame("iframe1-name");
        MatcherAssert.assertThat((Object)this.driver.findElement(By.name((String)"id-name1")).getValue(), (Matcher)Matchers.equalTo((Object)"name"));
    }

    public void testShouldBeAbleToSwitchToAFrameByItsID() {
        this.driver.get(this.pages.framesetPage);
        this.driver.switchTo().frame("fifth");
        MatcherAssert.assertThat((Object)this.driver.findElement(By.name((String)"windowOne")).getText(), (Matcher)Matchers.equalTo((Object)"Open new window"));
    }

    public void testShouldBeAbleToSwitchToAnIframeByItsID() {
        this.driver.get(this.pages.iframePage);
        this.driver.switchTo().frame("iframe1");
        MatcherAssert.assertThat((Object)this.driver.findElement(By.name((String)"id-name1")).getValue(), (Matcher)Matchers.equalTo((Object)"name"));
    }

    @Ignore(value={Ignore.Driver.SELENESE}, reason="switchTo().frame(WebElement) not supported with Selenium")
    public void testShouldBeAbleToSwitchToAFrameUsingAPreviouslyLocatedWebElement() {
        this.driver.get(this.pages.framesetPage);
        WebElement frame = this.driver.findElement(By.tagName((String)"frame"));
        this.driver.switchTo().frame(frame);
        MatcherAssert.assertThat((Object)this.driver.findElement(By.id((String)"pageNumber")).getText(), (Matcher)Matchers.equalTo((Object)"1"));
    }

    public void testShouldBeAbleToSwitchToAnIFrameUsingAPreviouslyLocatedWebElement() {
        this.driver.get(this.pages.iframePage);
        WebElement frame = this.driver.findElement(By.tagName((String)"iframe"));
        this.driver.switchTo().frame(frame);
        MatcherAssert.assertThat((Object)this.driver.findElement(By.name((String)"id-name1")).getValue(), (Matcher)Matchers.equalTo((Object)"name"));
    }

    @Ignore(value={Ignore.Driver.SELENESE}, reason="switchTo().frame(WebElement) not supported with Selenium")
    public void testShouldEnsureElementIsAFrameBeforeSwitching() {
        this.driver.get(this.pages.framesetPage);
        WebElement frame = this.driver.findElement(By.tagName((String)"frameset"));
        try {
            this.driver.switchTo().frame(frame);
            FrameSwitchingTest.fail();
        }
        catch (NoSuchFrameException noSuchFrameException) {
            // empty catch block
        }
    }

    public void testFrameSearchesShouldBeRelativeToTheCurrentlySelectedFrame() {
        this.driver.get(this.pages.framesetPage);
        this.driver.switchTo().frame("second");
        MatcherAssert.assertThat((Object)this.driver.findElement(By.id((String)"pageNumber")).getText(), (Matcher)Matchers.equalTo((Object)"2"));
        try {
            this.driver.switchTo().frame("third");
            FrameSwitchingTest.fail();
        }
        catch (NoSuchFrameException expected) {
            // empty catch block
        }
        this.driver.switchTo().defaultContent();
        this.driver.switchTo().frame("third");
        try {
            this.driver.switchTo().frame("second");
            FrameSwitchingTest.fail();
        }
        catch (NoSuchFrameException noSuchFrameException) {
            // empty catch block
        }
        this.driver.switchTo().defaultContent();
        this.driver.switchTo().frame("second");
        MatcherAssert.assertThat((Object)this.driver.findElement(By.id((String)"pageNumber")).getText(), (Matcher)Matchers.equalTo((Object)"2"));
    }

    public void testShouldSelectChildFramesByChainedCalls() {
        this.driver.get(this.pages.framesetPage);
        this.driver.switchTo().frame("fourth").switchTo().frame("child2");
        MatcherAssert.assertThat((Object)this.driver.findElement(By.id((String)"pageNumber")).getText(), (Matcher)Matchers.equalTo((Object)"11"));
    }

    public void testShouldThrowFrameNotFoundExceptionLookingUpSubFramesWithSuperFrameNames() {
        this.driver.get(this.pages.framesetPage);
        this.driver.switchTo().frame("fourth");
        try {
            this.driver.switchTo().frame("second");
            FrameSwitchingTest.fail((String)"Expected NoSuchFrameException");
        }
        catch (NoSuchFrameException noSuchFrameException) {
            // empty catch block
        }
    }

    public void testShouldThrowAnExceptionWhenAFrameCannotBeFound() {
        this.driver.get(this.pages.xhtmlTestPage);
        try {
            this.driver.switchTo().frame("Nothing here");
            FrameSwitchingTest.fail((String)"Should not have been able to switch");
        }
        catch (NoSuchFrameException noSuchFrameException) {
            // empty catch block
        }
    }

    public void testShouldThrowAnExceptionWhenAFrameCannotBeFoundByIndex() {
        this.driver.get(this.pages.xhtmlTestPage);
        try {
            this.driver.switchTo().frame(27);
            FrameSwitchingTest.fail((String)"Should not have been able to switch");
        }
        catch (NoSuchFrameException noSuchFrameException) {
            // empty catch block
        }
    }

    public void testShouldContinueToReferToTheSameFrameOnceItHasBeenSelected() {
        this.driver.get(this.pages.framesetPage);
        this.driver.switchTo().frame(2);
        WebElement checkbox = this.driver.findElement(By.xpath((String)"//input[@name='checky']"));
        checkbox.toggle();
        checkbox.submit();
        MatcherAssert.assertThat((Object)this.driver.findElement(By.xpath((String)"//p")).getText(), (Matcher)Matchers.equalTo((Object)"Success!"));
    }

    @Ignore(value={Ignore.Driver.ANDROID}, reason="Android does not detect that the select frame has disappeared")
    public void testShouldFocusOnTheReplacementWhenAFrameFollowsALinkToA_TopTargettedPage() throws Exception {
        this.driver.get(this.pages.framesetPage);
        this.driver.switchTo().frame(0);
        this.driver.findElement(By.linkText((String)"top")).click();
        Thread.sleep(1000L);
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)"XHTML Test Page"));
        MatcherAssert.assertThat((Object)this.driver.findElement(By.xpath((String)"/html/head/title")).getText(), (Matcher)Matchers.equalTo((Object)"XHTML Test Page"));
    }

    public void testShouldAllowAUserToSwitchFromAnIframeBackToTheMainContentOfThePage() {
        this.driver.get(this.pages.iframePage);
        this.driver.switchTo().frame(0);
        try {
            this.driver.switchTo().defaultContent();
            this.driver.findElement(By.id((String)"iframe_page_heading"));
        }
        catch (Exception e) {
            FrameSwitchingTest.fail((String)"Should have switched back to main content");
        }
    }

    public void testShouldAllowTheUserToSwitchToAnIFrameAndRemainFocusedOnIt() {
        this.driver.get(this.pages.iframePage);
        this.driver.switchTo().frame(0);
        this.driver.findElement(By.id((String)"submitButton")).click();
        MatcherAssert.assertThat((Object)this.getTextOfGreetingElement(), (Matcher)Matchers.equalTo((Object)"Success!"));
    }

    public String getTextOfGreetingElement() {
        return TestWaiter.waitFor(WaitingConditions.elementToExist(this.driver, "greeting")).getText();
    }

    public void testShouldBeAbleToClickInAFrame() {
        this.driver.get(this.pages.framesetPage);
        this.driver.switchTo().frame("third");
        this.driver.findElement(By.id((String)"submitButton")).click();
        MatcherAssert.assertThat((Object)this.getTextOfGreetingElement(), (Matcher)Matchers.equalTo((Object)"Success!"));
        this.driver.switchTo().defaultContent().switchTo().frame("third");
        MatcherAssert.assertThat((Object)this.getTextOfGreetingElement(), (Matcher)Matchers.equalTo((Object)"Success!"));
    }

    public void testShouldBeAbleToClickInASubFrame() {
        this.driver.get(this.pages.framesetPage);
        this.driver.switchTo().frame("sixth").switchTo().frame("iframe1");
        this.driver.findElement(By.id((String)"submitButton")).click();
        MatcherAssert.assertThat((Object)this.getTextOfGreetingElement(), (Matcher)Matchers.equalTo((Object)"Success!"));
        this.driver.switchTo().defaultContent().switchTo().frame("sixth").switchTo().frame("iframe1");
        MatcherAssert.assertThat((Object)this.driver.findElement(By.id((String)"greeting")).getText(), (Matcher)Matchers.equalTo((Object)"Success!"));
    }

    @NoDriverAfterTest
    @Ignore(value={Ignore.Driver.IPHONE, Ignore.Driver.CHROME})
    public void testClosingTheFinalBrowserWindowShouldNotCauseAnExceptionToBeThrown() {
        this.driver.get(this.pages.simpleTestPage);
        try {
            this.driver.close();
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            pw.flush();
            pw.close();
            FrameSwitchingTest.fail((String)("This is not expected. " + sw));
        }
    }

    public void testShouldBeAbleToFlipToAFrameIdentifiedByItsId() {
        this.driver.get(this.pages.framesetPage);
        this.driver.switchTo().frame("fifth");
        try {
            this.driver.findElement(By.id((String)"username"));
        }
        catch (NoSuchElementException e) {
            FrameSwitchingTest.fail((String)"Driver did not switch by frame id");
        }
    }

    public void testShouldBeAbleToFindElementsInIframesByXPath() {
        this.driver.get(this.pages.iframePage);
        this.driver.switchTo().frame("iframe1");
        WebElement element = this.driver.findElement(By.xpath((String)"//*[@id = 'changeme']"));
        FrameSwitchingTest.assertNotNull((Object)element);
    }

    public void testGetCurrentUrl() {
        this.driver.get(this.pages.framesetPage);
        this.driver.switchTo().frame("second");
        String url = this.appServer.whereIs("page/2");
        MatcherAssert.assertThat((Object)this.driver.getCurrentUrl(), (Matcher)Matchers.equalTo((Object)(url + "?title=Fish")));
        url = this.appServer.whereIs("iframes.html");
        this.driver.get(this.pages.iframePage);
        MatcherAssert.assertThat((Object)this.driver.getCurrentUrl(), (Matcher)Matchers.equalTo((Object)url));
        url = this.appServer.whereIs("formPage.html");
        this.driver.switchTo().frame("iframe1");
        MatcherAssert.assertThat((Object)this.driver.getCurrentUrl(), (Matcher)Matchers.equalTo((Object)url));
    }

    @Ignore(value={Ignore.Driver.IE, Ignore.Driver.HTMLUNIT, Ignore.Driver.CHROME}, reason="Appears to uncover an HtmlUnit bug")
    @JavascriptEnabled
    public void testShouldBeAbleToCarryOnWorkingIfTheFrameIsDeletedFromUnderUs() {
        this.driver.get(this.pages.deletingFrame);
        this.driver.switchTo().frame("iframe1");
        WebElement killIframe = this.driver.findElement(By.id((String)"killIframe"));
        killIframe.click();
        this.assertFrameNotPresent(this.driver, "iframe1");
        this.driver.switchTo().defaultContent();
        WebElement addIFrame = this.driver.findElement(By.id((String)"addBackFrame"));
        addIFrame.click();
        this.driver.switchTo().frame("iframe1");
        try {
            this.driver.findElement(By.id((String)"checkbox"));
        }
        catch (WebDriverException web) {
            FrameSwitchingTest.fail((String)"Could not find element after switching frame");
        }
    }

    @Ignore(value={Ignore.Driver.CHROME, Ignore.Driver.SELENESE}, reason="These drivers still return frame title.")
    public void testShouldReturnWindowTitleInAFrameset() {
        this.driver.get(this.pages.framesetPage);
        this.driver.switchTo().frame("third");
        FrameSwitchingTest.assertEquals((String)"Unique title", (String)this.driver.getTitle());
    }

    @JavascriptEnabled
    public void testJavaScriptShouldExecuteInTheContextOfTheCurrentFrame() {
        JavascriptExecutor executor = (JavascriptExecutor)this.driver;
        this.driver.get(this.pages.framesetPage);
        FrameSwitchingTest.assertTrue((boolean)((Boolean)executor.executeScript("return window == window.top", new Object[0])));
        this.driver.switchTo().frame("third");
        FrameSwitchingTest.assertTrue((boolean)((Boolean)executor.executeScript("return window != window.top", new Object[0])));
    }

    private void assertFrameNotPresent(WebDriver driver, String locator) {
        long end = System.currentTimeMillis() + 4000L;
        while (System.currentTimeMillis() < end) {
            try {
                driver.switchTo().frame(locator);
            }
            catch (NoSuchFrameException e) {
                return;
            }
        }
        FrameSwitchingTest.fail((String)"Frame did not disappear");
    }
}

