/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.Test;
import org.openqa.selenium.AbstractDriverTestCase;
import org.openqa.selenium.By;
import org.openqa.selenium.ElementNotVisibleException;
import org.openqa.selenium.Ignore;
import org.openqa.selenium.JavascriptEnabled;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.RenderedWebElement;
import org.openqa.selenium.WebElement;

public class ImplicitWaitTest
extends AbstractDriverTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        this.driver.manage().timeouts().implicitlyWait(0L, TimeUnit.MILLISECONDS);
    }

    protected void tearDown() throws Exception {
        this.driver.manage().timeouts().implicitlyWait(0L, TimeUnit.MILLISECONDS);
        super.tearDown();
    }

    @Test
    @JavascriptEnabled
    public void testShouldImplicitlyWaitForASingleElement() {
        this.driver.get(this.pages.dynamicPage);
        WebElement add = this.driver.findElement(By.id((String)"adder"));
        this.driver.manage().timeouts().implicitlyWait(3000L, TimeUnit.MILLISECONDS);
        add.click();
        this.driver.findElement(By.id((String)"box0"));
    }

    @Test
    @JavascriptEnabled
    public void testShouldStillFailToFindAnElementWhenImplicitWaitsAreEnabled() {
        this.driver.get(this.pages.dynamicPage);
        this.driver.manage().timeouts().implicitlyWait(500L, TimeUnit.MILLISECONDS);
        try {
            this.driver.findElement(By.id((String)"box0"));
            ImplicitWaitTest.fail((String)"Expected to throw.");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    @JavascriptEnabled
    public void testShouldReturnAfterFirstAttemptToFindOneAfterDisablingImplicitWaits() {
        this.driver.get(this.pages.dynamicPage);
        this.driver.manage().timeouts().implicitlyWait(3000L, TimeUnit.MILLISECONDS);
        this.driver.manage().timeouts().implicitlyWait(0L, TimeUnit.MILLISECONDS);
        try {
            this.driver.findElement(By.id((String)"box0"));
            ImplicitWaitTest.fail((String)"Expected to throw.");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    @JavascriptEnabled
    public void testShouldImplicitlyWaitUntilAtLeastOneElementIsFoundWhenSearchingForMany() {
        this.driver.get(this.pages.dynamicPage);
        WebElement add = this.driver.findElement(By.id((String)"adder"));
        this.driver.manage().timeouts().implicitlyWait(2000L, TimeUnit.MILLISECONDS);
        add.click();
        add.click();
        List elements = this.driver.findElements(By.className((String)"redbox"));
        ImplicitWaitTest.assertFalse((boolean)elements.isEmpty());
    }

    @Test
    @JavascriptEnabled
    public void testShouldStillFailToFindElementsWhenImplicitWaitsAreEnabled() {
        this.driver.get(this.pages.dynamicPage);
        this.driver.manage().timeouts().implicitlyWait(500L, TimeUnit.MILLISECONDS);
        List elements = this.driver.findElements(By.className((String)"redbox"));
        ImplicitWaitTest.assertTrue((boolean)elements.isEmpty());
    }

    @Test
    @JavascriptEnabled
    public void testShouldReturnAfterFirstAttemptToFindManyAfterDisablingImplicitWaits() {
        this.driver.get(this.pages.dynamicPage);
        WebElement add = this.driver.findElement(By.id((String)"adder"));
        this.driver.manage().timeouts().implicitlyWait(1100L, TimeUnit.MILLISECONDS);
        this.driver.manage().timeouts().implicitlyWait(0L, TimeUnit.MILLISECONDS);
        add.click();
        List elements = this.driver.findElements(By.className((String)"redbox"));
        ImplicitWaitTest.assertTrue((boolean)elements.isEmpty());
    }

    @Test
    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.ANDROID, Ignore.Driver.CHROME, Ignore.Driver.IE, Ignore.Driver.IPHONE, Ignore.Driver.SELENESE})
    public void testShouldImplicitlyWaitForAnElementToBeVisibleBeforeInteracting() {
        this.driver.get(this.pages.dynamicPage);
        WebElement reveal = this.driver.findElement(By.id((String)"reveal"));
        RenderedWebElement revealed = (RenderedWebElement)this.driver.findElement(By.id((String)"revealed"));
        this.driver.manage().timeouts().implicitlyWait(5000L, TimeUnit.MILLISECONDS);
        ImplicitWaitTest.assertFalse((String)"revealed should not be visible", (boolean)revealed.isDisplayed());
        reveal.click();
        try {
            revealed.sendKeys(new CharSequence[]{"hello world"});
        }
        catch (ElementNotVisibleException e) {
            ImplicitWaitTest.fail((String)"Element should have been visible");
        }
    }
}

