/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.awt.Dimension;
import java.awt.Point;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.matchers.JUnitMatchers;
import org.openqa.selenium.AbstractDriverTestCase;
import org.openqa.selenium.By;
import org.openqa.selenium.Ignore;
import org.openqa.selenium.JavascriptEnabled;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NeedsFreshDriver;
import org.openqa.selenium.RenderedWebElement;
import org.openqa.selenium.TestWaiter;
import org.openqa.selenium.WaitingConditions;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.Locatable;

public class JavascriptEnabledDriverTest
extends AbstractDriverTestCase {
    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.SELENESE}, reason="I'm not sure why this fails")
    public void testDocumentShouldReflectLatestTitle() throws Exception {
        this.driver.get(this.pages.javascriptPage);
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)"Testing Javascript"));
        this.driver.findElement(By.linkText((String)"Change the page title!")).click();
        this.waitForTitleChange("Changed");
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)"Changed"));
        String titleViaXPath = this.driver.findElement(By.xpath((String)"/html/head/title")).getText();
        MatcherAssert.assertThat((Object)titleViaXPath, (Matcher)Matchers.equalTo((Object)"Changed"));
    }

    @JavascriptEnabled
    public void testDocumentShouldReflectLatestDom() throws Exception {
        this.driver.get(this.pages.javascriptPage);
        String currentText = this.driver.findElement(By.xpath((String)"//div[@id='dynamo']")).getText();
        MatcherAssert.assertThat((Object)currentText, (Matcher)Matchers.equalTo((Object)"What's for dinner?"));
        WebElement webElement = this.driver.findElement(By.linkText((String)"Update a div"));
        webElement.click();
        WebElement dynamo = this.driver.findElement(By.xpath((String)"//div[@id='dynamo']"));
        TestWaiter.waitFor(WaitingConditions.elementTextToEqual(dynamo, "Fish and chips!"));
        MatcherAssert.assertThat((Object)dynamo.getText(), (Matcher)Matchers.equalTo((Object)"Fish and chips!"));
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.IE, Ignore.Driver.SELENESE, Ignore.Driver.CHROME_NON_WINDOWS, Ignore.Driver.IPHONE}, reason="Chrome failing on OS X;\n  iPhone: does not detect that a new page loaded.")
    public void testShouldWaitForLoadsToCompleteAfterJavascriptCausesANewPageToLoad() {
        this.driver.get(this.pages.formPage);
        this.driver.findElement(By.id((String)"changeme")).setSelected();
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)"Page3"));
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.IE, Ignore.Driver.SELENESE, Ignore.Driver.CHROME_NON_WINDOWS, Ignore.Driver.IPHONE}, reason="Chrome failing on OS X;\n  iPhone: does not detect that a new page loaded.")
    public void testShouldBeAbleToFindElementAfterJavascriptCausesANewPageToLoad() {
        this.driver.get(this.pages.formPage);
        this.driver.findElement(By.id((String)"changeme")).setSelected();
        MatcherAssert.assertThat((Object)this.driver.findElement(By.id((String)"pageNumber")).getText(), (Matcher)Matchers.equalTo((Object)"3"));
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.SELENESE})
    public void testShouldBeAbleToDetermineTheLocationOfAnElement() {
        this.driver.get(this.pages.xhtmlTestPage);
        RenderedWebElement element = (RenderedWebElement)this.driver.findElement(By.id((String)"username"));
        Point location = element.getLocation();
        MatcherAssert.assertThat((Object)(location.getX() > 0.0 ? 1 : 0), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)(location.getY() > 0.0 ? 1 : 0), (Matcher)Is.is((Object)true));
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.SELENESE})
    public void testShouldBeAbleToDetermineTheSizeOfAnElement() {
        this.driver.get(this.pages.xhtmlTestPage);
        RenderedWebElement element = (RenderedWebElement)this.driver.findElement(By.id((String)"username"));
        Dimension size = element.getSize();
        MatcherAssert.assertThat((Object)(size.getWidth() > 0.0 ? 1 : 0), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)(size.getHeight() > 0.0 ? 1 : 0), (Matcher)Is.is((Object)true));
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.CHROME_NON_WINDOWS, Ignore.Driver.IPHONE}, reason="iPhone: sendKeys not implemented correctly")
    public void testShouldFireOnChangeEventWhenSettingAnElementsValue() {
        this.driver.get(this.pages.javascriptPage);
        this.driver.findElement(By.id((String)"change")).sendKeys(new CharSequence[]{"foo"});
        String result = this.driver.findElement(By.id((String)"result")).getText();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)"change"));
    }

    @JavascriptEnabled
    public void testShouldBeAbleToSubmitFormsByCausingTheOnClickEventToFire() {
        this.driver.get(this.pages.javascriptPage);
        WebElement element = this.driver.findElement(By.id((String)"jsSubmitButton"));
        element.click();
        this.waitForTitleChange("We Arrive Here");
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.is((Object)"We Arrive Here"));
    }

    private void waitForTitleChange(String newTitle) {
        TestWaiter.waitFor(WaitingConditions.pageTitleToBe(this.driver, newTitle));
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.IE}, reason="Fails for IE in the continuous build")
    public void testShouldBeAbleToClickOnSubmitButtons() {
        this.driver.get(this.pages.javascriptPage);
        WebElement element = this.driver.findElement(By.id((String)"submittingButton"));
        element.click();
        this.waitForTitleChange("We Arrive Here");
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.is((Object)"We Arrive Here"));
    }

    @JavascriptEnabled
    public void testIssue80ClickShouldGenerateClickEvent() {
        this.driver.get(this.pages.javascriptPage);
        WebElement element = this.driver.findElement(By.id((String)"clickField"));
        JavascriptEnabledDriverTest.assertEquals((String)"Hello", (String)element.getValue());
        element.click();
        String elementValue = TestWaiter.waitFor(WaitingConditions.elementValueToEqual(element, "Clicked"));
        JavascriptEnabledDriverTest.assertEquals((String)"Clicked", (String)elementValue);
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.SELENESE, Ignore.Driver.IPHONE}, reason="iPhone: focus doesn't change as expected")
    public void testShouldBeAbleToSwitchToFocusedElement() {
        this.driver.get(this.pages.javascriptPage);
        this.driver.findElement(By.id((String)"switchFocus")).click();
        WebElement element = this.driver.switchTo().activeElement();
        MatcherAssert.assertThat((Object)element.getAttribute("id"), (Matcher)Is.is((Object)"theworks"));
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.SELENESE, Ignore.Driver.IPHONE})
    public void testIfNoElementHasFocusTheActiveElementIsTheBody() {
        this.driver.get(this.pages.simpleTestPage);
        WebElement element = this.driver.switchTo().activeElement();
        MatcherAssert.assertThat((Object)element.getAttribute("name"), (Matcher)Is.is((Object)"body"));
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.IE, Ignore.Driver.FIREFOX, Ignore.Driver.REMOTE, Ignore.Driver.CHROME, Ignore.Driver.SELENESE}, reason="Firefox: Window demands focus to work. Chrome: Event firing is broken.  Other platforms: not properly tested")
    public void testChangeEventIsFiredAppropriatelyWhenFocusIsLost() {
        this.driver.get(this.pages.javascriptPage);
        WebElement input = this.driver.findElement(By.id((String)"changeable"));
        input.sendKeys(new CharSequence[]{"test"});
        this.driver.findElement(By.id((String)"clickField")).click();
        MatcherAssert.assertThat((Object)this.driver.findElement(By.id((String)"result")).getText().trim(), (Matcher)JUnitMatchers.either((Matcher)Is.is((Object)"focus change blur")).or(Is.is((Object)"focus blur change")));
        input.sendKeys(new CharSequence[]{Keys.BACK_SPACE, "t"});
        this.driver.findElement(By.xpath((String)"//body")).click();
        MatcherAssert.assertThat((Object)this.driver.findElement(By.id((String)"result")).getText().trim(), (Matcher)JUnitMatchers.either((Matcher)Is.is((Object)"focus change blur focus blur")).or(Is.is((Object)"focus blur change focus blur")).or(Is.is((Object)"focus blur change focus blur change")).or(Is.is((Object)"focus change blur focus change blur")));
    }

    @JavascriptEnabled
    public void testShouldBeAbleToClickIfEvenSomethingHorribleHappens() {
        this.driver.get(this.pages.javascriptPage);
        this.driver.findElement(By.id((String)"error")).click();
        String text = this.driver.findElement(By.id((String)"error")).getText();
        JavascriptEnabledDriverTest.assertNotNull((Object)text);
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.SELENESE})
    public void testShouldBeAbleToGetTheLocationOfAnElement() {
        this.driver.get(this.pages.javascriptPage);
        if (!(this.driver instanceof JavascriptExecutor)) {
            return;
        }
        ((JavascriptExecutor)this.driver).executeScript("window.focus();", new Object[0]);
        WebElement element = this.driver.findElement(By.id((String)"keyUp"));
        if (!(element instanceof Locatable)) {
            return;
        }
        Point point = ((Locatable)element).getLocationOnScreenOnceScrolledIntoView();
        JavascriptEnabledDriverTest.assertTrue((point.getX() > 1.0 ? 1 : 0) != 0);
        JavascriptEnabledDriverTest.assertTrue((point.getY() > 1.0 ? 1 : 0) != 0);
    }

    @Ignore(value={Ignore.Driver.IE, Ignore.Driver.CHROME, Ignore.Driver.SELENESE, Ignore.Driver.IPHONE})
    @JavascriptEnabled
    @NeedsFreshDriver
    public void testShouldBeAbleToClickALinkThatClosesAWindow() throws Exception {
        this.driver.get(this.pages.javascriptPage);
        String handle = this.driver.getWindowHandle();
        this.driver.findElement(By.id((String)"new_window")).click();
        this.driver.switchTo().window("close_me");
        this.driver.findElement(By.id((String)"close")).click();
        this.driver.switchTo().window(handle);
    }
}

