/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import org.openqa.selenium.AbstractDriverTestCase;
import org.openqa.selenium.Ignore;
import org.openqa.selenium.JavascriptEnabled;
import org.openqa.selenium.JavascriptExecutor;

@Ignore(value={Ignore.Driver.HTMLUNIT, Ignore.Driver.IE, Ignore.Driver.IPHONE, Ignore.Driver.CHROME, Ignore.Driver.CHROME_NON_WINDOWS, Ignore.Driver.REMOTE})
public class JsApiTestCase
extends AbstractDriverTestCase {
    private static final long TWO_MINUTES = 120000L;
    private final String relativeUrl;

    public JsApiTestCase(String relativeUrl) {
        this.relativeUrl = relativeUrl;
        this.setName(relativeUrl);
    }

    @JavascriptEnabled
    protected void runTest() throws Throwable {
        Object result;
        String testUrl = this.appServer.whereIs(this.relativeUrl);
        this.driver.get(testUrl);
        JavascriptExecutor executor = (JavascriptExecutor)this.driver;
        long start = System.currentTimeMillis();
        while (null == (result = executor.executeScript(Query.IS_FINISHED.script, new Object[0])) || !((Boolean)result).booleanValue()) {
            long now = System.currentTimeMillis();
            long ellapsed = now - start;
            JsApiTestCase.assertTrue((String)("TIMEOUT after " + ellapsed + "ms"), (ellapsed <= 120000L ? 1 : 0) != 0);
        }
        result = executor.executeScript(Query.NUM_PASSED.script, new Object[0]);
        long numPassed = result == null ? 0L : (Long)result;
        result = executor.executeScript(Query.NUM_TESTS.script, new Object[0]);
        long numTests = result == null ? 0L : (Long)result;
        result = executor.executeScript(Query.NUM_ERRORS.script, new Object[0]);
        long numErrors = result == null ? 0L : (Long)result;
        String report = (String)executor.executeScript(Query.GET_REPORT.script, new Object[0]);
        JsApiTestCase.assertEquals((String)report, (long)numTests, (long)numPassed);
        JsApiTestCase.assertEquals((String)report, (long)0L, (long)numErrors);
        JsApiTestCase.assertTrue((String)"No tests run!", (numTests >= 0L ? 1 : 0) != 0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Query {
        IS_FINISHED("return !!tr && tr.isFinished();"),
        NUM_PASSED("return tr.testCase.result_.successCount;"),
        NUM_TESTS("return tr.testCase.result_.totalCount;"),
        NUM_ERRORS("return tr.testCase.result_.errors.length;"),
        GET_REPORT("return tr.getReport();");

        private final String script;

        private Query(String script) {
            this.script = "var tr = window.G_testRunner;" + script;
        }
    }
}

