/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.openqa.selenium.AbstractDriverTestCase;
import org.openqa.selenium.Ignore;
import org.openqa.selenium.JavascriptEnabled;

public class MiscTest
extends AbstractDriverTestCase {
    public void testShouldReportTheCurrentUrlCorrectly() {
        this.driver.get(this.pages.simpleTestPage);
        MiscTest.assertTrue((boolean)this.pages.simpleTestPage.equalsIgnoreCase(this.driver.getCurrentUrl()));
        this.driver.get(this.pages.javascriptPage);
        MiscTest.assertTrue((boolean)this.pages.javascriptPage.equalsIgnoreCase(this.driver.getCurrentUrl()));
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.SELENESE})
    public void testShouldReturnTheSourceOfAPage() {
        this.driver.get(this.pages.simpleTestPage);
        String source = this.driver.getPageSource().toLowerCase();
        MatcherAssert.assertThat((Object)source.contains("<html"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)source.contains("</html"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)source.contains("an inline element"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)source.contains("<p id="), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)source.contains("lotsofspaces"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)source.contains("with document.write and with document.write again"), (Matcher)Matchers.is((Object)true));
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.ANDROID, Ignore.Driver.IE, Ignore.Driver.SELENESE}, reason="Untested")
    public void testShouldBeAbleToGetTheSourceOfAnXmlDocument() {
        this.driver.get(this.pages.simpleXmlDocument);
        String source = this.driver.getPageSource().toLowerCase();
        MatcherAssert.assertThat((Object)source.replaceAll("\\s", ""), (Matcher)Matchers.equalTo((Object)"<xml><foo><bar>baz</bar></foo></xml>"));
    }
}

