/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.openqa.selenium.AbstractDriverTestCase;
import org.openqa.selenium.By;
import org.openqa.selenium.Ignore;
import org.openqa.selenium.JavascriptEnabled;
import org.openqa.selenium.NeedsFreshDriver;
import org.openqa.selenium.TestWaiter;
import org.openqa.selenium.WaitingConditions;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.environment.GlobalTestEnvironment;

public class PageLoadingTest
extends AbstractDriverTestCase {
    public void testShouldWaitForDocumentToBeLoaded() {
        this.driver.get(this.pages.simpleTestPage);
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)"Hello WebDriver"));
    }

    public void testShouldFollowRedirectsSentInTheHttpResponseHeaders() {
        this.driver.get(this.pages.redirectPage);
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)"We Arrive Here"));
    }

    public void testShouldFollowMetaRedirects() throws Exception {
        this.driver.get(this.pages.metaRedirectPage);
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)"We Arrive Here"));
    }

    @Ignore(value={Ignore.Driver.SELENESE})
    public void testShouldBeAbleToGetAFragmentOnTheCurrentPage() {
        this.driver.get(this.pages.xhtmlTestPage);
        this.driver.get(this.pages.xhtmlTestPage + "#text");
        this.driver.findElement(By.id((String)"id1"));
    }

    @Ignore(value={Ignore.Driver.SELENESE})
    public void testShouldReturnWhenGettingAUrlThatDoesNotResolve() {
        block2: {
            try {
                this.driver.get("http://www.thisurldoesnotexist.comx/");
            }
            catch (IllegalStateException e) {
                if (this.isIeDriverTimedOutException(e)) break block2;
                throw e;
            }
        }
    }

    @Ignore(value={Ignore.Driver.IPHONE, Ignore.Driver.SELENESE})
    public void testShouldReturnWhenGettingAUrlThatDoesNotConnect() {
        this.driver.get("http://localhost:3001");
    }

    @Ignore(value={Ignore.Driver.IE, Ignore.Driver.IPHONE, Ignore.Driver.SELENESE})
    public void testShouldBeAbleToLoadAPageWithFramesetsAndWaitUntilAllFramesAreLoaded() {
        this.driver.get(this.pages.framesetPage);
        this.driver.switchTo().frame(0);
        WebElement pageNumber = this.driver.findElement(By.xpath((String)"//span[@id='pageNumber']"));
        MatcherAssert.assertThat((Object)pageNumber.getText().trim(), (Matcher)Matchers.equalTo((Object)"1"));
        this.driver.switchTo().defaultContent().switchTo().frame(1);
        pageNumber = this.driver.findElement(By.xpath((String)"//span[@id='pageNumber']"));
        MatcherAssert.assertThat((Object)pageNumber.getText().trim(), (Matcher)Matchers.equalTo((Object)"2"));
    }

    @Ignore(value={Ignore.Driver.IPHONE, Ignore.Driver.SELENESE})
    @NeedsFreshDriver
    public void testSouldDoNothingIfThereIsNothingToGoBackTo() {
        String originalTitle = this.driver.getTitle();
        this.driver.get(this.pages.formPage);
        this.driver.navigate().back();
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.anyOf((Matcher[])new Matcher[]{Matchers.equalTo((Object)originalTitle), Matchers.equalTo((Object)"We Leave From Here")}));
    }

    @Ignore(value={Ignore.Driver.SELENESE})
    public void testShouldBeAbleToNavigateBackInTheBrowserHistory() {
        this.driver.get(this.pages.formPage);
        this.driver.findElement(By.id((String)"imageButton")).submit();
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)"We Arrive Here"));
        this.driver.navigate().back();
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)"We Leave From Here"));
    }

    @Ignore(value={Ignore.Driver.SELENESE})
    public void testShouldBeAbleToNavigateBackInTheBrowserHistoryInPresenceOfIframes() {
        this.driver.get(this.pages.xhtmlTestPage);
        this.driver.findElement(By.name((String)"sameWindow")).click();
        TestWaiter.waitFor(WaitingConditions.pageTitleToBe(this.driver, "This page has iframes"));
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)"This page has iframes"));
        this.driver.navigate().back();
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)"XHTML Test Page"));
    }

    @Ignore(value={Ignore.Driver.SELENESE})
    public void testShouldBeAbleToNavigateForwardsInTheBrowserHistory() {
        this.driver.get(this.pages.formPage);
        this.driver.findElement(By.id((String)"imageButton")).submit();
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)"We Arrive Here"));
        this.driver.navigate().back();
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)"We Leave From Here"));
        this.driver.navigate().forward();
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)"We Arrive Here"));
    }

    @Ignore(value={Ignore.Driver.IE, Ignore.Driver.CHROME, Ignore.Driver.SELENESE, Ignore.Driver.IPHONE})
    public void testShouldBeAbleToAccessPagesWithAnInsecureSslCertificate() {
        String url = GlobalTestEnvironment.get().getAppServer().whereIsSecure("simpleTest.html");
        this.driver.get(url);
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)"Hello WebDriver"));
    }

    @Ignore(value={Ignore.Driver.IE, Ignore.Driver.SELENESE})
    public void testShouldBeAbleToRefreshAPage() {
        this.driver.get(this.pages.xhtmlTestPage);
        this.driver.navigate().refresh();
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)"XHTML Test Page"));
    }

    @Ignore(value={Ignore.Driver.IE, Ignore.Driver.SELENESE, Ignore.Driver.CHROME, Ignore.Driver.IPHONE}, reason="Untested user-agents")
    @JavascriptEnabled
    public void testShouldNotHangIfDocumentOpenCallIsNeverFollowedByDocumentCloseCall() throws Exception {
        this.driver.get(this.pages.documentWrite);
        this.driver.findElement(By.xpath((String)"//body"));
    }
}

