/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParallelTestRunner {
    private final List<Worker> _workers;

    public ParallelTestRunner(List<Worker> workers) {
        this._workers = workers;
    }

    public void run() throws Exception {
        ArrayList<WorkerThread> threads = new ArrayList<WorkerThread>(this._workers.size());
        Throwable t = null;
        int i = 1;
        for (Worker worker : this._workers) {
            WorkerThread thread = new WorkerThread("WorkerThread #" + i, worker);
            ++i;
            threads.add(thread);
            thread.start();
        }
        for (WorkerThread thread : threads) {
            try {
                thread.join();
                if (t == null) {
                    t = thread.getThrowable();
                    continue;
                }
                Throwable t2 = thread.getThrowable();
                if (t2 == null) continue;
                System.err.println(thread + " failed.");
                t2.printStackTrace(System.err);
            }
            catch (InterruptedException ignored) {
                this.interrupt(threads);
            }
        }
        if (t != null) {
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new RuntimeException("Unexpected Throwable " + t.getClass().getName(), t);
        }
    }

    private void interrupt(List<WorkerThread> threads) {
        for (WorkerThread thread : threads) {
            thread.interrupt();
        }
    }

    private static class WorkerThread
    extends Thread {
        private final Worker _worker;
        private Throwable _throwable;

        private WorkerThread(String name, Worker worker) {
            super(name);
            this._worker = worker;
        }

        public void run() {
            try {
                this._worker.run();
            }
            catch (Throwable t) {
                this._throwable = t;
            }
        }

        public Throwable getThrowable() {
            return this._throwable;
        }
    }

    public static interface Worker {
        public void run() throws Exception;
    }
}

