/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.util.List;
import org.openqa.selenium.AbstractDriverTestCase;
import org.openqa.selenium.By;
import org.openqa.selenium.Ignore;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;

public class PartialLinkTextMatchTest
extends AbstractDriverTestCase {
    @Ignore(value={Ignore.Driver.IE, Ignore.Driver.REMOTE, Ignore.Driver.SELENESE})
    public void testLinkWithFormattingTags() {
        this.driver.get(this.pages.simpleTestPage);
        WebElement elem = this.driver.findElement(By.id((String)"links"));
        WebElement res = elem.findElement(By.partialLinkText((String)"link with formatting tags"));
        PartialLinkTextMatchTest.assertNotNull((Object)res);
        PartialLinkTextMatchTest.assertEquals((String)"link with formatting tags", (String)res.getText());
    }

    @Ignore(value={Ignore.Driver.IE, Ignore.Driver.REMOTE, Ignore.Driver.SELENESE})
    public void testLinkWithLeadingSpaces() {
        this.driver.get(this.pages.simpleTestPage);
        WebElement elem = this.driver.findElement(By.id((String)"links"));
        WebElement res = elem.findElement(By.partialLinkText((String)"link with leading space"));
        PartialLinkTextMatchTest.assertNotNull((Object)res);
        PartialLinkTextMatchTest.assertEquals((String)"link with leading space", (String)res.getText());
    }

    @Ignore(value={Ignore.Driver.IE, Ignore.Driver.REMOTE, Ignore.Driver.SELENESE})
    public void testLinkWithTrailingSpace() {
        this.driver.get(this.pages.simpleTestPage);
        WebElement elem = this.driver.findElement(By.id((String)"links"));
        WebElement res = elem.findElement(By.partialLinkText((String)"link with trailing space"));
        PartialLinkTextMatchTest.assertNotNull((Object)res);
        PartialLinkTextMatchTest.assertEquals((String)"link with trailing space", (String)res.getText());
    }

    @Ignore(value={Ignore.Driver.IE, Ignore.Driver.REMOTE, Ignore.Driver.SELENESE})
    public void testFindMultipleElements() {
        this.driver.get(this.pages.simpleTestPage);
        WebElement elem = this.driver.findElement(By.id((String)"links"));
        List elements = elem.findElements(By.partialLinkText((String)"link"));
        PartialLinkTextMatchTest.assertNotNull((Object)elements);
        PartialLinkTextMatchTest.assertEquals((int)3, (int)elements.size());
    }

    public void testCanGetLinkByLinkTestIgnoringTrailingWhitespace() {
        this.driver.get(this.pages.simpleTestPage);
        WebElement link = null;
        try {
            link = this.driver.findElement(By.linkText((String)"link with trailing space"));
        }
        catch (NoSuchElementException e) {
            PartialLinkTextMatchTest.fail((String)"Should have found link");
        }
        PartialLinkTextMatchTest.assertEquals((String)"linkWithTrailingSpace", (String)link.getAttribute("id"));
    }
}

