/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import junit.framework.TestCase;
import org.openqa.selenium.Platform;

public class PlatformTest
extends TestCase {
    public void testShouldIdentifyWindowsVariants() {
        this.assertAllAre(Platform.WINDOWS, "Windows 2003");
    }

    public void testShouldIdentifyMacVariants() {
        this.assertAllAre(Platform.MAC, "Darwin", "Mac OS X");
    }

    public void testShouldIdentifyUnixVariants() {
        this.assertAllAre(Platform.UNIX, "solaris", "bsd");
    }

    public void testShouldIdentifyLinux() {
        this.assertAllAre(Platform.LINUX, "Linux");
    }

    public void testShouldDistinctLinuxFromUnix() {
        Platform linPlatform = Platform.extractFromSysProperty((String)"Linux");
        PlatformTest.assertTrue((String)"Linux should be identified as Unix", (boolean)linPlatform.is(Platform.UNIX));
        Platform anyUnixPlatform = Platform.extractFromSysProperty((String)"solaris");
        PlatformTest.assertFalse((String)"Unix should NOT be identified as Linux", (boolean)anyUnixPlatform.is(Platform.LINUX));
    }

    private void assertAllAre(Platform platform, String ... osNames) {
        for (String osName : osNames) {
            Platform seen = Platform.extractFromSysProperty((String)osName);
            PlatformTest.assertTrue((String)String.format("Expected %s, but got %s from %s", platform, seen, osName), (boolean)seen.is(platform));
        }
    }
}

