/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import junit.framework.TestCase;
import org.openqa.selenium.Proxy;

public class ProxyTest
extends TestCase {
    public void testUnspecified() {
        Proxy proxy = new Proxy();
        ProxyTest.assertEquals((Object)Proxy.ProxyType.UNSPECIFIED, (Object)proxy.getProxyType());
        ProxyTest.assertFalse((boolean)proxy.isAutodetect());
        ProxyTest.assertNull((Object)proxy.getHttpProxy());
        ProxyTest.assertNull((Object)proxy.getProxyAutoconfigUrl());
    }

    public void testDirect() {
        Proxy proxy = new Proxy();
        proxy.setProxyType(Proxy.ProxyType.DIRECT);
        try {
            proxy.setHttpProxy("foo:1234");
            ProxyTest.fail((String)"Should not be able to set manual type for direct proxy");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testManual() {
        Proxy proxy = new Proxy();
        proxy.setHttpProxy("foo:1234");
        proxy.setFtpProxy("bar");
        proxy.setSslProxy("baz");
        proxy.setNoProxy("localhost");
        ProxyTest.assertEquals((Object)Proxy.ProxyType.MANUAL, (Object)proxy.getProxyType());
        ProxyTest.assertFalse((boolean)proxy.isAutodetect());
        try {
            proxy.setAutodetect(true);
            ProxyTest.fail((String)"Didn't throw expected assertion");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            proxy.setProxyAutoconfigUrl("http://aaaa");
            ProxyTest.fail((String)"Didn't throw expected assertion");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testPac() {
        Proxy proxy = new Proxy();
        proxy.setProxyAutoconfigUrl("http://aaa/bbb.pac");
        ProxyTest.assertEquals((Object)proxy.getProxyType(), (Object)Proxy.ProxyType.PAC);
        ProxyTest.assertFalse((boolean)proxy.isAutodetect());
        try {
            proxy.setAutodetect(true);
            ProxyTest.fail((String)"Didn't throw expected assertion");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        ProxyTest.assertNull((Object)proxy.getHttpProxy());
        try {
            proxy.setHttpProxy("foo");
            ProxyTest.fail((String)"Didn't throw expected assertion");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

