/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.awt.Dimension;
import java.awt.Point;
import org.openqa.selenium.AbstractDriverTestCase;
import org.openqa.selenium.By;
import org.openqa.selenium.Ignore;
import org.openqa.selenium.JavascriptEnabled;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Platform;
import org.openqa.selenium.RenderedWebElement;

public class RenderedWebElementTest
extends AbstractDriverTestCase {
    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.SELENESE, Ignore.Driver.IPHONE})
    public void testShouldPickUpStyleOfAnElement() {
        this.driver.get(this.pages.javascriptPage);
        RenderedWebElement element = (RenderedWebElement)this.driver.findElement(By.id((String)"green-parent"));
        String backgroundColour = element.getValueOfCssProperty("background-color");
        RenderedWebElementTest.assertEquals((String)"#008000", (String)backgroundColour);
        element = (RenderedWebElement)this.driver.findElement(By.id((String)"red-item"));
        backgroundColour = element.getValueOfCssProperty("background-color");
        RenderedWebElementTest.assertEquals((String)"#ff0000", (String)backgroundColour);
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.IE, Ignore.Driver.CHROME, Ignore.Driver.SELENESE, Ignore.Driver.IPHONE})
    public void testShouldHandleNonIntegerPositionAndSize() {
        this.driver.get(this.pages.rectanglesPage);
        RenderedWebElement r2 = (RenderedWebElement)this.driver.findElement(By.id((String)"r2"));
        String left = r2.getValueOfCssProperty("left");
        RenderedWebElementTest.assertTrue((String)("left (\"" + left + "\") should start with \"10.9\"."), (boolean)left.startsWith("10.9"));
        String top = r2.getValueOfCssProperty("top");
        RenderedWebElementTest.assertTrue((String)("top (\"" + top + "\") should start with \"10.1\"."), (boolean)top.startsWith("10.1"));
        RenderedWebElementTest.assertEquals((Object)new Point(11, 10), (Object)r2.getLocation());
        String width = r2.getValueOfCssProperty("width");
        RenderedWebElementTest.assertTrue((String)("width (\"" + left + "\") should start with \"48.6\"."), (boolean)width.startsWith("48.6"));
        String height = r2.getValueOfCssProperty("height");
        RenderedWebElementTest.assertTrue((String)("height (\"" + left + "\") should start with \"49.3\"."), (boolean)height.startsWith("49.3"));
        RenderedWebElementTest.assertEquals((Object)r2.getSize(), (Object)new Dimension(49, 49));
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.SELENESE, Ignore.Driver.IPHONE})
    public void testShouldAllowInheritedStylesToBeUsed() {
        this.driver.get(this.pages.javascriptPage);
        RenderedWebElement element = (RenderedWebElement)this.driver.findElement(By.id((String)"green-item"));
        String backgroundColour = element.getValueOfCssProperty("background-color");
        RenderedWebElementTest.assertEquals((String)"transparent", (String)backgroundColour);
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.IPHONE, Ignore.Driver.CHROME, Ignore.Driver.SELENESE, Ignore.Driver.HTMLUNIT})
    public void testShouldAllowUsersToHoverOverElements() {
        this.driver.get(this.pages.javascriptPage);
        RenderedWebElement element = (RenderedWebElement)this.driver.findElement(By.id((String)"menu1"));
        if (!Platform.getCurrent().is(Platform.WINDOWS)) {
            System.out.println("Skipping hover test: needs native events");
            return;
        }
        RenderedWebElement item = (RenderedWebElement)this.driver.findElement(By.id((String)"item1"));
        RenderedWebElementTest.assertEquals((String)"", (String)item.getText());
        ((JavascriptExecutor)this.driver).executeScript("arguments[0].style.background = 'green'", new Object[]{element});
        element.hover();
        RenderedWebElementTest.assertEquals((String)"Item 1", (String)item.getText());
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.SELENESE})
    public void testShouldCorrectlyIdentifyThatAnElementHasWidth() {
        this.driver.get(this.pages.xhtmlTestPage);
        RenderedWebElement shrinko = (RenderedWebElement)this.driver.findElement(By.id((String)"linkId"));
        Dimension size = shrinko.getSize();
        RenderedWebElementTest.assertTrue((String)"Width expected to be greater than 0", (size.width > 0 ? 1 : 0) != 0);
        RenderedWebElementTest.assertTrue((String)"Height expected to be greater than 0", (size.height > 0 ? 1 : 0) != 0);
    }

    @JavascriptEnabled
    @Ignore
    public void testCanClickOnSuckerFishMenuItem() throws Exception {
        this.driver.get(this.pages.javascriptPage);
        RenderedWebElement element = (RenderedWebElement)this.driver.findElement(By.id((String)"menu1"));
        if (!Platform.getCurrent().is(Platform.WINDOWS)) {
            System.out.println("Skipping hover test: needs native events");
            return;
        }
        element.hover();
        RenderedWebElement target = (RenderedWebElement)this.driver.findElement(By.id((String)"item1"));
        RenderedWebElementTest.assertTrue((boolean)target.isDisplayed());
        target.click();
        String text = this.driver.findElement(By.id((String)"result")).getText();
        RenderedWebElementTest.assertTrue((boolean)text.contains("item 1"));
    }
}

