/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.openqa.selenium.AbstractDriverTestCase;
import org.openqa.selenium.By;
import org.openqa.selenium.Ignore;
import org.openqa.selenium.WebElement;

public class SelectElementHandlingTest
extends AbstractDriverTestCase {
    @Ignore(value={Ignore.Driver.IE, Ignore.Driver.SELENESE, Ignore.Driver.IPHONE})
    public void testShouldBePossibleToDeselectASingleOptionFromASelectWhichAllowsMultipleChoices() {
        this.driver.get(this.pages.formPage);
        WebElement multiSelect = this.driver.findElement(By.id((String)"multi"));
        List options = multiSelect.findElements(By.tagName((String)"option"));
        WebElement option = (WebElement)options.get(0);
        MatcherAssert.assertThat((Object)option.isSelected(), (Matcher)Matchers.is((Object)true));
        option.toggle();
        MatcherAssert.assertThat((Object)option.isSelected(), (Matcher)Matchers.is((Object)false));
        option.toggle();
        MatcherAssert.assertThat((Object)option.isSelected(), (Matcher)Matchers.is((Object)true));
        option = (WebElement)options.get(2);
        MatcherAssert.assertThat((Object)option.isSelected(), (Matcher)Matchers.is((Object)true));
    }

    @Ignore(value={Ignore.Driver.IE, Ignore.Driver.SELENESE, Ignore.Driver.IPHONE})
    public void testShouldNotBeAbleToDeselectAnOptionFromANormalSelect() {
        this.driver.get(this.pages.formPage);
        WebElement select = this.driver.findElement(By.xpath((String)"//select[@name='selectomatic']"));
        List options = select.findElements(By.tagName((String)"option"));
        WebElement option = (WebElement)options.get(0);
        try {
            option.toggle();
            SelectElementHandlingTest.fail((String)"Should not have succeeded");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
    }

    @Ignore(value={Ignore.Driver.SELENESE})
    public void testShouldBeAbleToChangeTheSelectedOptionInASelect() {
        this.driver.get(this.pages.formPage);
        WebElement selectBox = this.driver.findElement(By.xpath((String)"//select[@name='selectomatic']"));
        List options = selectBox.findElements(By.tagName((String)"option"));
        WebElement one = (WebElement)options.get(0);
        WebElement two = (WebElement)options.get(1);
        MatcherAssert.assertThat((Object)one.isSelected(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)two.isSelected(), (Matcher)Matchers.is((Object)false));
        two.setSelected();
        MatcherAssert.assertThat((Object)one.isSelected(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)two.isSelected(), (Matcher)Matchers.is((Object)true));
    }

    @Ignore(value={Ignore.Driver.SELENESE})
    public void testShouldBeAbleToSelectMoreThanOneOptionFromASelectWhichAllowsMultipleChoices() {
        this.driver.get(this.pages.formPage);
        WebElement multiSelect = this.driver.findElement(By.id((String)"multi"));
        List options = multiSelect.findElements(By.tagName((String)"option"));
        for (WebElement option : options) {
            option.setSelected();
        }
        for (int i = 0; i < options.size(); ++i) {
            WebElement option;
            option = (WebElement)options.get(i);
            MatcherAssert.assertThat((String)("Option at index is not selected but should be: " + i), (Object)option.isSelected(), (Matcher)Matchers.is((Object)true));
        }
    }
}

