/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import org.openqa.selenium.AbstractDriverTestCase;
import org.openqa.selenium.Ignore;

public class SlowLoadingPageTest
extends AbstractDriverTestCase {
    private static final long LOAD_TIME_IN_SECONDS = 3L;

    @Ignore(value={Ignore.Driver.IE, Ignore.Driver.IPHONE}, reason="Untested browsers")
    public void testShouldBlockUnitlPageLoads() throws Exception {
        long start = System.currentTimeMillis();
        this.driver.get(this.pages.sleepingPage + "?time=" + 3L);
        long now = System.currentTimeMillis();
        SlowLoadingPageTest.assertElapsed(3000L, now - start);
    }

    @Ignore(value={Ignore.Driver.SELENESE})
    public void testShouldBlockUntilIFramesAreLoaded() throws Exception {
        long start = System.currentTimeMillis();
        this.driver.get(this.pages.slowIframes);
        long now = System.currentTimeMillis();
        SlowLoadingPageTest.assertElapsed(3000L, now - start);
    }

    @Ignore(value={Ignore.Driver.IE, Ignore.Driver.IPHONE, Ignore.Driver.SELENESE, Ignore.Driver.CHROME}, reason="Chrome: doesn't work; Selenium: refresh is unsupported; Others: untested")
    public void testRefreshShouldBlockUntilPageLoads() {
        long start = System.currentTimeMillis();
        this.driver.get(this.pages.sleepingPage + "?time=" + 3L);
        SlowLoadingPageTest.assertElapsed(3000L, System.currentTimeMillis() - start);
        long refreshed = System.currentTimeMillis();
        this.driver.navigate().refresh();
        SlowLoadingPageTest.assertElapsed(3000L, System.currentTimeMillis() - refreshed);
    }

    private static void assertElapsed(long expected, long actual) {
        SlowLoadingPageTest.assertTrue((String)(expected + "ms should have ellapsed, but was: " + actual), (expected <= actual ? 1 : 0) != 0);
    }
}

