/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.io.File;
import org.openqa.selenium.AbstractDriverTestCase;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;

public class TakesScreenshotTest
extends AbstractDriverTestCase {
    public void testSaveScreenshotAsFile() throws Exception {
        if (!this.isAbleToTakeScreenshots(this.driver)) {
            return;
        }
        this.driver.get(this.pages.simpleTestPage);
        File tempFile = (File)this.getScreenshot().getScreenshotAs(OutputType.FILE);
        TakesScreenshotTest.assertTrue((boolean)tempFile.exists());
        TakesScreenshotTest.assertTrue((tempFile.length() > 0L ? 1 : 0) != 0);
        tempFile.delete();
    }

    public void testCaptureToBase64() throws Exception {
        if (!this.isAbleToTakeScreenshots(this.driver)) {
            return;
        }
        this.driver.get(this.pages.simpleTestPage);
        String screenshot = (String)this.getScreenshot().getScreenshotAs(OutputType.BASE64);
        TakesScreenshotTest.assertTrue((screenshot.length() > 0 ? 1 : 0) != 0);
    }

    public TakesScreenshot getScreenshot() {
        return (TakesScreenshot)this.driver;
    }

    private boolean isAbleToTakeScreenshots(WebDriver driver) throws Exception {
        return driver instanceof TakesScreenshot;
    }
}

