/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.openqa.selenium.DriverTestDecorator;
import org.openqa.selenium.EnvironmentStarter;
import org.openqa.selenium.Ignore;
import org.openqa.selenium.JavascriptEnabled;
import org.openqa.selenium.JsApiTestCase;
import org.openqa.selenium.NeedsDriver;
import org.openqa.selenium.NeedsFreshDriver;
import org.openqa.selenium.NoDriverAfterTest;
import org.openqa.selenium.TestNameDecorator;
import org.openqa.selenium.WebDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestSuiteBuilder {
    private File baseDir;
    private File jsTestDir;
    private Set<File> sourceDirs = new HashSet<File>();
    private Set<Ignore.Driver> ignored = new HashSet<Ignore.Driver>();
    private Class<? extends WebDriver> driverClass;
    private boolean keepDriver;
    private boolean includeJavascript;
    private boolean withDriver = true;
    private boolean withEnvironment = true;
    private List<String> onlyRun = new ArrayList<String>();
    private Set<String> patterns = new HashSet<String>();
    private Set<String> excludePatterns = new HashSet<String>();
    private Set<String> testMethodNames = new HashSet<String>();
    private Set<String> decorators = new LinkedHashSet<String>();
    private boolean includeJsApiTests = false;
    private boolean outputTestNames = false;

    public TestSuiteBuilder() {
        this.baseDir = new File(".").getAbsoluteFile();
        while (this.baseDir != null && !new File(this.baseDir, "Rakefile").exists()) {
            this.baseDir = this.baseDir.getParentFile();
        }
        MatcherAssert.assertThat((Object)this.baseDir, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.baseDir.exists(), (Matcher)Matchers.is((Object)true));
        this.jsTestDir = new File(this.baseDir, "common/test/js");
        MatcherAssert.assertThat((Object)this.jsTestDir.isDirectory(), (Matcher)Matchers.is((Object)true));
    }

    public TestSuiteBuilder addSourceDir(String dirName) {
        File dir = new File(this.baseDir, dirName + "/test/java");
        if (dir.exists()) {
            this.sourceDirs.add(dir);
        }
        return this;
    }

    public TestSuiteBuilder usingDriver(Class<? extends WebDriver> ss) {
        this.driverClass = ss;
        return this;
    }

    public TestSuiteBuilder usingDriver(String driverClassName) {
        try {
            Class<?> clazz = Class.forName(driverClassName);
            return this.usingDriver(clazz);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public TestSuiteBuilder exclude(Ignore.Driver tagToIgnore) {
        this.ignored.add(tagToIgnore);
        return this;
    }

    public TestSuiteBuilder keepDriverInstance() {
        this.keepDriver = true;
        return this;
    }

    public junit.framework.Test create() throws Exception {
        if (this.withDriver) {
            MatcherAssert.assertThat((String)"No driver class set", this.driverClass, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        }
        TestSuite suite = new TestSuite();
        for (File dir : this.sourceDirs) {
            this.addTestsRecursively(suite, dir);
        }
        if (this.includeJsApiTests && this.includeJavascript) {
            this.addJsApiTests(suite);
        }
        TestSuite toReturn = new TestSuite();
        if (this.withEnvironment) {
            toReturn.addTest((junit.framework.Test)new EnvironmentStarter((junit.framework.Test)suite));
        } else {
            toReturn.addTest((junit.framework.Test)suite);
        }
        if (suite.countTestCases() == 0) {
            System.err.println("No test cases found");
        }
        return this.decorate(toReturn);
    }

    private junit.framework.Test decorate(TestSuite toDecorate) throws Exception {
        TestSuite toReturn = toDecorate;
        for (String name : this.decorators) {
            TestSuite temp = new TestSuite();
            junit.framework.Test test = (junit.framework.Test)Class.forName(name).getConstructor(junit.framework.Test.class).newInstance(toReturn);
            temp.addTest(test);
            toReturn = temp;
        }
        return toReturn;
    }

    private void addTestsRecursively(TestSuite suite, File dir) {
        File[] files;
        for (File file : files = dir.listFiles()) {
            if (file.isDirectory()) {
                this.addTestsRecursively(suite, file);
                continue;
            }
            this.addTestsFromFile(suite, file);
        }
    }

    private void addTestsFromFile(TestSuite suite, File file) {
        Method[] methods;
        Class<?> rawClass = this.getClassFrom(file);
        if (rawClass == null || !TestCase.class.isAssignableFrom(rawClass) || JsApiTestCase.class.isAssignableFrom(rawClass)) {
            return;
        }
        Class<?> clazz = rawClass;
        int modifiers = clazz.getModifiers();
        if (Modifier.isAbstract(modifiers) || !Modifier.isPublic(modifiers)) {
            return;
        }
        if (this.onlyRun.size() > 0 && !this.onlyRun.contains(rawClass.getSimpleName())) {
            return;
        }
        if (this.isIgnored(clazz)) {
            System.err.println("Ignoring test class: " + clazz + ": " + clazz.getAnnotation(Ignore.class).reason());
            return;
        }
        boolean include = true;
        if (this.patterns.size() > 0) {
            include = false;
            for (String pattern : this.patterns) {
                include |= clazz.getName().matches(pattern);
            }
        }
        if (!include) {
            return;
        }
        for (String excludePattern : this.excludePatterns) {
            if (!clazz.getName().matches(excludePattern)) continue;
            return;
        }
        for (Method method : methods = clazz.getMethods()) {
            if (!this.isTestMethod(method)) continue;
            Object test = TestSuite.createTest(clazz, (String)method.getName());
            if (test instanceof NeedsDriver) {
                boolean freshDriver = false;
                if (method.isAnnotationPresent(NeedsFreshDriver.class)) {
                    freshDriver = true;
                }
                boolean restartDriver = false;
                if (method.isAnnotationPresent(NoDriverAfterTest.class)) {
                    restartDriver = true;
                }
                if (this.withDriver) {
                    test = new DriverTestDecorator((junit.framework.Test)test, this.driverClass, this.keepDriver, freshDriver, restartDriver);
                }
            }
            if (this.outputTestNames) {
                test = new TestNameDecorator((junit.framework.Test)test);
            }
            suite.addTest(test);
        }
    }

    private boolean isTestMethod(Method method) {
        if (!this.testMethodNames.isEmpty()) {
            return this.testMethodNames.contains(method.getName());
        }
        if (this.isIgnored(method)) {
            System.err.println("Ignoring: " + method.getDeclaringClass() + "." + method.getName() + ": " + method.getAnnotation(Ignore.class).reason());
            return false;
        }
        if (!this.includeJavascript && method.isAnnotationPresent(JavascriptEnabled.class)) {
            return false;
        }
        return method.getName().startsWith("test") || method.getAnnotation(Test.class) != null;
    }

    private boolean isIgnored(AnnotatedElement annotatedElement) {
        Ignore ignore = annotatedElement.getAnnotation(Ignore.class);
        if (ignore == null || ignore.value().length == 0) {
            return false;
        }
        for (Ignore.Driver value : ignore.value()) {
            for (Ignore.Driver name : this.ignored) {
                if (value != name && value != Ignore.Driver.ALL) continue;
                return true;
            }
        }
        return false;
    }

    private Class<?> getClassFrom(File file) {
        String path = file.getPath().replace('\\', '/');
        if (!path.endsWith(".java")) {
            return null;
        }
        int index = path.indexOf("/org/");
        if (index == -1) {
            return null;
        }
        path = path.substring(index + 1, path.length() - ".java".length());
        path = path.replace("/", ".");
        try {
            return Class.forName(path);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public TestSuiteBuilder includeJavascriptTests() {
        this.includeJavascript = true;
        return this;
    }

    public TestSuiteBuilder includeJsApiTests() {
        this.includeJsApiTests = true;
        return this.includeJavascriptTests();
    }

    public TestSuiteBuilder outputTestNames() {
        this.outputTestNames = true;
        return this;
    }

    public TestSuiteBuilder usingNoDriver() {
        this.withDriver = false;
        return this;
    }

    public TestSuiteBuilder withoutEnvironment() {
        this.withEnvironment = false;
        return this;
    }

    public TestSuiteBuilder onlyRun(String testCaseName) {
        this.onlyRun.add(testCaseName);
        return this;
    }

    public TestSuiteBuilder method(String testMethodName) {
        this.testMethodNames.add(testMethodName);
        return this;
    }

    public TestSuiteBuilder addSuiteDecorator(String decoratorClassName) {
        this.decorators.add(decoratorClassName);
        return this;
    }

    public TestSuiteBuilder leaveRunning() {
        System.setProperty("webdriver.singletestsuite.leaverunning", "true");
        return this;
    }

    private void addJsApiTests(TestSuite suite) {
        if (this.isIgnored((AnnotatedElement)((Object)JsApiTestCase.class))) {
            System.err.println("Ignoring JS API tests for " + this.driverClass.getName() + ": " + JsApiTestCase.class.getAnnotation(Ignore.class).reason());
            return;
        }
        if (!this.withDriver) {
            System.err.println("Skipping JS API tests: tests require a driver instance");
            return;
        }
        for (File file : this.jsTestDir.listFiles(new TestFilenameFilter())) {
            String path = file.getAbsolutePath().replace(this.jsTestDir.getAbsolutePath() + File.separator, "").replace(File.separator, "/");
            JsApiTestCase test = new JsApiTestCase("/js/test/" + path);
            suite.addTest((junit.framework.Test)new DriverTestDecorator((junit.framework.Test)test, this.driverClass, true, false, false));
        }
    }

    public TestSuiteBuilder pattern(String pattern) {
        this.patterns.add(pattern);
        return this;
    }

    public TestSuiteBuilder excludePattern(String pattern) {
        this.excludePatterns.add(pattern);
        return this;
    }

    public static class TestFilenameFilter
    implements FilenameFilter {
        public boolean accept(File dir, String name) {
            return name.endsWith("_test.html");
        }
    }
}

