/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestWaiter {
    private static final long DEFAULT_TIME_OUT = 5L;
    private static final TimeUnit DEFAULT_UNIT = TimeUnit.SECONDS;

    public static <X> X waitFor(Callable<X> until) {
        return TestWaiter.waitFor(until, 5L, DEFAULT_UNIT);
    }

    public static <X> X waitFor(Callable<X> until, long duration, TimeUnit in) {
        long end = System.currentTimeMillis() + in.toMillis(duration);
        X value = null;
        Exception lastException = null;
        while (System.currentTimeMillis() < end) {
            try {
                value = until.call();
                if (value instanceof Boolean ? (Boolean)value != false : value != null) {
                    return value;
                }
                TestWaiter.sleep(100L);
            }
            catch (Exception e) {
                lastException = e;
            }
        }
        if (lastException != null) {
            throw TestWaiter.propagate(lastException);
        }
        Assert.fail((String)("Condition timed out: " + until));
        return null;
    }

    private static RuntimeException propagate(Exception lastException) {
        if (lastException instanceof RuntimeException) {
            throw (RuntimeException)lastException;
        }
        throw new RuntimeException(lastException);
    }

    private static void sleep(long duration) {
        try {
            Thread.sleep(duration);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

