/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import org.openqa.selenium.AbstractDriverTestCase;
import org.openqa.selenium.By;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.Ignore;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.environment.GlobalTestEnvironment;

public class TextPagesTest
extends AbstractDriverTestCase {
    private String textPage;

    protected void setUp() throws Exception {
        super.setUp();
        this.textPage = GlobalTestEnvironment.get().getAppServer().whereIs("plain.txt");
    }

    @Ignore(value={Ignore.Driver.IE, Ignore.Driver.FIREFOX, Ignore.Driver.SELENESE, Ignore.Driver.CHROME, Ignore.Driver.IPHONE})
    public void testShouldBeAbleToLoadASimplePageOfText() {
        this.driver.get(this.textPage);
        String source = this.driver.getPageSource();
        TextPagesTest.assertEquals((String)"Test", (String)source);
    }

    @Ignore(value={Ignore.Driver.CHROME})
    public void testFindingAnElementOnAPlainTextPageWillNeverWork() {
        this.driver.get(this.textPage);
        try {
            this.driver.findElement(By.id((String)"foo"));
            TextPagesTest.fail((String)"This shouldn't work");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Ignore(value={Ignore.Driver.IE, Ignore.Driver.CHROME, Ignore.Driver.IPHONE, Ignore.Driver.SELENESE})
    public void testShouldThrowExceptionWhenAddingCookieToAPageThatIsNotHtml() {
        this.driver.get(this.textPage);
        Cookie cookie = new Cookie.Builder("hello", "goodbye").build();
        try {
            this.driver.manage().addCookie(cookie);
            TextPagesTest.fail((String)"Should throw exception when adding cookie to non existing domain");
        }
        catch (WebDriverException webDriverException) {
            // empty catch block
        }
    }
}

