/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.openqa.selenium.AbstractDriverTestCase;
import org.openqa.selenium.By;
import org.openqa.selenium.Ignore;
import org.openqa.selenium.JavascriptEnabled;
import org.openqa.selenium.WebElement;

@Ignore(value={Ignore.Driver.IPHONE, Ignore.Driver.ANDROID}, reason="File uploads not allowed on the iPhone")
public class UploadTest
extends AbstractDriverTestCase {
    private static final String LOREM_IPSUM_TEXT = "lorem ipsum dolor sit amet";
    private static final String FILE_HTML = "<div>lorem ipsum dolor sit amet</div>";
    private File testFile;

    protected void setUp() throws Exception {
        super.setUp();
        this.testFile = this.createTmpFile(FILE_HTML);
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.CHROME, Ignore.Driver.SELENESE}, reason="Chrome: File input elements are not supported yet")
    public void testFileUploading() throws Exception {
        this.driver.get(this.pages.uploadPage);
        this.driver.findElement(By.id((String)"upload")).sendKeys(new CharSequence[]{this.testFile.getAbsolutePath()});
        this.driver.findElement(By.id((String)"go")).submit();
        this.driver.switchTo().frame("upload_target");
        WebElement body = this.driver.findElement(By.xpath((String)"//body"));
        UploadTest.assertEquals((String)("Page source is: " + this.driver.getPageSource()), (String)LOREM_IPSUM_TEXT, (String)body.getText());
    }

    private File createTmpFile(String content) throws IOException {
        File f = File.createTempFile("webdriver", "tmp");
        f.deleteOnExit();
        FileOutputStream out = new FileOutputStream(f);
        PrintWriter pw = new PrintWriter(out);
        pw.write(content);
        pw.flush();
        pw.close();
        ((OutputStream)out).close();
        return f;
    }
}

