/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.util.concurrent.Callable;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WaitingConditions {
    private WaitingConditions() {
    }

    public static Callable<WebElement> elementToExist(final WebDriver driver, final String elementId) {
        return new Callable<WebElement>(){

            @Override
            public WebElement call() throws Exception {
                return driver.findElement(By.id((String)elementId));
            }

            public String toString() {
                return String.format("element with ID %s to exist", elementId);
            }
        };
    }

    public static Callable<String> elementTextToEqual(final WebElement element, final String value) {
        return new Callable<String>(){

            @Override
            public String call() throws Exception {
                String text = element.getText();
                if (value.equals(text)) {
                    return text;
                }
                return null;
            }

            public String toString() {
                return "element text did not equal: " + value;
            }
        };
    }

    public static Callable<String> elementTextToContain(final WebElement element, final String value) {
        return new Callable<String>(){

            @Override
            public String call() throws Exception {
                String text = element.getText();
                if (text.contains(value)) {
                    return text;
                }
                return null;
            }

            public String toString() {
                return "element text to contain: " + value;
            }
        };
    }

    public static Callable<String> elementValueToEqual(final WebElement element, final String expectedValue) {
        return new Callable<String>(){

            @Override
            public String call() throws Exception {
                String value = element.getValue();
                if (expectedValue.equals(value)) {
                    return value;
                }
                return null;
            }

            public String toString() {
                return "element value to equal: " + expectedValue;
            }
        };
    }

    public static Callable<String> pageTitleToBe(final WebDriver driver, final String expectedTitle) {
        return new Callable<String>(){

            @Override
            public String call() throws Exception {
                String title = driver.getTitle();
                if (expectedTitle.equals(title)) {
                    return title;
                }
                return null;
            }

            public String toString() {
                return "title to be: " + expectedTitle;
            }
        };
    }
}

