/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import junit.framework.TestCase;
import org.openqa.selenium.WebDriverException;

public class WebDriverExceptionTest
extends TestCase {
    public void testExtractsADriverName() {
        StackTraceElement[] stackTrace = new StackTraceElement[]{new StackTraceElement("SomeClass", "someMethod", "SomeClass.java", 5), new StackTraceElement("TestDriver", "someMethod", "TestDriver.java", 5)};
        String gotName = WebDriverException.getDriverName((StackTraceElement[])stackTrace);
        WebDriverExceptionTest.assertEquals((String)"TestDriver", (String)gotName);
    }

    public void testExtractsMostSpecificDriverName() {
        StackTraceElement[] stackTrace = new StackTraceElement[]{new StackTraceElement("SomeClass", "someMethod", "SomeClass.java", 5), new StackTraceElement("RemoteWebDriver", "someMethod", "RemoteWebDriver.java", 5), new StackTraceElement("FirefoxDriver", "someMethod", "FirefoxDriver.java", 5)};
        String gotName = WebDriverException.getDriverName((StackTraceElement[])stackTrace);
        WebDriverExceptionTest.assertEquals((String)"FirefoxDriver", (String)gotName);
    }

    public void testDefaultsToUnknownDriverName() {
        StackTraceElement[] stackTrace = new StackTraceElement[]{new StackTraceElement("SomeClass", "someMethod", "SomeClass.java", 5), new StackTraceElement("SomeOtherClass", "someMethod", "SomeOtherClass.java", 5)};
        String gotName = WebDriverException.getDriverName((StackTraceElement[])stackTrace);
        WebDriverExceptionTest.assertEquals((String)"unknown", (String)gotName);
    }
}

