/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.openqa.selenium.AbstractDriverTestCase;
import org.openqa.selenium.By;
import org.openqa.selenium.Ignore;
import org.openqa.selenium.JavascriptEnabled;
import org.openqa.selenium.NeedsFreshDriver;
import org.openqa.selenium.NoDriverAfterTest;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.TestWaiter;
import org.openqa.selenium.WaitingConditions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Ignore(value={Ignore.Driver.IPHONE}, reason="The iPhone only supports one window")
public class WindowSwitchingTest
extends AbstractDriverTestCase {
    @Ignore(value={Ignore.Driver.IE, Ignore.Driver.SELENESE})
    public void testShouldSwitchFocusToANewWindowWhenItIsOpenedAndNotStopFutureOperations() {
        this.driver.get(this.pages.xhtmlTestPage);
        String current = this.driver.getWindowHandle();
        this.driver.findElement(By.linkText((String)"Open new window")).click();
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)"XHTML Test Page"));
        this.driver.switchTo().window("result");
        MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)"We Arrive Here"));
        this.driver.get(this.pages.iframePage);
        String handle = this.driver.getWindowHandle();
        this.driver.findElement(By.id((String)"iframe_page_heading"));
        this.driver.switchTo().frame("iframe1");
        MatcherAssert.assertThat((Object)this.driver.getWindowHandle(), (Matcher)Matchers.equalTo((Object)handle));
        this.driver.switchTo().window(current);
    }

    @Ignore(value={Ignore.Driver.SELENESE})
    public void testShouldThrowNoSuchWindowException() {
        this.driver.get(this.pages.xhtmlTestPage);
        String current = this.driver.getWindowHandle();
        try {
            this.driver.switchTo().window("invalid name");
            WindowSwitchingTest.fail((String)"NoSuchWindowException expected");
        }
        catch (NoSuchWindowException noSuchWindowException) {
            // empty catch block
        }
        this.driver.switchTo().window(current);
    }

    @NeedsFreshDriver
    @NoDriverAfterTest
    @Ignore(value={Ignore.Driver.IE, Ignore.Driver.FIREFOX, Ignore.Driver.REMOTE, Ignore.Driver.SELENESE})
    public void testShouldBeAbleToIterateOverAllOpenWindows() throws Exception {
        this.driver.get(this.pages.xhtmlTestPage);
        this.driver.findElement(By.name((String)"windowOne")).click();
        this.driver.findElement(By.name((String)"windowTwo")).click();
        Set allWindowHandles = this.driver.getWindowHandles();
        HashSet<String> seenHandles = new HashSet<String>();
        for (String handle : allWindowHandles) {
            WindowSwitchingTest.assertFalse((boolean)seenHandles.contains(handle));
            this.driver.switchTo().window(handle);
            seenHandles.add(handle);
        }
        WindowSwitchingTest.assertEquals((int)3, (int)allWindowHandles.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore(value={Ignore.Driver.IE, Ignore.Driver.SELENESE})
    public void testClickingOnAButtonThatClosesAnOpenWindowDoesNotCauseTheBrowserToHang() {
        this.driver.get(this.pages.xhtmlTestPage);
        String currentHandle = this.driver.getWindowHandle();
        this.driver.findElement(By.name((String)"windowThree")).click();
        this.driver.switchTo().window("result");
        try {
            TestWaiter.waitFor(WaitingConditions.elementToExist(this.driver, "close"));
            this.driver.findElement(By.id((String)"close")).click();
        }
        finally {
            this.driver.switchTo().window(currentHandle);
            this.driver.findElement(By.id((String)"linkId"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore(value={Ignore.Driver.IE, Ignore.Driver.SELENESE})
    @JavascriptEnabled
    public void testCanCallGetWindowHandlesAfterClosingAWindow() {
        this.driver.get(this.pages.xhtmlTestPage);
        String currentHandle = this.driver.getWindowHandle();
        this.driver.findElement(By.name((String)"windowThree")).click();
        this.driver.switchTo().window("result");
        try {
            this.driver.findElement(By.id((String)"close")).click();
            Set<String> allHandles = TestWaiter.waitFor(this.windowHandleCountToBe(1));
            WindowSwitchingTest.assertEquals((int)1, (int)allHandles.size());
        }
        finally {
            this.driver.switchTo().window(currentHandle);
        }
    }

    @Ignore(value={Ignore.Driver.SELENESE})
    public void testCanObtainAWindowHandle() {
        this.driver.get(this.pages.xhtmlTestPage);
        String currentHandle = this.driver.getWindowHandle();
        WindowSwitchingTest.assertNotNull((Object)currentHandle);
    }

    @Ignore(value={Ignore.Driver.SELENESE})
    public void testFailingToSwitchToAWindowLeavesTheCurrentWindowAsIs() {
        this.driver.get(this.pages.xhtmlTestPage);
        String current = this.driver.getWindowHandle();
        try {
            this.driver.switchTo().window("i will never exist");
            WindowSwitchingTest.fail((String)"Should not be ablt to change to a non-existant window");
        }
        catch (NoSuchWindowException e) {
            // empty catch block
        }
        String newHandle = this.driver.getWindowHandle();
        WindowSwitchingTest.assertEquals((String)current, (String)newHandle);
    }

    @NeedsFreshDriver
    @NoDriverAfterTest
    @Ignore(value={Ignore.Driver.IE, Ignore.Driver.SELENESE, Ignore.Driver.CHROME_NON_WINDOWS}, reason="Chrome failing on OS X")
    public void testCanCloseWindowWhenMultipleWindowsAreOpen() {
        this.driver.get(this.pages.xhtmlTestPage);
        this.driver.findElement(By.name((String)"windowOne")).click();
        this.sleepBecauseWindowsTakeTimeToOpen();
        Set allWindowHandles = this.driver.getWindowHandles();
        WindowSwitchingTest.assertEquals((int)2, (int)allWindowHandles.size());
        String handle1 = (String)allWindowHandles.toArray()[1];
        this.driver.switchTo().window(handle1);
        this.driver.close();
        allWindowHandles = this.driver.getWindowHandles();
        WindowSwitchingTest.assertEquals((int)1, (int)allWindowHandles.size());
    }

    private void sleepBecauseWindowsTakeTimeToOpen() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            WindowSwitchingTest.fail((String)"Interrupted");
        }
    }

    @NeedsFreshDriver
    @NoDriverAfterTest
    @Ignore(value={Ignore.Driver.SELENESE, Ignore.Driver.CHROME})
    public void testClosingOnlyWindowShouldNotCauseTheBrowserToHang() {
        this.driver.get(this.pages.xhtmlTestPage);
        this.driver.close();
    }

    private Callable<Set<String>> windowHandleCountToBe(final int count) {
        return new Callable<Set<String>>(){

            @Override
            public Set<String> call() throws Exception {
                Set handles = WindowSwitchingTest.this.driver.getWindowHandles();
                if (handles.size() == count) {
                    return handles;
                }
                return null;
            }
        };
    }
}

