/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.browserlaunchers;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.openqa.selenium.browserlaunchers.WindowsProxyManager;
import org.openqa.selenium.internal.FileHandler;
import org.openqa.selenium.internal.TemporaryFilesystem;

public class WindowsProxyManagerUnitTest
extends TestCase {
    public void testDeleteFlatDirContentsWithNoSuffix() throws IOException {
        File srcDir = this.makeSourceDirAndCookie("testcookie");
        WindowsProxyManager.deleteFlatDirContents((File)srcDir, null);
        WindowsProxyManagerUnitTest.assertTrue((boolean)srcDir.exists());
        File[] files = srcDir.listFiles();
        WindowsProxyManagerUnitTest.assertEquals((int)0, (int)files.length);
        FileHandler.delete((File)srcDir);
        WindowsProxyManagerUnitTest.assertFalse((boolean)srcDir.exists());
    }

    public void testDeleteFlatDirContentsWithSuffix() throws IOException {
        File srcDir = this.makeSourceDirAndCookie("testcookie");
        WindowsProxyManager.deleteFlatDirContents((File)srcDir, (String)"nomatch");
        WindowsProxyManagerUnitTest.assertTrue((boolean)srcDir.exists());
        File[] files = srcDir.listFiles();
        WindowsProxyManagerUnitTest.assertEquals((int)1, (int)files.length);
        FileHandler.delete((File)srcDir);
        WindowsProxyManagerUnitTest.assertFalse((boolean)srcDir.exists());
    }

    public void testDeleteFlatDirContentsWithNoSuchDir() {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        File srcDir = new File(tempDir, "rc-wpmt-src");
        WindowsProxyManagerUnitTest.assertFalse((boolean)srcDir.exists());
        WindowsProxyManager.deleteFlatDirContents((File)srcDir, null);
        WindowsProxyManagerUnitTest.assertFalse((boolean)srcDir.exists());
    }

    public void testHidePreexistingCookiesNoDestDirNoSuffix() throws IOException {
        File srcDir = this.makeSourceDirAndCookie("testcookie");
        File destDir = this.getNonexistentDir();
        WindowsProxyManager.hideCookies((File)srcDir, null, (File)destDir);
        WindowsProxyManagerUnitTest.assertTrue((boolean)srcDir.exists());
        WindowsProxyManagerUnitTest.assertTrue((boolean)destDir.exists());
        WindowsProxyManagerUnitTest.assertEquals((int)1, (int)destDir.listFiles().length);
        WindowsProxyManagerUnitTest.assertEquals((int)0, (int)srcDir.listFiles().length);
        FileHandler.delete((File)srcDir);
        WindowsProxyManagerUnitTest.assertFalse((boolean)srcDir.exists());
        FileHandler.delete((File)destDir);
        WindowsProxyManagerUnitTest.assertFalse((boolean)destDir.exists());
    }

    public void testHidePreexistingCookiesWithDestDirNoSuffix() throws IOException {
        File srcDir = this.makeSourceDirAndCookie("testcookie");
        File destDir = this.getNonexistentDir();
        WindowsProxyManagerUnitTest.assertTrue((boolean)destDir.mkdirs());
        File lostCookieFile = File.createTempFile("lostcookie", ".txt", destDir);
        lostCookieFile.deleteOnExit();
        WindowsProxyManagerUnitTest.assertTrue((boolean)lostCookieFile.exists());
        WindowsProxyManager.hideCookies((File)srcDir, null, (File)destDir);
        WindowsProxyManagerUnitTest.assertTrue((boolean)srcDir.exists());
        WindowsProxyManagerUnitTest.assertTrue((boolean)destDir.exists());
        WindowsProxyManagerUnitTest.assertEquals((int)1, (int)destDir.listFiles().length);
        WindowsProxyManagerUnitTest.assertEquals((int)0, (int)srcDir.listFiles().length);
        FileHandler.delete((File)srcDir);
        WindowsProxyManagerUnitTest.assertFalse((boolean)srcDir.exists());
        FileHandler.delete((File)destDir);
        WindowsProxyManagerUnitTest.assertFalse((boolean)destDir.exists());
    }

    public void testRestorePreexistingCookiesNoSuffix() throws IOException {
        File hiddenDir = this.makeSourceDirAndCookie("hiddencookie");
        File cookieDir = this.getNonexistentDir();
        WindowsProxyManager.restoreCookies((File)cookieDir, null, (File)hiddenDir);
        WindowsProxyManagerUnitTest.assertFalse((boolean)hiddenDir.exists());
        WindowsProxyManagerUnitTest.assertTrue((boolean)cookieDir.exists());
        WindowsProxyManagerUnitTest.assertEquals((int)1, (int)cookieDir.listFiles().length);
        FileHandler.delete((File)cookieDir);
        WindowsProxyManagerUnitTest.assertFalse((boolean)cookieDir.exists());
        FileHandler.delete((File)hiddenDir);
        WindowsProxyManagerUnitTest.assertFalse((boolean)hiddenDir.exists());
    }

    public void testHidePreexistingCookiesNoDestDirWithSuffix() throws IOException {
        File srcDir = this.makeSourceDirAndCookie("testcookie");
        File destDir = this.getNonexistentDir();
        WindowsProxyManager.hideCookies((File)srcDir, (String)".txt", (File)destDir);
        WindowsProxyManagerUnitTest.assertTrue((boolean)srcDir.exists());
        WindowsProxyManagerUnitTest.assertTrue((boolean)destDir.exists());
        WindowsProxyManagerUnitTest.assertEquals((int)1, (int)destDir.listFiles().length);
        FileHandler.delete((File)srcDir);
        WindowsProxyManagerUnitTest.assertFalse((boolean)srcDir.exists());
        FileHandler.delete((File)destDir);
        WindowsProxyManagerUnitTest.assertFalse((boolean)destDir.exists());
    }

    private File makeSourceDirAndCookie(String cookiePrefix) throws IOException {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        File srcDir = new File(tempDir, "rc-wpmt-src");
        srcDir.deleteOnExit();
        srcDir.mkdir();
        WindowsProxyManagerUnitTest.assertTrue((boolean)srcDir.exists());
        File cookieFile = File.createTempFile(cookiePrefix, ".txt", srcDir);
        cookieFile.deleteOnExit();
        WindowsProxyManagerUnitTest.assertTrue((boolean)cookieFile.exists());
        return srcDir;
    }

    private File getNonexistentDir() {
        File destDir = TemporaryFilesystem.createTempDir((String)"rc-wpmt-dest", (String)"tmp");
        destDir.delete();
        WindowsProxyManagerUnitTest.assertFalse((boolean)destDir.exists());
        return destDir;
    }
}

