/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.environment.webserver;

import java.io.File;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.ssl.SslSocketConnector;
import org.eclipse.jetty.servlets.MultiPartFilter;
import org.eclipse.jetty.webapp.WebAppContext;
import org.openqa.selenium.environment.webserver.AppServer;
import org.openqa.selenium.environment.webserver.EncodingServlet;
import org.openqa.selenium.environment.webserver.ManifestServlet;
import org.openqa.selenium.environment.webserver.NullLogger;
import org.openqa.selenium.environment.webserver.PageServlet;
import org.openqa.selenium.environment.webserver.RedirectServlet;
import org.openqa.selenium.environment.webserver.SleepingServlet;
import org.openqa.selenium.environment.webserver.UploadServlet;
import org.openqa.selenium.internal.InProject;
import org.openqa.selenium.internal.PortProber;
import org.openqa.selenium.networkutils.NetworkUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jetty7AppServer
implements AppServer {
    private static final String DEFAULT_CONTEXT_PATH = "/common";
    private static final String JS_SRC_CONTEXT_PATH = "/js/src";
    private static final String JS_TEST_CONTEXT_PATH = "/js/test";
    private static final String THIRD_PARTY_JS_CONTEXT_PATH = "/third_party/closure/goog";
    private static final NetworkUtils networkUtils = new NetworkUtils();
    private int port;
    private int securePort;
    private File path;
    private File jsSrcRoot;
    private File jsTestRoot;
    private File thirdPartyJsRoot;
    private final Server server;
    private WebAppContext context;
    private ContextHandlerCollection handlers;
    private final String hostName;

    public Jetty7AppServer() {
        this("localhost");
    }

    public Jetty7AppServer(String hostName) {
        this.hostName = hostName;
        if (!Boolean.getBoolean("webdriver.debug")) {
            new NullLogger().disableLogging();
        }
        this.server = new Server();
        this.path = this.findRootOfWebApp();
        this.jsSrcRoot = Jetty7AppServer.findJsSrcWebAppRoot();
        this.jsTestRoot = Jetty7AppServer.findJsTestWebAppRoot();
        this.thirdPartyJsRoot = Jetty7AppServer.findThirdPartyJsWebAppRoot();
        this.handlers = new ContextHandlerCollection();
        this.context = this.addWebApplication(DEFAULT_CONTEXT_PATH, this.path);
        this.addWebApplication(JS_SRC_CONTEXT_PATH, this.jsSrcRoot);
        this.addWebApplication(JS_TEST_CONTEXT_PATH, this.jsTestRoot);
        this.addWebApplication(THIRD_PARTY_JS_CONTEXT_PATH, this.thirdPartyJsRoot);
        this.server.setHandler((Handler)this.handlers);
        this.addServlet("Redirecter", "/redirect", RedirectServlet.class);
        this.addServlet("InfinitePagerServer", "/page/*", PageServlet.class);
        this.addServlet("Manifest", "/manifest/*", ManifestServlet.class);
        this.addServlet("Uploader", "/upload", UploadServlet.class);
        this.addServlet("Unusual encoding", "/encoding", EncodingServlet.class);
        this.addServlet("Sleeper", "/sleep", SleepingServlet.class);
        this.addFilter(MultiPartFilter.class, "/upload", 0);
        this.listenOn(PortProber.findFreePort());
        this.listenSecurelyOn(PortProber.findFreePort());
    }

    public File getJsTestRoot() {
        return this.jsTestRoot;
    }

    protected File findRootOfWebApp() {
        return InProject.locate("common/src/web");
    }

    private static File findJsSrcWebAppRoot() {
        return InProject.locate("common/src/js");
    }

    private static File findJsTestWebAppRoot() {
        return InProject.locate("common/test/js");
    }

    private static File findThirdPartyJsWebAppRoot() {
        return InProject.locate("third_party/closure/goog");
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public String getAlternateHostName() {
        return networkUtils.getPrivateLocalAddress();
    }

    @Override
    public String whereIs(String relativeUrl) {
        if (!relativeUrl.startsWith("/")) {
            relativeUrl = "/common/" + relativeUrl;
        }
        return "http://" + this.getHostName() + ":" + this.port + relativeUrl;
    }

    @Override
    public String whereElseIs(String relativeUrl) {
        if (!relativeUrl.startsWith("/")) {
            relativeUrl = "/common/" + relativeUrl;
        }
        return "http://" + this.getAlternateHostName() + ":" + this.port + relativeUrl;
    }

    @Override
    public String whereIsSecure(String relativeUrl) {
        if (!relativeUrl.startsWith("/")) {
            relativeUrl = "/common/" + relativeUrl;
        }
        return "https://" + this.getHostName() + ":" + this.securePort + relativeUrl;
    }

    @Override
    public void start() {
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setPort(this.port);
        this.server.addConnector((Connector)connector);
        File keyStore = this.getKeyStore();
        if (!keyStore.exists()) {
            throw new RuntimeException("Cannot find keystore for SSL cert: " + keyStore.getAbsolutePath());
        }
        SslSocketConnector secureSocket = new SslSocketConnector();
        secureSocket.setPort(this.securePort);
        secureSocket.setKeystore(keyStore.getAbsolutePath());
        secureSocket.setPassword("password");
        secureSocket.setKeyPassword("password");
        secureSocket.setTruststore(keyStore.getAbsolutePath());
        secureSocket.setTrustPassword("password");
        this.server.addConnector((Connector)secureSocket);
        try {
            this.server.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected File getKeyStore() {
        return new File(this.findRootOfWebApp(), "../../test/java/keystore");
    }

    @Override
    public void listenOn(int port) {
        this.port = port;
    }

    @Override
    public void listenSecurelyOn(int port) {
        this.securePort = port;
    }

    protected void addListener(Connector listener) {
        this.server.addConnector(listener);
    }

    @Override
    public void stop() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addServlet(String name, String url, Class<? extends Servlet> servletClass) {
        try {
            this.context.addServlet(servletClass, url);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void addFilter(Class<? extends Filter> filter, String path, int dispatches) {
        this.context.addFilter(filter, path, dispatches);
    }

    private WebAppContext addWebApplication(String contextPath, File rootDir) {
        return this.addWebApplication(contextPath, rootDir.getAbsolutePath());
    }

    private WebAppContext addWebApplication(String contextPath, String absolutePath) {
        WebAppContext app = new WebAppContext();
        app.setContextPath(contextPath);
        app.setWar(absolutePath);
        this.handlers.addHandler((Handler)app);
        return app;
    }

    @Override
    public void addAdditionalWebApplication(String context, String absolutePath) {
        this.addWebApplication(context, absolutePath);
    }

    public static void main(String[] args) {
        Jetty7AppServer server = new Jetty7AppServer("localhost");
        server.port = 2310;
        server.start();
    }
}

