/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.html5;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.AbstractDriverTestCase;
import org.openqa.selenium.html5.AppCacheEntry;
import org.openqa.selenium.html5.AppCacheStatus;
import org.openqa.selenium.html5.AppCacheType;
import org.openqa.selenium.html5.ApplicationCache;
import org.openqa.selenium.html5.BrowserConnection;
import org.openqa.selenium.html5.DatabaseStorage;
import org.openqa.selenium.html5.LocalStorage;
import org.openqa.selenium.html5.Location;
import org.openqa.selenium.html5.LocationContext;
import org.openqa.selenium.html5.ResultSet;
import org.openqa.selenium.html5.SessionStorage;
import org.openqa.selenium.html5.WebStorage;

public class HTML5Test
extends AbstractDriverTestCase {
    private static final String INSERT_STATEMENT = "INSERT INTO docs(docname) VALUES (?)";
    private static final String SELECT_STATEMENT = "SELECT * FROM docs";
    private static final String DELETE_STATEMENT = "DELETE FROM docs";

    public void testShouldSetBrowserOffline() {
        if (!(this.driver instanceof BrowserConnection)) {
            return;
        }
        this.driver.get(this.pages.html5Page);
        HTML5Test.assertTrue((String)"Browser is offline.", (boolean)((BrowserConnection)this.driver).isOnline());
        ((BrowserConnection)this.driver).setOnline(false);
        HTML5Test.assertFalse((String)"Failed to set browser offline.", (boolean)((BrowserConnection)this.driver).isOnline());
        ((BrowserConnection)this.driver).setOnline(true);
        HTML5Test.assertTrue((String)"Failed to set browser online.", (boolean)((BrowserConnection)this.driver).isOnline());
    }

    public void testShouldSetAndGetLocation() {
        if (!(this.driver instanceof LocationContext)) {
            return;
        }
        this.driver.get(this.pages.html5Page);
        ((LocationContext)this.driver).setLocation(new Location(40.714353, -74.005973, 0.056747));
        this.driver.manage().timeouts().implicitlyWait(2000L, TimeUnit.MILLISECONDS);
        Location location = ((LocationContext)this.driver).location();
        HTML5Test.assertEquals((double)40.714353, (double)location.getLatitude(), (double)4.0);
        HTML5Test.assertEquals((double)-74.005973, (double)location.getLongitude(), (double)4.0);
        HTML5Test.assertEquals((double)1.056747, (double)location.getAltitude(), (double)4.0);
    }

    public void testLocalStorageSetAndGetItem() {
        if (!(this.driver instanceof WebStorage)) {
            return;
        }
        this.driver.get(this.pages.html5Page);
        LocalStorage local = ((WebStorage)this.driver).getLocalStorage();
        local.clear();
        HTML5Test.assertEquals((String)"Local Storage isn't empty.", (int)0, (int)local.size());
        local.setItem("FOO", "BAR");
        HTML5Test.assertEquals((String)"BAR", (String)local.getItem("FOO"));
        local.setItem("FOO1", "BAR1");
        HTML5Test.assertEquals((String)"BAR1", (String)local.getItem("FOO1"));
        HTML5Test.assertEquals((int)2, (int)local.size());
        local.clear();
        HTML5Test.assertEquals((int)0, (int)local.size());
    }

    public void testLocalStorageKeySet() {
        if (!(this.driver instanceof WebStorage)) {
            return;
        }
        this.driver.get(this.pages.html5Page);
        LocalStorage local = ((WebStorage)this.driver).getLocalStorage();
        local.clear();
        local.setItem("FOO1", "BAR1");
        local.setItem("FOO2", "BAR2");
        local.setItem("FOO3", "BAR3");
        Set keySet = local.keySet();
        HTML5Test.assertTrue((keySet.size() == 3 ? 1 : 0) != 0);
        HTML5Test.assertTrue((boolean)keySet.contains("FOO1"));
        HTML5Test.assertTrue((boolean)keySet.contains("FOO2"));
        HTML5Test.assertTrue((boolean)keySet.contains("FOO3"));
        local.clear();
        HTML5Test.assertTrue((boolean)local.keySet().isEmpty());
    }

    public void testClearLocalStorage() {
        if (!(this.driver instanceof WebStorage)) {
            return;
        }
        LocalStorage local = ((WebStorage)this.driver).getLocalStorage();
        local.setItem("FOO1", "BAR1");
        local.setItem("FOO2", "BAR2");
        local.setItem("FOO3", "BAR3");
        HTML5Test.assertEquals((int)3, (int)local.size());
        local.clear();
        HTML5Test.assertEquals((int)0, (int)local.size());
    }

    public void testLocalStorageRemoveItem() {
        if (!(this.driver instanceof WebStorage)) {
            return;
        }
        this.driver.get(this.pages.html5Page);
        LocalStorage local = ((WebStorage)this.driver).getLocalStorage();
        local.clear();
        local.setItem("FOO", "BAR");
        HTML5Test.assertEquals((int)1, (int)local.size());
        String removedItemValue = local.removeItem("FOO");
        HTML5Test.assertEquals((String)"BAR", (String)removedItemValue);
        HTML5Test.assertEquals((int)0, (int)local.size());
        local.clear();
    }

    public void testSessionStorageSetAndGetItem() {
        if (!(this.driver instanceof WebStorage)) {
            return;
        }
        this.driver.get(this.pages.html5Page);
        SessionStorage session = ((WebStorage)this.driver).getSessionStorage();
        HTML5Test.assertEquals((String)"Session Storage isn't empty.", (int)0, (int)session.size());
        session.setItem("BAR", "FOO");
        HTML5Test.assertEquals((String)"FOO", (String)session.getItem("BAR"));
        session.setItem("BAR1", "FOO1");
        HTML5Test.assertEquals((String)"FOO1", (String)session.getItem("BAR1"));
        HTML5Test.assertEquals((int)2, (int)session.size());
        session.clear();
        HTML5Test.assertEquals((int)0, (int)session.size());
    }

    public void testSessionStorageKeySet() {
        if (!(this.driver instanceof WebStorage)) {
            return;
        }
        this.driver.get(this.pages.html5Page);
        SessionStorage session = ((WebStorage)this.driver).getSessionStorage();
        session.clear();
        session.setItem("FOO1", "BAR1");
        session.setItem("FOO2", "BAR2");
        session.setItem("FOO3", "BAR3");
        Set keySet = session.keySet();
        HTML5Test.assertTrue((keySet.size() == 3 ? 1 : 0) != 0);
        HTML5Test.assertTrue((boolean)keySet.contains("FOO1"));
        HTML5Test.assertTrue((boolean)keySet.contains("FOO2"));
        HTML5Test.assertTrue((boolean)keySet.contains("FOO3"));
        session.clear();
        HTML5Test.assertTrue((boolean)session.keySet().isEmpty());
    }

    public void testClearSessionStorage() {
        if (!(this.driver instanceof WebStorage)) {
            return;
        }
        SessionStorage session = ((WebStorage)this.driver).getSessionStorage();
        session.setItem("FOO1", "BAR1");
        session.setItem("FOO2", "BAR2");
        session.setItem("FOO3", "BAR3");
        HTML5Test.assertEquals((int)3, (int)session.size());
        session.clear();
        HTML5Test.assertEquals((int)0, (int)session.size());
    }

    public void testSessionStorageRemoveItem() {
        if (!(this.driver instanceof WebStorage)) {
            return;
        }
        this.driver.get(this.pages.html5Page);
        SessionStorage session = ((WebStorage)this.driver).getSessionStorage();
        session.clear();
        session.setItem("BAR", "FOO");
        HTML5Test.assertEquals((int)1, (int)session.size());
        String removedItemValue = session.removeItem("BAR");
        HTML5Test.assertEquals((String)"FOO", (String)removedItemValue);
        HTML5Test.assertEquals((int)0, (int)session.size());
        session.clear();
    }

    public void testAppCacheStatus() {
        if (!(this.driver instanceof ApplicationCache)) {
            return;
        }
        this.driver.get(this.pages.html5Page);
        this.driver.manage().timeouts().implicitlyWait(2000L, TimeUnit.MILLISECONDS);
        AppCacheStatus status = ((ApplicationCache)this.driver).getStatus();
        HTML5Test.assertEquals((Object)AppCacheStatus.UNCACHED, (Object)status);
        ((BrowserConnection)this.driver).setOnline(false);
        this.driver.get(this.pages.html5Page);
        AppCacheStatus status1 = ((ApplicationCache)this.driver).getStatus();
        status1 = ((ApplicationCache)this.driver).getStatus();
        HTML5Test.assertEquals((String)"Resources should be retrieved from browser's cache.", (Object)AppCacheStatus.IDLE, (Object)status1);
    }

    public void testBrowserLoadsFromCacheWhenOffline() {
        if (!(this.driver instanceof ApplicationCache)) {
            return;
        }
        this.driver.get(this.pages.html5Page);
        this.driver.get(this.pages.formPage);
        ((BrowserConnection)this.driver).setOnline(false);
        this.driver.get(this.pages.html5Page);
        HTML5Test.assertEquals((String)"HTML5", (String)this.driver.getTitle());
    }

    public void testGetAppCache() {
        if (!(this.driver instanceof ApplicationCache)) {
            return;
        }
        this.driver.get(this.pages.html5Page);
        ((BrowserConnection)this.driver).setOnline(false);
        List caches = ((ApplicationCache)this.driver).getAppCache();
        for (AppCacheEntry cache : caches) {
            HTML5Test.assertEquals((String)"image/jpeg", (String)cache.getMimeType());
            if (cache.getUrl().contains("red.jpg")) {
                HTML5Test.assertEquals((String)"Resources that were listed in cache's manifest isn't MASTER.", (Object)AppCacheType.MASTER, (Object)cache.getType().value());
                continue;
            }
            if (!cache.getUrl().contains("yellow.jpg")) continue;
            HTML5Test.assertEquals((String)"Resources that were listed in cache's manifest isn't EXPLICIT", (Object)AppCacheType.EXPLICIT, (Object)cache.getType().value());
        }
    }

    private ResultSet executeQuery(String statement, String ... param) {
        String databaseName = "'HTML5', '1.0', 'Offline document storage', 100*1024";
        return ((DatabaseStorage)this.driver).executeSQL(databaseName, statement, (Object[])param);
    }

    public void testResultSetsReturnNegativeLastInsertedRowId() {
        if (!(this.driver instanceof DatabaseStorage)) {
            return;
        }
        this.driver.get(this.pages.html5Page);
        ResultSet resultSet = this.executeQuery(SELECT_STATEMENT, new String[0]);
        HTML5Test.assertTrue((resultSet.getLastInsertedRowId() == -1 ? 1 : 0) != 0);
    }

    public void testResultSetsReturnPositiveLastInsertedRowId() {
        if (!(this.driver instanceof DatabaseStorage)) {
            return;
        }
        this.driver.get(this.pages.html5Page);
        ResultSet resultSet = this.executeQuery(INSERT_STATEMENT, "DocFoo");
        HTML5Test.assertTrue((resultSet.getLastInsertedRowId() != -1 ? 1 : 0) != 0);
        ResultSet resultSet1 = this.executeQuery(SELECT_STATEMENT, new String[0]);
        HTML5Test.assertTrue((resultSet1.getLastInsertedRowId() == -1 ? 1 : 0) != 0);
        ResultSet resultSet2 = this.executeQuery(DELETE_STATEMENT, new String[0]);
        HTML5Test.assertTrue((resultSet2.getLastInsertedRowId() == -1 ? 1 : 0) != 0);
    }

    public void testResultSetsNumberOfRowsAffected() {
        if (!(this.driver instanceof DatabaseStorage)) {
            return;
        }
        this.driver.get(this.pages.html5Page);
        ResultSet resultSet = this.executeQuery(INSERT_STATEMENT, "DocFooBar");
        HTML5Test.assertTrue((resultSet.getNumberOfRowsAffected() == 1 ? 1 : 0) != 0);
        ResultSet resultSet1 = this.executeQuery(SELECT_STATEMENT, new String[0]);
        HTML5Test.assertTrue((resultSet1.getNumberOfRowsAffected() == 0 ? 1 : 0) != 0);
        ResultSet resultSet2 = this.executeQuery("UPDATE docs SET docname='DocBar' WHERE docname='DocFooBar'", new String[0]);
        HTML5Test.assertTrue((resultSet2.getNumberOfRowsAffected() == 1 ? 1 : 0) != 0);
        this.executeQuery(DELETE_STATEMENT, new String[0]);
    }

    public void testResultSetRowsContainsInsertedRows() {
        if (!(this.driver instanceof DatabaseStorage)) {
            return;
        }
        this.driver.get(this.pages.html5Page);
        this.executeQuery(INSERT_STATEMENT, "DocFoo");
        this.executeQuery(INSERT_STATEMENT, "DocFooBar");
        ResultSet resultSet = this.executeQuery(SELECT_STATEMENT, new String[0]);
        HTML5Test.assertTrue((resultSet.rows().size() == 2 ? 1 : 0) != 0);
        Map record = resultSet.rows().item(0);
        HTML5Test.assertEquals((Object)"DocFoo", record.get("docname"));
        record = resultSet.rows().item(1);
        HTML5Test.assertEquals((Object)"DocFooBar", record.get("docname"));
        this.executeQuery(DELETE_STATEMENT, new String[0]);
        resultSet = this.executeQuery(SELECT_STATEMENT, new String[0]);
        HTML5Test.assertTrue((resultSet.rows().size() == 0 ? 1 : 0) != 0);
    }
}

