/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.interactions;

import org.jmock.Expectations;
import org.jmock.integration.junit3.MockObjectTestCase;
import org.jmock.internal.ExpectationBuilder;
import org.openqa.selenium.Keyboard;
import org.openqa.selenium.Keys;
import org.openqa.selenium.Mouse;
import org.openqa.selenium.StubTargetLocator;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.ActionChainsGenerator;
import org.openqa.selenium.interactions.CompositeAction;
import org.openqa.selenium.interactions.StubInputDeviceDriver;

public class TestActionChainsGenerator
extends MockObjectTestCase {
    private WebElement dummyElement;
    private Mouse dummyMouse;
    private Keyboard dummyKeyboard;
    private WebDriver driver;

    public void setUp() {
        this.dummyMouse = (Mouse)this.mock(Mouse.class);
        this.dummyKeyboard = (Keyboard)this.mock(Keyboard.class);
        this.dummyElement = (WebElement)this.mock(WebElement.class);
        this.driver = new StubInputDeviceDriver(){

            public WebDriver.TargetLocator switchTo() {
                return new StubTargetLocator(){

                    public WebElement activeElement() {
                        return TestActionChainsGenerator.this.dummyElement;
                    }
                };
            }

            public Keyboard getKeyboard() {
                return TestActionChainsGenerator.this.dummyKeyboard;
            }

            public Mouse getMouse() {
                return TestActionChainsGenerator.this.dummyMouse;
            }
        };
    }

    public void testCreatingAllKeyboardActions() {
        this.checking((ExpectationBuilder)new Expectations(){
            {
                ((Keyboard)this.one(TestActionChainsGenerator.this.dummyKeyboard)).pressKey(Keys.SHIFT);
                ((Keyboard)this.one(TestActionChainsGenerator.this.dummyKeyboard)).sendKeys(new CharSequence[]{"abc"});
                ((Keyboard)this.one(TestActionChainsGenerator.this.dummyKeyboard)).releaseKey(Keys.CONTROL);
            }
        });
        ActionChainsGenerator builder = new ActionChainsGenerator(this.driver);
        builder.keyDown(Keys.SHIFT).sendKeys(new CharSequence[]{"abc"}).keyUp(Keys.CONTROL);
        CompositeAction returnedAction = (CompositeAction)builder.build();
        returnedAction.perform();
        TestActionChainsGenerator.assertEquals((String)"Expected 3 keyboard actions", (int)3, (int)returnedAction.getNumberOfActions());
    }

    public void testSupplyingAnElement() {
        this.checking((ExpectationBuilder)new Expectations(){
            {
                ((Keyboard)this.one(TestActionChainsGenerator.this.dummyKeyboard)).pressKey(Keys.SHIFT);
            }
        });
        ActionChainsGenerator builder = new ActionChainsGenerator(this.driver).onElement(this.dummyElement);
        builder.keyDown(Keys.SHIFT);
        CompositeAction returnedAction = (CompositeAction)builder.build();
        returnedAction.perform();
        TestActionChainsGenerator.assertEquals((String)"Expected 1 keyboard action", (int)1, (int)returnedAction.getNumberOfActions());
    }

    public void testSupplyingIndividualElementsToKeyboardActions() {
        WebElement dummyElement2 = (WebElement)this.mock(WebElement.class, "dummy2");
        WebElement dummyElement3 = (WebElement)this.mock(WebElement.class, "dummy3");
        this.checking((ExpectationBuilder)new Expectations(){
            {
                ((Keyboard)this.one(TestActionChainsGenerator.this.dummyKeyboard)).pressKey(Keys.SHIFT);
                ((Keyboard)this.one(TestActionChainsGenerator.this.dummyKeyboard)).sendKeys(new CharSequence[]{"abc"});
                ((Keyboard)this.one(TestActionChainsGenerator.this.dummyKeyboard)).releaseKey(Keys.CONTROL);
            }
        });
        ActionChainsGenerator builder = new ActionChainsGenerator(this.driver);
        builder.keyDown(this.dummyElement, Keys.SHIFT).sendKeys(dummyElement2, new CharSequence[]{"abc"}).keyUp(dummyElement3, Keys.CONTROL);
        CompositeAction returnedAction = (CompositeAction)builder.build();
        returnedAction.perform();
        TestActionChainsGenerator.assertEquals((String)"Expected 3 keyboard actions", (int)3, (int)returnedAction.getNumberOfActions());
    }

    public void testCreatingAllMouseActions() {
        this.checking((ExpectationBuilder)new Expectations(){
            {
                ((Mouse)this.one(TestActionChainsGenerator.this.dummyMouse)).mouseDown(TestActionChainsGenerator.this.dummyElement);
                ((Mouse)this.one(TestActionChainsGenerator.this.dummyMouse)).mouseUp(TestActionChainsGenerator.this.dummyElement);
                ((Mouse)this.one(TestActionChainsGenerator.this.dummyMouse)).click(TestActionChainsGenerator.this.dummyElement);
                ((Mouse)this.one(TestActionChainsGenerator.this.dummyMouse)).doubleClick(TestActionChainsGenerator.this.dummyElement);
                ((Mouse)this.one(TestActionChainsGenerator.this.dummyMouse)).mouseMove(TestActionChainsGenerator.this.dummyElement);
                ((Mouse)this.one(TestActionChainsGenerator.this.dummyMouse)).contextClick(TestActionChainsGenerator.this.dummyElement);
            }
        });
        ActionChainsGenerator builder = new ActionChainsGenerator(this.driver);
        builder.clickAndHold(this.dummyElement).release(this.dummyElement).click(this.dummyElement).doubleClick(this.dummyElement).moveToElement(this.dummyElement).contextClick(this.dummyElement);
        CompositeAction returnedAction = (CompositeAction)builder.build();
        returnedAction.perform();
        TestActionChainsGenerator.assertEquals((String)"Expected 6 mouse actions.", (int)6, (int)returnedAction.getNumberOfActions());
    }
}

