/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.interactions;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.openqa.selenium.AbstractDriverTestCase;
import org.openqa.selenium.By;
import org.openqa.selenium.Ignore;
import org.openqa.selenium.JavascriptEnabled;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.KeyDownAction;
import org.openqa.selenium.interactions.KeyUpAction;
import org.openqa.selenium.interactions.SendKeysAction;

@Ignore(value={Ignore.Driver.IE})
public class TestBasicKeyboardInterface
extends AbstractDriverTestCase {
    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.ANDROID, Ignore.Driver.FIREFOX, Ignore.Driver.REMOTE, Ignore.Driver.IPHONE, Ignore.Driver.CHROME, Ignore.Driver.SELENESE})
    public void testBasicKeyboardInput() {
        this.driver.get(this.pages.javascriptPage);
        WebElement keyReporter = this.driver.findElement(By.id((String)"keyReporter"));
        SendKeysAction sendLowercase = new SendKeysAction(this.driver, keyReporter, new CharSequence[]{"abc def"});
        sendLowercase.perform();
        MatcherAssert.assertThat((Object)keyReporter.getValue(), (Matcher)Matchers.is((Object)"abc def"));
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.ANDROID, Ignore.Driver.FIREFOX, Ignore.Driver.REMOTE, Ignore.Driver.IPHONE, Ignore.Driver.CHROME, Ignore.Driver.SELENESE})
    public void testSendingKeyDownOnly() {
        this.driver.get(this.pages.javascriptPage);
        WebElement keysEventInput = this.driver.findElement(By.id((String)"theworks"));
        KeyDownAction pressShift = new KeyDownAction(this.driver, keysEventInput, Keys.SHIFT);
        pressShift.perform();
        WebElement keyLoggingElement = this.driver.findElement(By.id((String)"result"));
        TestBasicKeyboardInterface.assertTrue((String)("Key down event not isolated, got: " + keyLoggingElement.getText()), (boolean)keyLoggingElement.getText().endsWith("keydown"));
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.ANDROID, Ignore.Driver.FIREFOX, Ignore.Driver.REMOTE, Ignore.Driver.IPHONE, Ignore.Driver.CHROME, Ignore.Driver.SELENESE})
    public void testSendingKeyUp() {
        this.driver.get(this.pages.javascriptPage);
        WebElement keysEventInput = this.driver.findElement(By.id((String)"theworks"));
        KeyDownAction pressShift = new KeyDownAction(this.driver, keysEventInput, Keys.SHIFT);
        pressShift.perform();
        WebElement keyLoggingElement = this.driver.findElement(By.id((String)"result"));
        String eventsText = keyLoggingElement.getText();
        TestBasicKeyboardInterface.assertTrue((String)("Key down should be isolated for this test to be meaningful. Got events: " + eventsText), (boolean)eventsText.endsWith("keydown"));
        KeyUpAction releaseShift = new KeyUpAction(this.driver, keysEventInput, Keys.SHIFT);
        releaseShift.perform();
        eventsText = keyLoggingElement.getText();
        TestBasicKeyboardInterface.assertTrue((String)("Key up event not isolated. Got events: " + eventsText), (boolean)eventsText.endsWith("keyup"));
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.ANDROID, Ignore.Driver.FIREFOX, Ignore.Driver.REMOTE, Ignore.Driver.IPHONE, Ignore.Driver.CHROME, Ignore.Driver.SELENESE})
    public void testSendingKeysWithShiftPressed() {
        this.driver.get(this.pages.javascriptPage);
        WebElement keysEventInput = this.driver.findElement(By.id((String)"theworks"));
        keysEventInput.click();
        KeyDownAction pressShift = new KeyDownAction(this.driver, keysEventInput, Keys.SHIFT);
        pressShift.perform();
        SendKeysAction sendLowercase = new SendKeysAction(this.driver, keysEventInput, new CharSequence[]{"ab"});
        sendLowercase.perform();
        KeyUpAction releaseShift = new KeyUpAction(this.driver, keysEventInput, Keys.SHIFT);
        releaseShift.perform();
        WebElement keyLoggingElement = this.driver.findElement(By.id((String)"result"));
        TestBasicKeyboardInterface.assertTrue((String)("Shift key not held, events: " + keyLoggingElement.getText()), (boolean)keyLoggingElement.getText().equals("focus keydown keydown keypress keyup keydown keypress keyup keyup"));
        MatcherAssert.assertThat((Object)keysEventInput.getValue(), (Matcher)Matchers.is((Object)"AB"));
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.ANDROID, Ignore.Driver.FIREFOX, Ignore.Driver.REMOTE, Ignore.Driver.IPHONE, Ignore.Driver.CHROME, Ignore.Driver.SELENESE})
    public void testSendingKeysToActiveElement() {
        this.driver.get(this.pages.bodyTypingPage);
        SendKeysAction someKeys = new SendKeysAction(this.driver, new CharSequence[]{"ab"});
        someKeys.perform();
        WebElement bodyLoggingElement = this.driver.findElement(By.id((String)"body_result"));
        MatcherAssert.assertThat((Object)bodyLoggingElement.getText(), (Matcher)Matchers.is((Object)"keypress keypress"));
        WebElement formLoggingElement = this.driver.findElement(By.id((String)"result"));
        MatcherAssert.assertThat((Object)formLoggingElement.getText(), (Matcher)Matchers.is((Object)""));
    }

    @Ignore(value={Ignore.Driver.ANDROID, Ignore.Driver.FIREFOX, Ignore.Driver.REMOTE, Ignore.Driver.IPHONE, Ignore.Driver.CHROME, Ignore.Driver.SELENESE})
    public void testBasicKeyboardInputOnActiveElement() {
        this.driver.get(this.pages.javascriptPage);
        WebElement keyReporter = this.driver.findElement(By.id((String)"keyReporter"));
        keyReporter.click();
        SendKeysAction sendLowercase = new SendKeysAction(this.driver, new CharSequence[]{"abc def"});
        sendLowercase.perform();
        MatcherAssert.assertThat((Object)keyReporter.getValue(), (Matcher)Matchers.is((Object)"abc def"));
    }
}

