/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.interactions;

import org.openqa.selenium.AbstractDriverTestCase;
import org.openqa.selenium.By;
import org.openqa.selenium.Ignore;
import org.openqa.selenium.JavascriptEnabled;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.ButtonReleaseAction;
import org.openqa.selenium.interactions.ClickAndHoldAction;
import org.openqa.selenium.interactions.ContextClickAction;
import org.openqa.selenium.interactions.DoubleClickAction;
import org.openqa.selenium.interactions.MoveMouseAction;

public class TestBasicMouseInterface
extends AbstractDriverTestCase {
    @Ignore(value={Ignore.Driver.ANDROID, Ignore.Driver.IE, Ignore.Driver.FIREFOX, Ignore.Driver.REMOTE, Ignore.Driver.IPHONE, Ignore.Driver.CHROME, Ignore.Driver.SELENESE})
    private void performDragAndDropWithMouse() {
        this.driver.get(this.pages.draggableLists);
        WebElement dragReporter = this.driver.findElement(By.id((String)"dragging_reports"));
        WebElement toDrag = this.driver.findElement(By.id((String)"rightitem-3"));
        WebElement dragInto = this.driver.findElement(By.id((String)"sortable1"));
        ClickAndHoldAction holdItem = new ClickAndHoldAction(this.driver, toDrag);
        MoveMouseAction moveToSpecificItem = new MoveMouseAction(this.driver, this.driver.findElement(By.id((String)"leftitem-4")));
        MoveMouseAction moveToOtherList = new MoveMouseAction(this.driver, dragInto);
        ButtonReleaseAction drop = new ButtonReleaseAction(this.driver, dragInto);
        TestBasicMouseInterface.assertEquals((String)"Nothing happened.", (String)dragReporter.getText());
        holdItem.perform();
        moveToSpecificItem.perform();
        moveToOtherList.perform();
        TestBasicMouseInterface.assertEquals((String)"Nothing happened. DragOut", (String)dragReporter.getText());
        drop.perform();
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.ANDROID, Ignore.Driver.IE, Ignore.Driver.FIREFOX, Ignore.Driver.REMOTE, Ignore.Driver.IPHONE, Ignore.Driver.CHROME, Ignore.Driver.SELENESE})
    public void testDraggingElementWithMouseMovesItToAnotherList() {
        this.performDragAndDropWithMouse();
        WebElement dragInto = this.driver.findElement(By.id((String)"sortable1"));
        TestBasicMouseInterface.assertEquals((int)6, (int)dragInto.findElements(By.tagName((String)"li")).size());
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.HTMLUNIT, Ignore.Driver.ANDROID, Ignore.Driver.IE, Ignore.Driver.FIREFOX, Ignore.Driver.REMOTE, Ignore.Driver.IPHONE, Ignore.Driver.CHROME, Ignore.Driver.SELENESE})
    public void testDraggingElementWithMouseFiresEvents() {
        this.performDragAndDropWithMouse();
        WebElement dragReporter = this.driver.findElement(By.id((String)"dragging_reports"));
        TestBasicMouseInterface.assertEquals((String)"Nothing happened. DragOut DropIn RightItem 3", (String)dragReporter.getText());
    }

    private boolean isElementAvailable(WebDriver driver, By locator) {
        try {
            driver.findElement(locator);
            return true;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.ANDROID, Ignore.Driver.IE, Ignore.Driver.FIREFOX, Ignore.Driver.REMOTE, Ignore.Driver.IPHONE, Ignore.Driver.CHROME, Ignore.Driver.SELENESE})
    public void testDragAndDrop() throws InterruptedException {
        this.driver.get(this.pages.droppableItems);
        long waitEndTime = System.currentTimeMillis() + 15000L;
        while (!this.isElementAvailable(this.driver, By.id((String)"draggable")) && System.currentTimeMillis() < waitEndTime) {
            Thread.sleep(200L);
        }
        if (!this.isElementAvailable(this.driver, By.id((String)"draggable"))) {
            throw new RuntimeException("Could not find draggable element after 15 seconds.");
        }
        WebElement toDrag = this.driver.findElement(By.id((String)"draggable"));
        WebElement dropInto = this.driver.findElement(By.id((String)"droppable"));
        ClickAndHoldAction holdDrag = new ClickAndHoldAction(this.driver, toDrag);
        MoveMouseAction move = new MoveMouseAction(this.driver, dropInto);
        ButtonReleaseAction drop = new ButtonReleaseAction(this.driver, dropInto);
        holdDrag.perform();
        move.perform();
        drop.perform();
        dropInto = this.driver.findElement(By.id((String)"droppable"));
        String text = dropInto.findElement(By.tagName((String)"p")).getText();
        TestBasicMouseInterface.assertEquals((String)"Dropped!", (String)text);
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.ANDROID, Ignore.Driver.IE, Ignore.Driver.FIREFOX, Ignore.Driver.REMOTE, Ignore.Driver.IPHONE, Ignore.Driver.CHROME, Ignore.Driver.SELENESE})
    public void testDoubleClick() {
        this.driver.get(this.pages.javascriptPage);
        WebElement toDoubleClick = this.driver.findElement(By.id((String)"doubleClickField"));
        DoubleClickAction dblClick = new DoubleClickAction(this.driver, toDoubleClick);
        dblClick.perform();
        TestBasicMouseInterface.assertEquals((String)"Value should change to DoubleClicked.", (String)"DoubleClicked", (String)toDoubleClick.getValue());
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.ANDROID, Ignore.Driver.IE, Ignore.Driver.FIREFOX, Ignore.Driver.REMOTE, Ignore.Driver.IPHONE, Ignore.Driver.CHROME, Ignore.Driver.SELENESE})
    public void testContextClick() {
        this.driver.get(this.pages.javascriptPage);
        WebElement toContextClick = this.driver.findElement(By.id((String)"doubleClickField"));
        ContextClickAction contextClick = new ContextClickAction(this.driver, toContextClick);
        contextClick.perform();
        TestBasicMouseInterface.assertEquals((String)"Value should change to ContextClicked.", (String)"ContextClicked", (String)toContextClick.getValue());
    }
}

