/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.interactions;

import junit.framework.Assert;
import org.jmock.Expectations;
import org.jmock.integration.junit3.MockObjectTestCase;
import org.jmock.internal.ExpectationBuilder;
import org.openqa.selenium.Keyboard;
import org.openqa.selenium.Keys;
import org.openqa.selenium.StubTargetLocator;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.KeyDownAction;
import org.openqa.selenium.interactions.KeyUpAction;
import org.openqa.selenium.interactions.SendKeysAction;
import org.openqa.selenium.interactions.StubInputDeviceDriver;

public class TestIndividualKeyboardActions
extends MockObjectTestCase {
    private Keyboard dummyKeyboard;
    private WebElement dummyElement;
    private WebDriver dummyDriver;
    final String keysToSend = "hello";
    private WebElement dummyActiveElement;

    public void setUp() {
        this.dummyKeyboard = (Keyboard)this.mock(Keyboard.class);
        this.dummyElement = (WebElement)this.mock(WebElement.class, "element");
        this.dummyDriver = (WebDriver)this.mock(WebDriver.class);
        this.dummyActiveElement = (WebElement)this.mock(WebElement.class, "activeElement");
    }

    public void testKeyDownAction() {
        final Keys keyToPress = Keys.SHIFT;
        StubInputDeviceDriver driver = new StubInputDeviceDriver(){

            public WebDriver.TargetLocator switchTo() {
                return new StubTargetLocator(){

                    public WebElement activeElement() {
                        return TestIndividualKeyboardActions.this.dummyElement;
                    }
                };
            }

            public Keyboard getKeyboard() {
                return TestIndividualKeyboardActions.this.dummyKeyboard;
            }
        };
        this.checking((ExpectationBuilder)new Expectations(){
            {
                ((Keyboard)this.one(TestIndividualKeyboardActions.this.dummyKeyboard)).pressKey(keyToPress);
            }
        });
        KeyDownAction keyDown = new KeyDownAction((WebDriver)driver, this.dummyElement, keyToPress);
        keyDown.perform();
    }

    public void testKeyUpAction() {
        final Keys keyToRelease = Keys.CONTROL;
        StubInputDeviceDriver driver = new StubInputDeviceDriver(){

            public WebDriver.TargetLocator switchTo() {
                return new StubTargetLocator(){

                    public WebElement activeElement() {
                        return TestIndividualKeyboardActions.this.dummyElement;
                    }
                };
            }

            public Keyboard getKeyboard() {
                return TestIndividualKeyboardActions.this.dummyKeyboard;
            }
        };
        this.checking((ExpectationBuilder)new Expectations(){
            {
                ((Keyboard)this.one(TestIndividualKeyboardActions.this.dummyKeyboard)).releaseKey(keyToRelease);
            }
        });
        KeyUpAction keyUp = new KeyUpAction((WebDriver)driver, this.dummyElement, keyToRelease);
        keyUp.perform();
    }

    public void testSendKeysActionOnNullElement() {
        this.checking((ExpectationBuilder)new Expectations(){
            {
                ((Keyboard)this.one(TestIndividualKeyboardActions.this.dummyKeyboard)).sendKeys(new CharSequence[]{"hello"});
            }
        });
        StubInputDeviceDriver driver = new StubInputDeviceDriver(){

            public Keyboard getKeyboard() {
                return TestIndividualKeyboardActions.this.dummyKeyboard;
            }
        };
        SendKeysAction sendKeys = new SendKeysAction((WebDriver)driver, new CharSequence[]{"hello"});
        sendKeys.perform();
    }

    public void testSendKeysActionOnTheActiveElement() {
        StubInputDeviceDriver driver = new StubInputDeviceDriver(){

            public WebDriver.TargetLocator switchTo() {
                return new StubTargetLocator(){

                    public WebElement activeElement() {
                        return TestIndividualKeyboardActions.this.dummyElement;
                    }
                };
            }

            public Keyboard getKeyboard() {
                return TestIndividualKeyboardActions.this.dummyKeyboard;
            }
        };
        this.checking((ExpectationBuilder)new Expectations(){
            {
                ((Keyboard)this.one(TestIndividualKeyboardActions.this.dummyKeyboard)).sendKeys(new CharSequence[]{"hello"});
            }
        });
        SendKeysAction sendKeys = new SendKeysAction((WebDriver)driver, this.dummyElement, new CharSequence[]{"hello"});
        sendKeys.perform();
    }

    public void testSendKeysActionOnANonActiveElement() {
        final int[] executeScriptCalls = new int[]{0};
        StubInputDeviceDriver driver = new StubInputDeviceDriver(){

            public WebDriver.TargetLocator switchTo() {
                return new StubTargetLocator(){

                    public WebElement activeElement() {
                        return TestIndividualKeyboardActions.this.dummyActiveElement;
                    }
                };
            }

            public Object executeScript(String script, Object ... args) {
                executeScriptCalls[0] = executeScriptCalls[0] + 1;
                if (executeScriptCalls[0] == 1) {
                    Assert.assertEquals((String)"Expecting dummyActiveElement", (Object)args[0], (Object)TestIndividualKeyboardActions.this.dummyActiveElement);
                } else {
                    Assert.assertEquals((String)"Expecting dummyElement", (Object)args[0], (Object)TestIndividualKeyboardActions.this.dummyElement);
                }
                return null;
            }

            public Keyboard getKeyboard() {
                return TestIndividualKeyboardActions.this.dummyKeyboard;
            }
        };
        this.checking((ExpectationBuilder)new Expectations(){
            {
                ((Keyboard)this.one(TestIndividualKeyboardActions.this.dummyKeyboard)).sendKeys(new CharSequence[]{"hello"});
            }
        });
        SendKeysAction sendKeys = new SendKeysAction((WebDriver)driver, this.dummyElement, new CharSequence[]{"hello"});
        sendKeys.perform();
        TestIndividualKeyboardActions.assertEquals((String)"Should have seen two calls to executeScript", (int)executeScriptCalls[0], (int)2);
    }

    public void testKeyDownActionFailsOnNonModifier() {
        Keys keyToPress = Keys.BACK_SPACE;
        try {
            KeyDownAction keyDown = new KeyDownAction(this.dummyDriver, this.dummyElement, keyToPress);
            TestIndividualKeyboardActions.fail();
        }
        catch (IllegalArgumentException e) {
            TestIndividualKeyboardActions.assertTrue((boolean)e.getMessage().contains("modifier keys"));
        }
    }

    public void testKeyDownActionWithoutAnElement() {
        final Keys keyToPress = Keys.SHIFT;
        StubInputDeviceDriver driver = new StubInputDeviceDriver(){

            public Keyboard getKeyboard() {
                return TestIndividualKeyboardActions.this.dummyKeyboard;
            }
        };
        this.checking((ExpectationBuilder)new Expectations(){
            {
                ((Keyboard)this.one(TestIndividualKeyboardActions.this.dummyKeyboard)).pressKey(keyToPress);
            }
        });
        KeyDownAction downAction = new KeyDownAction((WebDriver)driver, keyToPress);
        downAction.perform();
    }

    public void testKeyUpActionWithoutAnElement() {
        final Keys keyToRelease = Keys.SHIFT;
        StubInputDeviceDriver driver = new StubInputDeviceDriver(){

            public Keyboard getKeyboard() {
                return TestIndividualKeyboardActions.this.dummyKeyboard;
            }
        };
        this.checking((ExpectationBuilder)new Expectations(){
            {
                ((Keyboard)this.one(TestIndividualKeyboardActions.this.dummyKeyboard)).releaseKey(keyToRelease);
            }
        });
        KeyUpAction upAction = new KeyUpAction((WebDriver)driver, keyToRelease);
        upAction.perform();
    }
}

