/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.interactions;

import java.awt.Dimension;
import org.jmock.Expectations;
import org.jmock.integration.junit3.MockObjectTestCase;
import org.jmock.internal.ExpectationBuilder;
import org.openqa.selenium.Mouse;
import org.openqa.selenium.RenderedWebElement;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.ButtonReleaseAction;
import org.openqa.selenium.interactions.ClickAction;
import org.openqa.selenium.interactions.ClickAndHoldAction;
import org.openqa.selenium.interactions.ContextClickAction;
import org.openqa.selenium.interactions.DoubleClickAction;
import org.openqa.selenium.interactions.ElementNotDisplayedException;
import org.openqa.selenium.interactions.MoveMouseAction;
import org.openqa.selenium.interactions.MoveOutsideBoundriesException;
import org.openqa.selenium.interactions.MoveToOffsetAction;
import org.openqa.selenium.interactions.StubInputDeviceDriver;

public class TestIndividualMouseActions
extends MockObjectTestCase {
    private Mouse dummyMouse;
    private WebElement dummyElement;
    private RenderedWebElement dummyRenderedElement;
    private WebDriver fakeDriver;

    public void setUp() {
        this.dummyMouse = (Mouse)this.mock(Mouse.class);
        this.dummyElement = (WebElement)this.mock(WebElement.class);
        this.dummyRenderedElement = (RenderedWebElement)this.mock(RenderedWebElement.class);
        this.fakeDriver = new StubInputDeviceDriver(){

            public Mouse getMouse() {
                return TestIndividualMouseActions.this.dummyMouse;
            }
        };
    }

    public void testMouseClickAndHoldAction() {
        this.checking((ExpectationBuilder)new Expectations(){
            {
                ((Mouse)this.one(TestIndividualMouseActions.this.dummyMouse)).mouseDown(TestIndividualMouseActions.this.dummyElement);
            }
        });
        ClickAndHoldAction action = new ClickAndHoldAction(this.fakeDriver, this.dummyElement);
        action.perform();
    }

    public void testMouseReleaseAction() {
        this.checking((ExpectationBuilder)new Expectations(){
            {
                ((Mouse)this.one(TestIndividualMouseActions.this.dummyMouse)).mouseUp(TestIndividualMouseActions.this.dummyElement);
            }
        });
        ButtonReleaseAction action = new ButtonReleaseAction(this.fakeDriver, this.dummyElement);
        action.perform();
    }

    public void testMouseClickAction() {
        this.checking((ExpectationBuilder)new Expectations(){
            {
                ((Mouse)this.one(TestIndividualMouseActions.this.dummyMouse)).click(TestIndividualMouseActions.this.dummyElement);
            }
        });
        ClickAction action = new ClickAction(this.fakeDriver, this.dummyElement);
        action.perform();
    }

    public void testMouseDoubleClickAction() {
        this.checking((ExpectationBuilder)new Expectations(){
            {
                ((Mouse)this.one(TestIndividualMouseActions.this.dummyMouse)).doubleClick(TestIndividualMouseActions.this.dummyElement);
            }
        });
        DoubleClickAction action = new DoubleClickAction(this.fakeDriver, this.dummyElement);
        action.perform();
    }

    public void testMouseMoveAction() {
        this.checking((ExpectationBuilder)new Expectations(){
            {
                ((Mouse)this.one(TestIndividualMouseActions.this.dummyMouse)).mouseMove(TestIndividualMouseActions.this.dummyElement);
            }
        });
        MoveMouseAction action = new MoveMouseAction(this.fakeDriver, this.dummyElement);
        action.perform();
    }

    public void testMouseMoveToCoordinatesFailsOnNonRenderedWebElement() {
        try {
            MoveToOffsetAction action = new MoveToOffsetAction(this.fakeDriver, this.dummyElement, 20, 20);
            TestIndividualMouseActions.fail((String)"Was not supposed to do a move to offset not on a RenderedWebElement");
        }
        catch (ElementNotDisplayedException elementNotDisplayedException) {
            // empty catch block
        }
    }

    public void testMouseMoveActionToCoordinatesInElement() {
        this.checking((ExpectationBuilder)new Expectations(){
            {
                ((RenderedWebElement)this.one(TestIndividualMouseActions.this.dummyRenderedElement)).getSize();
                this.will(7.returnValue((Object)new Dimension(50, 50)));
                ((Mouse)this.one(TestIndividualMouseActions.this.dummyMouse)).mouseMove((WebElement)TestIndividualMouseActions.this.dummyRenderedElement, 20L, 20L);
            }
        });
        MoveToOffsetAction action = new MoveToOffsetAction(this.fakeDriver, (WebElement)this.dummyRenderedElement, 20, 20);
        action.perform();
    }

    public void testMouseMoveActionToCoordinatesOutsideElementFails() {
        this.checking((ExpectationBuilder)new Expectations(){
            {
                ((RenderedWebElement)this.one(TestIndividualMouseActions.this.dummyRenderedElement)).getSize();
                this.will(8.returnValue((Object)new Dimension(20, 20)));
            }
        });
        try {
            MoveToOffsetAction action = new MoveToOffsetAction(this.fakeDriver, (WebElement)this.dummyRenderedElement, 50, 50);
            action.perform();
            TestIndividualMouseActions.fail((String)"Was not supposed to be able to move outside element boundries.");
        }
        catch (MoveOutsideBoundriesException moveOutsideBoundriesException) {
            // empty catch block
        }
    }

    public void testMouseContextClickAction() {
        this.checking((ExpectationBuilder)new Expectations(){
            {
                ((Mouse)this.one(TestIndividualMouseActions.this.dummyMouse)).contextClick(TestIndividualMouseActions.this.dummyElement);
            }
        });
        ContextClickAction action = new ContextClickAction(this.fakeDriver, this.dummyElement);
        action.perform();
    }
}

