/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal;

import junit.framework.TestCase;
import org.openqa.selenium.internal.Base64Encoder;

public class Base64EncoderTest
extends TestCase {
    private Base64Encoder encoder = new Base64Encoder();

    public void testEncodesEntireByteArrayAsString() {
        byte[] input = "hello world".getBytes();
        String expected = "aGVsbG8gd29ybGQ=";
        Base64EncoderTest.assertEquals((String)expected, (String)this.encoder.encode(input));
        this.assertByteArrayEquals(input, this.encoder.decode(expected));
    }

    public void testWrapsLinesAt76Chars() {
        byte[] input = "hello world. hello world. hello world. hello world. hello world. hello world. hello world. hello world. hello world. hello world. hello world. hello world. hello world. hello world. ".getBytes();
        String expected = "aGVsbG8gd29ybGQuIGhlbGxvIHdvcmxkLiBoZWxsbyB3b3JsZC4gaGVsbG8gd29ybGQuIGhlbGxv\nIHdvcmxkLiBoZWxsbyB3b3JsZC4gaGVsbG8gd29ybGQuIGhlbGxvIHdvcmxkLiBoZWxsbyB3b3Js\nZC4gaGVsbG8gd29ybGQuIGhlbGxvIHdvcmxkLiBoZWxsbyB3b3JsZC4gaGVsbG8gd29ybGQuIGhl\nbGxvIHdvcmxkLiA=";
        Base64EncoderTest.assertEquals((String)expected, (String)this.encoder.encode(input));
        this.assertByteArrayEquals(input, this.encoder.decode(expected));
    }

    public void testPadsSingleMissingByteWhenNotMultipleOfThree() {
        byte[] input = new byte[]{1, 2, 3, 4, 5};
        String expected = "AQIDBAU=";
        Base64EncoderTest.assertEquals((String)expected, (String)this.encoder.encode(input));
        this.assertByteArrayEquals(input, this.encoder.decode(expected));
    }

    public void testPadsDoubleMissingByteWhenNotMultipleOfThree() {
        byte[] input = new byte[]{1, 2, 3, 4};
        String expected = "AQIDBA==";
        Base64EncoderTest.assertEquals((String)expected, (String)this.encoder.encode(input));
        this.assertByteArrayEquals(input, this.encoder.decode(expected));
    }

    public void testDoesNotPadWhenMultipleOfThree() {
        byte[] input = new byte[]{1, 2, 3, 4, 5, 6};
        String expected = "AQIDBAUG";
        Base64EncoderTest.assertEquals((String)expected, (String)this.encoder.encode(input));
        this.assertByteArrayEquals(input, this.encoder.decode(expected));
    }

    public void testHandlesAllPositiveBytes() {
        byte[] input = new byte[127];
        for (int i = 0; i < 126; ++i) {
            input[i] = (byte)(i + 1);
        }
        String expected = "AQIDBAUGBwgJCgsMDQ4PEBESExQVFhcYGRobHB0eHyAhIiMkJSYnKCkqKywtLi8wMTIzNDU2Nzg5\nOjs8PT4/QEFCQ0RFRkdISUpLTE1OT1BRUlNUVVZXWFlaW1xdXl9gYWJjZGVmZ2hpamtsbW5vcHFy\nc3R1dnd4eXp7fH1+AA==";
        Base64EncoderTest.assertEquals((String)expected, (String)this.encoder.encode(input));
        this.assertByteArrayEquals(input, this.encoder.decode(expected));
    }

    public void testHandlesAllNegativeBytes() {
        byte[] input = new byte[128];
        for (int i = 0; i < 127; ++i) {
            input[i] = (byte)(-1 - i);
        }
        String expected = "//79/Pv6+fj39vX08/Lx8O/u7ezr6uno5+bl5OPi4eDf3t3c29rZ2NfW1dTT0tHQz87NzMvKycjH\nxsXEw8LBwL++vby7urm4t7a1tLOysbCvrq2sq6qpqKempaSjoqGgn56dnJuamZiXlpWUk5KRkI+O\njYyLiomIh4aFhIOCgQA=";
        Base64EncoderTest.assertEquals((String)expected, (String)this.encoder.encode(input));
        this.assertByteArrayEquals(input, this.encoder.decode(expected));
    }

    public void testHandlesZeroByte() {
        byte[] input = new byte[]{0, 0, 0, 0};
        String expected = "AAAAAA==";
        Base64EncoderTest.assertEquals((String)expected, (String)this.encoder.encode(input));
        this.assertByteArrayEquals(input, this.encoder.decode(expected));
    }

    public void testProducesEmptyStringWhenNoBytesGiven() {
        byte[] input = new byte[]{};
        String expected = "";
        Base64EncoderTest.assertEquals((String)expected, (String)this.encoder.encode(input));
        this.assertByteArrayEquals(input, this.encoder.decode(expected));
    }

    protected void assertByteArrayEquals(byte[] expected, byte[] actual) {
        Base64EncoderTest.assertEquals((String)this.dumpBytes(expected), (String)this.dumpBytes(actual));
    }

    private String dumpBytes(byte[] bytes) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            result.append(bytes[i]).append(' ');
            if (bytes[i] < 100) {
                result.append(' ');
            }
            if (bytes[i] < 10) {
                result.append(' ');
            }
            if (bytes[i] >= 0) {
                result.append(' ');
            }
            if (i % 16 != 15) continue;
            result.append('\n');
        }
        return result.toString();
    }
}

