/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal;

import java.util.HashMap;
import junit.framework.TestCase;
import org.junit.Test;
import org.openqa.selenium.internal.CommandLine;

public class CommandLineTest
extends TestCase {
    @Test
    public void testSetEnvironmentVariableWithNullKeyThrows() {
        String key = null;
        String value = "Bar";
        CommandLine commandLine = new CommandLine(new String[0]);
        try {
            commandLine.setEnvironmentVariable(key, value);
        }
        catch (IllegalArgumentException iae) {
            CommandLineTest.assertFalse((boolean)commandLine.getEnvironment().containsValue(value));
        }
    }

    @Test
    public void testSetEnvironmentVariableWithNullValueThrows() {
        String key = "Foo";
        String value = null;
        CommandLine commandLine = new CommandLine(new String[0]);
        try {
            commandLine.setEnvironmentVariable(key, value);
        }
        catch (IllegalArgumentException iae) {
            CommandLineTest.assertFalse((boolean)commandLine.getEnvironment().containsKey(key));
        }
    }

    @Test
    public void testSetEnvironmentVariableWithNonNullValueSets() {
        String key = "Foo";
        String value = "Bar";
        CommandLine commandLine = new CommandLine(new String[0]);
        commandLine.setEnvironmentVariable(key, value);
        CommandLineTest.assertEquals((String)value, (String)((String)commandLine.getEnvironment().get(key)));
    }

    @Test
    public void testSetEnvironmentVariablesWithNullValueThrows() {
        HashMap<String, String> input = new HashMap<String, String>();
        input.put("key1", "value1");
        input.put("key2", null);
        CommandLine commandLine = new CommandLine(new String[0]);
        try {
            commandLine.setEnvironmentVariables(input);
        }
        catch (IllegalArgumentException iae) {
            CommandLineTest.assertFalse((boolean)commandLine.getEnvironment().containsKey("key2"));
        }
    }

    @Test
    public void testSetEnvironmentVariablesWithNonNullValueSetsAll() {
        HashMap<String, String> input = new HashMap<String, String>();
        input.put("key1", "value1");
        input.put("key2", "value2");
        CommandLine commandLine = new CommandLine(new String[0]);
        commandLine.setEnvironmentVariables(input);
        CommandLineTest.assertEquals((String)"value1", (String)((String)commandLine.getEnvironment().get("key1")));
        CommandLineTest.assertEquals((String)"value2", (String)((String)commandLine.getEnvironment().get("key2")));
    }

    @Test
    public void testSetDynamicLibraryPathWithNullValueIgnores() {
        String value = null;
        CommandLine commandLine = new CommandLine(new String[0]);
        try {
            commandLine.setDynamicLibraryPath(value);
        }
        catch (IllegalArgumentException iae) {
            CommandLineTest.assertFalse((boolean)commandLine.getEnvironment().containsKey(CommandLine.getLibraryPathPropertyName()));
        }
    }

    @Test
    public void testSetDynamicLibraryPathWithNonNullValueSets() {
        String value = "Bar";
        CommandLine commandLine = new CommandLine(new String[0]);
        try {
            commandLine.setDynamicLibraryPath(value);
        }
        catch (IllegalArgumentException iae) {
            CommandLineTest.assertEquals((String)value, (String)((String)commandLine.getEnvironment().get(CommandLine.getLibraryPathPropertyName())));
        }
    }
}

