/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import junit.framework.TestCase;
import org.junit.Test;
import org.openqa.selenium.internal.FileHandler;
import org.openqa.selenium.internal.TemporaryFilesystem;

public class FileHandlerTest
extends TestCase {
    @Test
    public void testUnzip() throws IOException {
        File testZip = this.writeTestZip(File.createTempFile("testUnzip", "zip"), 25);
        File out = FileHandler.unzip((InputStream)new FileInputStream(testZip));
        FileHandlerTest.assertEquals((int)25, (int)out.list().length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileCopy() throws IOException {
        File newFile = File.createTempFile("testFileCopy", "dst");
        File tmpFile = this.writeTestFile(File.createTempFile("FileUtilTest", "src"));
        FileHandlerTest.assertTrue((newFile.length() == 0L ? 1 : 0) != 0);
        FileHandlerTest.assertTrue((tmpFile.length() > 0L ? 1 : 0) != 0);
        try {
            FileHandler.copy((File)tmpFile, (File)newFile);
            FileHandlerTest.assertEquals((long)tmpFile.length(), (long)newFile.length());
        }
        finally {
            tmpFile.delete();
            newFile.delete();
        }
    }

    @Test
    public void testFileCopyCanFilterBySuffix() throws IOException {
        File source = TemporaryFilesystem.createTempDir((String)"filehandler", (String)"source");
        File textFile = File.createTempFile("example", ".txt", source);
        File xmlFile = File.createTempFile("example", ".xml", source);
        File dest = TemporaryFilesystem.createTempDir((String)"filehandler", (String)"dest");
        FileHandler.copy((File)source, (File)dest, (String)".txt");
        FileHandlerTest.assertTrue((boolean)new File(dest, textFile.getName()).exists());
        FileHandlerTest.assertFalse((boolean)new File(dest, xmlFile.getName()).exists());
    }

    @Test
    public void testCanReadFileAsString() throws IOException {
        String expected = "I like cheese. And peas";
        File file = File.createTempFile("read-file", "test");
        FileWriter writer = new FileWriter(file);
        writer.write(expected);
        ((Writer)writer).close();
        String seen = FileHandler.readAsString((File)file);
        FileHandlerTest.assertEquals((String)expected, (String)seen);
    }

    private File writeTestZip(File file, int files) throws IOException {
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(file));
        for (int i = 0; i < files; ++i) {
            this.writeTestZipEntry(out);
        }
        out.close();
        file.deleteOnExit();
        return file;
    }

    private ZipOutputStream writeTestZipEntry(ZipOutputStream out) throws IOException {
        File testFile = this.writeTestFile(File.createTempFile("testZip", "file"));
        ZipEntry entry = new ZipEntry(testFile.getName());
        out.putNextEntry(entry);
        FileInputStream in = new FileInputStream(testFile);
        byte[] buffer = new byte[16384];
        while (in.read(buffer, 0, 16384) != -1) {
            out.write(buffer);
        }
        out.flush();
        return out;
    }

    private File writeTestFile(File file) throws IOException {
        byte[] byteArray = new byte[16384];
        new Random().nextBytes(byteArray);
        FileOutputStream out = new FileOutputStream(file);
        ((OutputStream)out).write(byteArray);
        ((OutputStream)out).close();
        file.deleteOnExit();
        return file;
    }
}

