/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import junit.framework.TestCase;
import org.openqa.selenium.internal.Cleanly;
import org.openqa.selenium.internal.InProject;
import org.openqa.selenium.internal.TemporaryFilesystem;
import org.openqa.selenium.internal.Zip;

public class ZipTest
extends TestCase {
    private File inputDir;
    private File outputDir;
    private Zip zip;

    protected void setUp() throws Exception {
        super.setUp();
        this.inputDir = TemporaryFilesystem.createTempDir((String)"input", (String)"ziptest");
        this.outputDir = TemporaryFilesystem.createTempDir((String)"output", (String)"ziptest");
        this.zip = new Zip();
    }

    protected void tearDown() throws Exception {
        TemporaryFilesystem.deleteTemporaryFiles();
        super.tearDown();
    }

    public void testShouldCreateAZipWithASingleEntry() throws IOException {
        this.touch(new File(this.inputDir, "example.txt"));
        File output = new File(this.outputDir, "my.zip");
        this.zip.zip(this.inputDir, output);
        ZipTest.assertTrue((boolean)output.exists());
        this.assertZipContains(output, "example.txt");
    }

    public void testShouldZipUpASingleSubDirectory() throws IOException {
        this.touch(new File(this.inputDir, "subdir/example.txt"));
        File output = new File(this.outputDir, "subdir.zip");
        this.zip.zip(this.inputDir, output);
        ZipTest.assertTrue((boolean)output.exists());
        this.assertZipContains(output, "subdir/example.txt");
    }

    public void testShouldZipMultipleDirectories() throws IOException {
        this.touch(new File(this.inputDir, "subdir/example.txt"));
        this.touch(new File(this.inputDir, "subdir2/fishy/food.txt"));
        File output = new File(this.outputDir, "subdir.zip");
        this.zip.zip(this.inputDir, output);
        ZipTest.assertTrue((boolean)output.exists());
        this.assertZipContains(output, "subdir/example.txt");
        this.assertZipContains(output, "subdir2/fishy/food.txt");
    }

    public void testCanUnzipASingleEntry() throws IOException {
        File source = InProject.locate("common/test/java/org/openqa/selenium/internal/single-file.zip");
        this.zip.unzip(source, this.outputDir);
        ZipTest.assertTrue((boolean)new File(this.outputDir, "example.txt").exists());
    }

    public void testCanUnzipAComplexZip() throws IOException {
        File source = InProject.locate("common/test/java/org/openqa/selenium/internal/subfolders.zip");
        this.zip.unzip(source, this.outputDir);
        ZipTest.assertTrue((boolean)new File(this.outputDir, "example.txt").exists());
        ZipTest.assertTrue((boolean)new File(this.outputDir, "subdir/foodyfun.txt").exists());
    }

    public void testWillNotOverwriteAnExistingZip() throws IOException {
        try {
            this.zip.zip(this.inputDir, this.outputDir);
            ZipTest.fail((String)"Should have thrown an exception");
        }
        catch (IOException e) {
            ZipTest.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("already exists"));
        }
    }

    private void assertZipContains(File output, String s) throws IOException {
        ZipEntry entry;
        FileInputStream fis = new FileInputStream(output);
        ZipInputStream zis = new ZipInputStream(fis);
        while ((entry = zis.getNextEntry()) != null) {
            if (!s.equals(entry.getName().replaceAll("\\\\", "/"))) continue;
            return;
        }
        ZipTest.fail((String)("File not in zip: " + s));
    }

    private void touch(File file) throws IOException {
        File parent = file.getParentFile();
        if (!parent.exists()) {
            ZipTest.assertTrue((boolean)parent.mkdirs());
        }
        FileOutputStream fos = new FileOutputStream(file);
        fos.write("".getBytes());
        Cleanly.close((OutputStream)fos);
        ZipTest.assertTrue((boolean)file.exists());
    }
}

