/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.networkutils;

import junit.framework.TestCase;
import org.openqa.selenium.networkutils.NetworkUtils;
import org.openqa.selenium.networkutils.StubNetworkInterfaceProvider;

public class NetworkUtilsTest
extends TestCase {
    public void testGetPrivateLocalAddress() throws Exception {
        NetworkUtils networkUtils = new NetworkUtils(StubNetworkInterfaceProvider.getUbuntu1010SingleNICAndWlan());
        String s = networkUtils.obtainLoopbackIp4Address();
        NetworkUtilsTest.assertEquals((String)"127.0.0.3", (String)s);
        NetworkUtilsTest.assertEquals((String)"chunky.local", (String)networkUtils.getNonLoopbackAddressOfThisMachine());
    }

    public void testPrivateLocalAddress() throws Exception {
        NetworkUtils networkUtils = new NetworkUtils(StubNetworkInterfaceProvider.getWindowsXpWithIp4Only());
        String s = networkUtils.obtainLoopbackIp4Address();
        NetworkUtilsTest.assertEquals((String)"localXhost", (String)s);
        NetworkUtilsTest.assertEquals((String)"myip4.mydomain.com", (String)networkUtils.getNonLoopbackAddressOfThisMachine());
    }

    public void testRHELBox() throws Exception {
        NetworkUtils networkUtils = new NetworkUtils(StubNetworkInterfaceProvider.getRHEL5Box());
        String s = networkUtils.obtainLoopbackIp4Address();
        NetworkUtilsTest.assertEquals((String)"localhost.localdomain", (String)s);
        NetworkUtilsTest.assertEquals((String)"woz-woz23", (String)networkUtils.getNonLoopbackAddressOfThisMachine());
    }

    public void testSolarisBox() throws Exception {
        NetworkUtils networkUtils = new NetworkUtils(StubNetworkInterfaceProvider.getSolarisBox());
        String s = networkUtils.obtainLoopbackIp4Address();
        NetworkUtilsTest.assertEquals((String)"localhost", (String)s);
        NetworkUtilsTest.assertEquals((String)"woz-woz01-adm", (String)networkUtils.getNonLoopbackAddressOfThisMachine());
    }

    public void testUbuntu9X() throws Exception {
        NetworkUtils networkUtils = new NetworkUtils(StubNetworkInterfaceProvider.getUbuntu09XSingleNIC());
        String s = networkUtils.obtainLoopbackIp4Address();
        NetworkUtilsTest.assertEquals((String)"127.0.0.1", (String)s);
        NetworkUtilsTest.assertEquals((String)"157.120.171.97", (String)networkUtils.getNonLoopbackAddressOfThisMachine());
    }

    public void testOsXSnowLeopard() throws Exception {
        NetworkUtils networkUtils = new NetworkUtils(StubNetworkInterfaceProvider.getOsXWiredAndWireless());
        String s = networkUtils.obtainLoopbackIp4Address();
        NetworkUtilsTest.assertEquals((String)"127.0.0.1", (String)s);
        NetworkUtilsTest.assertEquals((String)"192.168.4.1", (String)networkUtils.getNonLoopbackAddressOfThisMachine());
    }

    public void testFreeBsd() throws Exception {
        NetworkUtils networkUtils = new NetworkUtils(StubNetworkInterfaceProvider.getFreeBsd());
        String s = networkUtils.obtainLoopbackIp4Address();
        NetworkUtilsTest.assertEquals((String)"localhost.apache.org", (String)s);
        NetworkUtilsTest.assertEquals((String)"192.168.0.4", (String)networkUtils.getNonLoopbackAddressOfThisMachine());
    }

    public void testVistaBox() throws Exception {
        NetworkUtils networkUtils = new NetworkUtils(StubNetworkInterfaceProvider.getVistaBox());
        String s = networkUtils.obtainLoopbackIp4Address();
        NetworkUtilsTest.assertEquals((String)"127.0.0.1", (String)s);
        NetworkUtilsTest.assertEquals((String)"woz134", (String)networkUtils.getNonLoopbackAddressOfThisMachine());
    }

    public void testWindows7Box() throws Exception {
        NetworkUtils networkUtils = new NetworkUtils(StubNetworkInterfaceProvider.getWindows7Box());
        String s = networkUtils.obtainLoopbackIp4Address();
        NetworkUtilsTest.assertEquals((String)"127.0.0.1", (String)s);
        NetworkUtilsTest.assertEquals((String)"192.168.1.102", (String)networkUtils.getNonLoopbackAddressOfThisMachine());
    }
}

