/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.networkutils;

import java.util.Arrays;
import org.openqa.selenium.networkutils.INetAddress;
import org.openqa.selenium.networkutils.NetworkInterface;
import org.openqa.selenium.networkutils.NetworkInterfaceProvider;

public class StubNetworkInterfaceProvider {
    private StubNetworkInterfaceProvider() {
    }

    private static NetworkInterface newInterface(String interfaceName) {
        return new NetworkInterface(interfaceName, new INetAddress[0]);
    }

    private static NetworkInterface newInterface(String ifName, INetAddress ... interfaces) {
        return new NetworkInterface(ifName, interfaces);
    }

    private static NetworkInterface newInterface(String ifName, String hostName, String hostIp, boolean isLoopback) {
        return StubNetworkInterfaceProvider.newInterface(ifName, new INetAddress(hostName, hostIp, isLoopback));
    }

    private static NetworkInterface newInterface(String ifName, String hostName, String hostIp, String hostName2, String hostIp2, boolean isLoopback) {
        return StubNetworkInterfaceProvider.newInterface(ifName, new INetAddress(hostName, hostIp, isLoopback), new INetAddress(hostName2, hostIp2, isLoopback));
    }

    public static NetworkInterfaceProvider getUbuntu1010SingleNICAndWlan() {
        return new NetworkInterfaceProvider(){

            public Iterable<NetworkInterface> getNetworkInterfaces() {
                return Arrays.asList(StubNetworkInterfaceProvider.newInterface("wlan0", "chunky.local", "169.254.8.180", false), StubNetworkInterfaceProvider.newInterface("eth0", new INetAddress[]{new INetAddress("fe80:0:0:0:21e:33ff:fe24:6295%2", "fe80:0:0:0:21e:33ff:fe24:6295%2", false), new INetAddress("192.168.1.13", "192.168.1.13", false)}), StubNetworkInterfaceProvider.newInterface("lo", new INetAddress[]{new INetAddress("localhost", "0:0:0:0:0:0:0:1%1", true), new INetAddress("localhost", "127.0.0.3", true)}));
            }

            public NetworkInterface getLoInterface() {
                return StubNetworkInterfaceProvider.newInterface("lo", new INetAddress[]{new INetAddress("localhost", "0:0:0:0:0:0:0:1%1", true), new INetAddress("localhost", "127.0.0.3", true)});
            }
        };
    }

    public static NetworkInterfaceProvider getWindowsXpWithIp4Only() {
        return new NetworkInterfaceProvider(){

            public Iterable<NetworkInterface> getNetworkInterfaces() {
                return Arrays.asList(new NetworkInterface("lo", new INetAddress[]{new INetAddress("localXhost", "127.0.0.4", true)}), new NetworkInterface("eth0", new INetAddress[]{new INetAddress("myip4.mydomain.com", "169.254.8.182", false)}));
            }

            public NetworkInterface getLoInterface() {
                return new NetworkInterface("lo", new INetAddress[]{new INetAddress("localXhost", "127.0.0.4", true)});
            }
        };
    }

    public static NetworkInterfaceProvider getRHEL5Box() {
        return new NetworkInterfaceProvider(){

            public Iterable<NetworkInterface> getNetworkInterfaces() {
                return Arrays.asList(new NetworkInterface("eth2", new INetAddress[]{new INetAddress("woz-woz23", "157.120.190.200", false)}), new NetworkInterface("eth0", new INetAddress[]{new INetAddress("woz-woz23-eth0", "10.10.8.101", false)}), new NetworkInterface("lo", new INetAddress[]{new INetAddress("localhost.localdomain", "127.0.0.2", true)}));
            }

            public NetworkInterface getLoInterface() {
                return new NetworkInterface("lo", new INetAddress[]{new INetAddress("localhost.localdomain", "127.0.0.2", true)});
            }
        };
    }

    public static NetworkInterfaceProvider getSolarisBox() {
        return new NetworkInterfaceProvider(){

            public Iterable<NetworkInterface> getNetworkInterfaces() {
                return Arrays.asList(new NetworkInterface("bge1", new INetAddress[]{new INetAddress("woz-woz01-adm", "10.100.8.99", false)}), new NetworkInterface("bge1", new INetAddress[]{new INetAddress("157.120.190.198", "157.120.190.198", false)}), new NetworkInterface("lo", new INetAddress[]{new INetAddress("localhost", "127.0.0.1", true)}));
            }

            public NetworkInterface getLoInterface() {
                return new NetworkInterface("lo", new INetAddress[]{new INetAddress("localhost", "127.0.0.1", true)});
            }
        };
    }

    public static NetworkInterfaceProvider getUbuntu09XSingleNIC() {
        return new NetworkInterfaceProvider(){

            public Iterable<NetworkInterface> getNetworkInterfaces() {
                return Arrays.asList(StubNetworkInterfaceProvider.newInterface("eth0", new INetAddress[]{new INetAddress("fe80:0:0:1:215:41ff:fe3a:1882%2", "e80:0:0:1:215:41ff:fe3a:1882%2", false), new INetAddress("157.120.171.97", "157.120.171.97", false)}), StubNetworkInterfaceProvider.newInterface("lo", new INetAddress[]{new INetAddress("p6-localhost", "0:0:0:0:0:0:0:1%1", true), new INetAddress("playwoz", "127.0.0.1", true)}));
            }

            public NetworkInterface getLoInterface() {
                return StubNetworkInterfaceProvider.newInterface("lo", "p6-localhost", "0:0:0:0:0:0:0:1%1", "playwoz", "127.0.0.1", true);
            }
        };
    }

    public static NetworkInterfaceProvider getOsXWiredAndWireless() {
        return new NetworkInterfaceProvider(){

            public Iterable<NetworkInterface> getNetworkInterfaces() {
                return Arrays.asList(StubNetworkInterfaceProvider.newInterface("vmnet8", "192.168.4.1", "192.168.4.1", false), StubNetworkInterfaceProvider.newInterface("vmnet1", "192.168.166.1", "192.168.166.1", false), new NetworkInterface("en1", new INetAddress[]{new INetAddress("somehost.subd.test.com", "172.12.8.7", false), new INetAddress("2620:0:1042:13:3bb0:35fe:fe7c:629c", "2620:0:1042:13:3bb0:35fe:fe7c:629c", false), new INetAddress("fe80:0:0:0:3bb0:35fe:fe7c:629c%6", "fe80:0:0:0:3bb0:35fe:fe7c:629c%6", false)}), StubNetworkInterfaceProvider.newInterface("en0", new INetAddress[]{new INetAddress("someotherhost.subd.test.com", "172.12.8.9", false), new INetAddress("fe80:0:0:0:6e6d:63ff:fe8c:bd10%4", "fe80:0:0:0:6e6d:63ff:fe8c:bd10%4", false)}), new NetworkInterface("lo0", new INetAddress[]{new INetAddress("localhost", "127.0.0.1", true), new INetAddress("somemachine.local", "fe80:0:0:0:0:0:0:1%1", false), new INetAddress("localhost", "0:0:0:0:0:0:0:1", true)}));
            }

            public NetworkInterface getLoInterface() {
                return null;
            }
        };
    }

    public static NetworkInterfaceProvider getFreeBsd() {
        return new NetworkInterfaceProvider(){

            public Iterable<NetworkInterface> getNetworkInterfaces() {
                return Arrays.asList(StubNetworkInterfaceProvider.newInterface("lo0", "localhost.apache.org", "127.0.0.1", true), StubNetworkInterfaceProvider.newInterface("bge1", "192.168.0.4", "192.168.0.4", false), StubNetworkInterfaceProvider.newInterface("nfe1", new INetAddress[]{new INetAddress("minotaur-2.apache.org", "140.211.11.10", false), new INetAddress("minotaur.apache.org", "140.211.11.9", false)}));
            }

            public NetworkInterface getLoInterface() {
                return null;
            }
        };
    }

    public static NetworkInterfaceProvider getVistaBox() {
        return new NetworkInterfaceProvider(){

            public Iterable<NetworkInterface> getNetworkInterfaces() {
                return Arrays.asList(this.getLoInterface(), StubNetworkInterfaceProvider.newInterface("net0"), StubNetworkInterfaceProvider.newInterface("net1"), StubNetworkInterfaceProvider.newInterface("ppp0"), StubNetworkInterfaceProvider.newInterface("eth0"), StubNetworkInterfaceProvider.newInterface("eth1"), StubNetworkInterfaceProvider.newInterface("ppp1"), StubNetworkInterfaceProvider.newInterface("net2"), StubNetworkInterfaceProvider.newInterface("eth2"), StubNetworkInterfaceProvider.newInterface("net3", "fe80:0:0:0:0:100:7", "fe80:0:0:0:0:10", false), StubNetworkInterfaceProvider.newInterface("eth3", "woz134.wozms", "fe80:0:0:0:4d74", "woz134", "10.0.0.108", false), StubNetworkInterfaceProvider.newInterface("net3", "fe80:0:0:0:0:100:7", "fe80:0:0:0:0:10", false), StubNetworkInterfaceProvider.newInterface("net5", "fe80:0:0:0:0:5efe", "fe80:0:0:0:0:5e", false), StubNetworkInterfaceProvider.newInterface("eth4"), StubNetworkInterfaceProvider.newInterface("net6"), StubNetworkInterfaceProvider.newInterface("net7"), StubNetworkInterfaceProvider.newInterface("eth5"), StubNetworkInterfaceProvider.newInterface("eth6"), StubNetworkInterfaceProvider.newInterface("eth7"), StubNetworkInterfaceProvider.newInterface("eth8"), StubNetworkInterfaceProvider.newInterface("eth9"));
            }

            public NetworkInterface getLoInterface() {
                return StubNetworkInterfaceProvider.newInterface("lo", new INetAddress[]{new INetAddress("0:0:0:0:0:0:0:1", "0:0:0:0:0:0:0:1", true), new INetAddress("hn127.0.0.1", "127.0.0.1", true)});
            }
        };
    }

    public static NetworkInterfaceProvider getWindows7Box() {
        return new NetworkInterfaceProvider(){

            public Iterable<NetworkInterface> getNetworkInterfaces() {
                return Arrays.asList(this.getLoInterface(), StubNetworkInterfaceProvider.newInterface("net0"), StubNetworkInterfaceProvider.newInterface("net1"), StubNetworkInterfaceProvider.newInterface("net2"), StubNetworkInterfaceProvider.newInterface("net3"), StubNetworkInterfaceProvider.newInterface("ppp0"), StubNetworkInterfaceProvider.newInterface("eth0"), StubNetworkInterfaceProvider.newInterface("eth1"), StubNetworkInterfaceProvider.newInterface("eth2"), StubNetworkInterfaceProvider.newInterface("ppp1"), StubNetworkInterfaceProvider.newInterface("net3", "fe80:0:0:0:acc5:fca8:4900:3d5e%11", "fe80:0:0:0:acc5:fca8:4900:3d5e%11", "192.168.1.102", "192.168.1.102", false), StubNetworkInterfaceProvider.newInterface("net4", "fe80:0:0:0:0:5efe:c0a8:166%12", "fe80:0:0:0:0:5efe:c0a8:166%12", false), StubNetworkInterfaceProvider.newInterface("net5", "bruckner", "2001:0:5ef5:79fd:145f:2f8:adef:9d07", "bruckner", "fe80:0:0:0:145f:2f8:adef:9d07%13", false), StubNetworkInterfaceProvider.newInterface("eth4", "fe80:0:0:0:e565:922d:d0ed:88ed%14", "fe80:0:0:0:e565:922d:d0ed:88ed%14", false), StubNetworkInterfaceProvider.newInterface("net6"), StubNetworkInterfaceProvider.newInterface("eth5"), StubNetworkInterfaceProvider.newInterface("eth6"), StubNetworkInterfaceProvider.newInterface("eth7"), StubNetworkInterfaceProvider.newInterface("eth8"), StubNetworkInterfaceProvider.newInterface("eth9"), StubNetworkInterfaceProvider.newInterface("eth10"), StubNetworkInterfaceProvider.newInterface("eth11"), StubNetworkInterfaceProvider.newInterface("net7"));
            }

            public NetworkInterface getLoInterface() {
                return StubNetworkInterfaceProvider.newInterface("lo", new INetAddress[]{new INetAddress("0:0:0:0:0:0:0:1", "0:0:0:0:0:0:0:1", true), new INetAddress("hnx127.0.0.1", "127.0.0.1", true)});
            }
        };
    }
}

